#!/usr/bin/perl -w

use Tk;
use File::Spec::Functions;

# Data

our $phase2targetstatic = 0;
our $phase2targetdynamic = 0;
our $phase3targetstatic = 0;
our $phase3targetdynamic = 0;
our $workdir = 'optiMAX not active';

checkrun();

# GUI aufbauen.

my $top = MainWindow -> new();
$top -> title('optiMAX - remote control');
$top -> geometry("355x120+0+0");
$top -> repeat ( 5000, \&checkrun );

my $runlabel = $top -> Label (-text=>'Active Run:');
my $runtext = $top -> Label (-textvariable=> \$workdir);

$runlabel -> place(-x=>5, -y =>5 );
$runtext -> place(-x=>90, -y => 5 );

my $label1 = $top -> Label (-text=>'Phase 2 target static');
my $label2 = $top -> Label (-text=>'Phase 2 target dynamic');
my $label3 = $top -> Label (-text=>'Phase 3 target static');
my $label4 = $top -> Label (-text=>'Phase 3 target dynamic');

$label1 -> place(-x=>5, -y => 27 );
$label2 -> place(-x=>5, -y => 49);
$label3 -> place(-x=>5, -y => 71);
$label4 -> place(-x=>5, -y => 93);

my $p2s = $top -> Entry (-width=>5,	-textvariable => \$phase2targetstatic );
my $p2d = $top -> Entry (-width=>5,	-textvariable => \$phase2targetdynamic );
my $p3s = $top -> Entry (-width=>5,	-textvariable => \$phase3targetstatic );
my $p3d = $top -> Entry (-width=>5,	-textvariable => \$phase3targetdynamic );

$p2s -> place(-x=>170, -y => 25 );
$p2d -> place(-x=>170, -y => 47 );
$p3s -> place(-x=>170, -y => 69 );
$p3d -> place(-x=>170, -y => 91 );

my $bgt = $top -> Button (	-text =>'get targets',
							-command => \&reinitsettings );
my $bst = $top -> Button (	-text =>'set targets',
							-command => \&writesettings );
my $bsk = $top -> Button (	-text =>'skip randry',
							-command => \&skip );
my $bsp = $top -> Button (	-text =>'stop optiMAX',
							-command => \&stop );


$bgt -> place(-x=>230, -y=> 5, -width=>120);
$bst -> place(-x=>230, -y=> 32, -width=>120);
$bsk -> place(-x=>230, -y=> 59, -width=>120);
$bsp -> place(-x=>230, -y=> 86, -width=>120);

MainLoop;

sub getworkdir
{
	if ( -e 'run' )
	{
    	open(WD, 'run');
		my $newworkdir = <WD>;
		close(WD);
        unlink('run');
		return $newworkdir;
    }
    else
    {
    	return $workdir;
    }
}

sub checkrun
{
	my $changedworkdir = getworkdir();
    if ( $changedworkdir ne $workdir )
    {
    	$workdir = $changedworkdir;
    	reinitsettings();
    }
}


sub stop
{
	skip();
    open(WD, ">$workdir/stop");
    close(WD);
}

sub skip
{
	open(WD, ">$workdir/skip");
    close(WD);
}


sub writesettings
{
    open(RESET, ">".catfile($workdir, "reset.txt"))
	 or die "Can't create resettingsfile: $!\n";

	print RESET "phase2targetstatic = $phase2targetstatic\n";
	print RESET "phase2targetdynamic = $phase2targetdynamic\n";
	print RESET "phase3targetstatic = $phase3targetstatic\n";
	print RESET "phase3targetdynamic = $phase3targetdynamic\n";

	close(RESET);
}

sub reinitsettings
{
	open(SET, catfile($workdir, "settings.txt"))
	 or die "Can't open settingsfile: $!\n";
	my @lines = <SET>;
	chomp @lines;
	foreach my $line ( @lines )
	{
		my @parts = split(/ = /,$line);
		$phase2targetstatic = $parts[1] if ( $parts[0] eq 'phase2targetstatic' );
		$phase2targetdynamic = $parts[1] if ( $parts[0] eq 'phase2targetdynamic' );
		$phase3targetstatic = $parts[1] if ( $parts[0] eq 'phase3targetstatic' );
		$phase3targetdynamic = $parts[1] if ( $parts[0] eq 'phase3targetdynamic' );
	}
	close(SET);
}
