<?php

/*
+---------------------------------------------------------------------------+
| OpenX v2.4                                                                |
| ==========                                                                |
|                                                                           |
| Copyright (c) 2003-2008 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: apu.php 20123 2008-05-12 10:04:45Z david.keen@openx.org $
*/

/**
 *
 * This is autogenerated merged delivery file which contains all files
 * from delivery merged into one output file.
 *
 * !!!Warning!!!
 *
 * Do not edit this file. If you need to do any changes to any delivery PHP file
 * checkout sourcecode from the svn repository, do a necessary changes inside
 * "delivery_dev" folder and regenerate delivery files using command:
 * # ant generate-delivery
 *
 * For more information on ant generator or if you want to check why we do this
 * check out the documentation wiki page:
 * https://developer.openx.org/wiki/OptimizationPractices#GenerateDeliveryAntTask
 *
 */

// Require the initialisation file
function parseDeliveryIniFile($configPath = null, $configFile = null, $sections = true)
{
// Set up the configuration .ini file path location
if (!$configPath) {
$configPath = MAX_PATH . '/var';
}
if ($configFile) {
$configFile = '.' . $configFile;
}
$host = getHostName();
$configFileName = $configPath . '/' . $host . $configFile . '.conf.php';
$conf = @parse_ini_file($configFileName, $sections);
if (isset($conf['realConfig'])) {
// added for backward compatibility - realConfig points to different config
$conf = @parse_ini_file(MAX_PATH . '/var/' . $conf['realConfig'] . '.conf.php', $sections);
}
if (!empty($conf)) {
return $conf;
} elseif ($configFile === '.plugin') {
// For plugins, if no configuration file is found, return the sane default values
$pluginType = basename($configPath);
$defaultConfig = MAX_PATH . '/plugins/' . $pluginType . '/default.plugin.conf.php';
$conf = @parse_ini_file($defaultConfig, $sections);
if ($conf !== false) {
// check for false here - it's possible file doesn't exist
return $conf;
}
echo "OpenX could not read the default configuration file for the {$pluginType} plugin";
exit(1);
}
// Check for a 'default.conf.php' file
$configFileName = $configPath . '/default' . $configFile . '.conf.php';
$conf = @parse_ini_file($configFileName, $sections);
if (isset($conf['realConfig'])) {
// added for backward compatibility - realConfig points to different config
$conf = @parse_ini_file(MAX_PATH . '/var/' . $conf['realConfig'] . '.conf.php', $sections);
}
if (!empty($conf)) {
return $conf;
}
// Check to ensure Max hasn't been installed
if (file_exists(MAX_PATH . '/var/INSTALLED')) {
echo "OpenX has been installed, but no configuration file was found.\n";
exit(1);
}
// Max hasn't been installed, so delivery engine can't run
echo "OpenX has not been installed yet -- please read the INSTALL.txt file.\n";
exit(1);
}
function setupConfigVariables()
{
$GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'] = '|';
$GLOBALS['_MAX']['MAX_COOKIELESS_PREFIX'] = '__';
// Set the URL access mechanism
if (!empty($GLOBALS['_MAX']['CONF']['openads']['requireSSL'])) {
$GLOBALS['_MAX']['HTTP'] = 'https://';
} else {
if (isset($_SERVER['SERVER_PORT'])) {
if (isset($GLOBALS['_MAX']['CONF']['openads']['sslPort'])
&& $_SERVER['SERVER_PORT'] == $GLOBALS['_MAX']['CONF']['openads']['sslPort'])
{
$GLOBALS['_MAX']['HTTP'] = 'https://';
} else {
$GLOBALS['_MAX']['HTTP'] = 'http://';
}
}
}
// Maximum random number (use default if doesn't exist - eg the case when application is upgraded)
$GLOBALS['_MAX']['MAX_RAND'] = isset($GLOBALS['_MAX']['CONF']['priority']['randmax']) ?
$GLOBALS['_MAX']['CONF']['priority']['randmax'] : 2147483647;
// Set time zone, for more info @see setTimeZoneLocation()
if (!empty($GLOBALS['_MAX']['CONF']['timezone']['location'])) {
setTimeZoneLocation($GLOBALS['_MAX']['CONF']['timezone']['location']);
}
}
function setupServerVariables()
{
// PHP-CGI/IIS combination does not set REQUEST_URI
if (empty($_SERVER['REQUEST_URI'])) {
$_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'];
if (!empty($_SERVER['QUERY_STRING'])) {
$_SERVER['REQUEST_URI'] .= '?' . $_SERVER['QUERY_STRING'];
}
}
}
function setupDeliveryConfigVariables()
{
if (!defined('MAX_PATH')) {
define('MAX_PATH', dirname(__FILE__).'/../..');
}
// Ensure that the initialisation has not been run before
if ( !(isset($GLOBALS['_MAX']['CONF']))) {
// Parse the Max configuration file
$GLOBALS['_MAX']['CONF'] = parseDeliveryIniFile();
}
// Set up the common configuration variables
setupConfigVariables();
}
function setTimeZoneLocation($location)
{
if (version_compare(phpversion(), '5.1.0', '>=')) {
// Set new time zone
date_default_timezone_set($location);
} else {
// Set new time zone
putenv("TZ={$location}");
}
}
function getHostName()
{
if (!empty($_SERVER['HTTP_HOST'])) {
$host = explode(':', $_SERVER['HTTP_HOST']);
$host = $host[0];
} else if (!empty($_SERVER['SERVER_NAME'])) {
$host = explode(':', $_SERVER['SERVER_NAME']);
$host = $host[0];
}
return $host;
}
function getHostNameWithPort()
{
if (!empty($_SERVER['HTTP_HOST'])) {
$host = $_SERVER['HTTP_HOST'];
} else if (!empty($_SERVER['SERVER_NAME'])) {
$host = $_SERVER['SERVER_NAME'];
}
return $host;
}
function setupIncludePath()
{
static $checkIfAlreadySet;
if (isset($checkIfAlreadySet)) {
return;
}
$checkIfAlreadySet = true;
// Define the PEAR installation path
$existingPearPath = ini_get('include_path');
$newPearPath = MAX_PATH . DIRECTORY_SEPARATOR.'lib' . DIRECTORY_SEPARATOR . 'pear';
if (!empty($existingPearPath)) {
$newPearPath .= PATH_SEPARATOR . $existingPearPath;
}
if (!ereg("\.", $newPearPath)) {
$newPearPath = '.'.PATH_SEPARATOR . $newPearPath;
}
ini_set('include_path', $newPearPath);
}
function getMinimumRequiredMemory()
{
if (version_compare(phpversion(), '5.2.0', '>=')) {
return $GLOBALS['_MAX']['REQUIRED_MEMORY']['PHP5'];
}
return $GLOBALS['_MAX']['REQUIRED_MEMORY']['PHP4'];
}
function increaseMemoryLimit($setMemory) {
$memory = getMemorySizeInBytes();
if ($memory == -1) {
// unlimited
return true;
}
if ($setMemory > $memory) {
if (@ini_set('memory_limit', $setMemory) === false) {
return false;
}
}
return true;
}
function getMemorySizeInBytes() {
$phpMemory = ini_get('memory_limit');
if (empty($phpMemory) || $phpMemory == -1) {
// unlimited
return -1;
}
$aSize = array(
'G' => 1073741824,
'M' => 1048576,
'K' => 1024
);
$size = $phpMemory;
foreach($aSize as $type => $multiplier) {
$pos = strpos($phpMemory, $type);
if (!$pos) {
$pos = strpos($phpMemory, strtolower($type));
}
if ($pos) {
$size = substr($phpMemory, 0, $pos) * $multiplier;
}
}
return $size;
}
setupServerVariables();
setupDeliveryConfigVariables();
$conf = $GLOBALS['_MAX']['CONF'];
// Set the log file
if (!empty($conf['debug']['logfile'])) {
@ini_set('error_log', MAX_PATH . '/var/' . $conf['debug']['logfile']);
}
// Disable all notices and warnings, as some PAN code still
// generates PHP warnings in places
if (!empty($conf['debug']['production'])) {
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else {
// show all errors when developing
error_reporting(E_ALL);
}
$file = '/lib/max/Delivery/common.php';
$GLOBALS['_MAX']['FILES'][$file] = true;
$file = '/lib/max/Delivery/cookie.php';
$GLOBALS['_MAX']['FILES'][$file] = true;
$GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'] = array();
function MAX_cookieSet($name, $value, $expire = 0)
{
if (!isset($GLOBALS['_MAX']['COOKIE']['CACHE'])) {
$GLOBALS['_MAX']['COOKIE']['CACHE'] = array();
}
$GLOBALS['_MAX']['COOKIE']['CACHE'][$name] = array($value, $expire);
}
function MAX_cookieSetViewerIdAndRedirect($viewerId) {
$conf = $GLOBALS['_MAX']['CONF'];
MAX_cookieSet($conf['var']['viewerId'], $viewerId, _getTimeYearFromNow());
MAX_cookieFlush();
// Determine if the access to OpenX was made using HTTPS
if ($_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) {
$url = MAX_commonConstructSecureDeliveryUrl(basename($_SERVER['PHP_SELF']));
} else {
$url = MAX_commonConstructDeliveryUrl(basename($_SERVER['PHP_SELF']));
}
$url .= "?{$conf['var']['cookieTest']}=1&" . $_SERVER['QUERY_STRING'];
MAX_header("Location: {$url}");
exit;
}
function MAX_cookieFlush()
{
$conf = $GLOBALS['_MAX']['CONF'];
MAX_cookieSendP3PHeaders();
if (!empty($GLOBALS['_MAX']['COOKIE']['CACHE'])) {
// Set cookies
reset($GLOBALS['_MAX']['COOKIE']['CACHE']);
while (list($name,$v) = each ($GLOBALS['_MAX']['COOKIE']['CACHE'])) {
list($value, $expire) = $v;
MAX_setcookie($name, $value, $expire, '/', (!empty($conf['cookie']['domain']) ? $conf['cookie']['domain'] : null));
}
// Clear cache
$GLOBALS['_MAX']['COOKIE']['CACHE'] = array();
}
// Compact all individual cookies into packed except for any cookies for the current bannerid
// We only need to set these packed cookies if new capping data has been merged
$cookieNames = $GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'];
if (!is_array($cookieNames))
return;
// For each type of cookie, repack if necessary
foreach ($cookieNames as $cookieName) {
// We only need to write out the compacted cookie if a new item is to be inserted (or updated)
if (empty($_COOKIE["_{$cookieName}"])) {
continue;
}
switch ($cookieName) {
case $conf['var']['blockAd']            : $expire = _getTimeThirtyDaysFromNow(); break;
case $conf['var']['capAd']              : $expire = _getTimeYearFromNow(); break;
case $conf['var']['sessionCapAd']       : $expire = 0; break;
case $conf['var']['blockCampaign']      : $expire = _getTimeThirtyDaysFromNow(); break;
case $conf['var']['capCampaign']        : $expire = _getTimeYearFromNow(); break;
case $conf['var']['sessionCapCampaign'] : $expire = 0; break;
case $conf['var']['blockZone']          : $expire = _getTimeThirtyDaysFromNow(); break;
case $conf['var']['capZone']            : $expire = _getTimeYearFromNow(); break;
case $conf['var']['sessionCapZone']     : $expire = 0; break;
}
if (!empty($_COOKIE[$cookieName]) && is_array($_COOKIE[$cookieName])) {
$data = array();
foreach ($_COOKIE[$cookieName] as $adId => $value) {
$data[] = "{$adId}.{$value}";
}
// RFC says that maximum cookie data length is 4096 bytes
// So we are assuming that 2048 will be valid in most browsers
// Discard oldest data until we are under the limit
while (strlen(implode('_', $data)) > 2048) {
$data = array_slice($data, 1);
}
MAX_setcookie($cookieName, implode('_', $data), $expire, '/', (!empty($conf['cookie']['domain']) ? $conf['cookie']['domain'] : null));
}
}
}
function _getTimeThirtyDaysFromNow()
{
return MAX_commonGetTimeNow() + 2592000; // 30*24*60*60;
}
function _getTimeYearFromNow()
{
return MAX_commonGetTimeNow() + 31536000; // 365*24*60*60;
}
function _getTimeYearAgo()
{
return MAX_commonGetTimeNow() - 31536000; // 365*24*60*60;
}
function MAX_cookieUnpackCapping()
{
$conf = $GLOBALS['_MAX']['CONF'];
$cookieNames = $GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'];
if (!is_array($cookieNames))
return;
// For each type of cookie, unpack and add any newly set cookies to this array
foreach ($cookieNames as $cookieName) {
if (!empty($_COOKIE[$cookieName])) {
if (!is_array($_COOKIE[$cookieName])) {
$output = array();
$data = explode('_', $_COOKIE[$cookieName]);
foreach ($data as $pair) {
list($name, $value) = explode('.', $pair);
$output[$name] = $value;
}
$_COOKIE[$cookieName] = $output;
}
}
if (!empty($_COOKIE['_' . $cookieName]) && is_array($_COOKIE['_' . $cookieName])) {
foreach ($_COOKIE['_' . $cookieName] as $adId => $cookie) {
if (_isBlockCookie($cookieName)) {
$_COOKIE[$cookieName][$adId] = $cookie;
} else {
if (isset($_COOKIE[$cookieName][$adId])) {
$_COOKIE[$cookieName][$adId] += $cookie;
} else {
$_COOKIE[$cookieName][$adId] = $cookie;
}
}
// Delete the temporary capping cookie
MAX_cookieSet("_{$cookieName}[{$adId}]", false, _getTimeYearAgo());
// Work around a bug in IE where the cookie name is sometimes URL-encoded
MAX_cookieSet("%5F" . urlencode($cookieName.'['.$adId.']'), false, _getTimeYearAgo());
}
}
}
}
function _isBlockCookie($cookieName)
{
if ($cookieName == $GLOBALS['_MAX']['CONF']['var']['blockAd']) {
return true;
}
if ($cookieName == $GLOBALS['_MAX']['CONF']['var']['blockCampaign']) {
return true;
}
if ($cookieName == $GLOBALS['_MAX']['CONF']['var']['blockZone']) {
return true;
}
return false;
}
function MAX_cookieGetUniqueViewerID($create = true)
{
$conf = $GLOBALS['_MAX']['CONF'];
if (isset($_COOKIE[$conf['var']['viewerId']])) {
$userid = $_COOKIE[$conf['var']['viewerId']];
} else {
if ($create) {
$remote_address = $_SERVER['REMOTE_ADDR'];
$local_address  = $conf['webpath']['delivery']; // How do I get the IP address of this server?
// Get the exact time
list($usec, $sec) = explode(" ", microtime());
$time = (float) $usec + (float) $sec;
// Get a random number
$random = mt_rand(0,999999999);
$userid = substr(md5($local_address.$time.$remote_address.$random),0,32);  // Need to find a way to generate this...
$GLOBALS['_MAX']['COOKIE']['newViewerId'] = true;
} else {
$userid = null;
}
}
return $userid;
}
function MAX_cookieGetCookielessViewerID()
{
if (empty($_SERVER['REMOTE_ADDR']) || empty($_SERVER['HTTP_USER_AGENT'])) {
return '';
}
$cookiePrefix = $GLOBALS['_MAX']['MAX_COOKIELESS_PREFIX'];
return $cookiePrefix . substr(md5($_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT']), 0, 32-(strlen($cookiePrefix)));
}
function MAX_cookieSendP3PHeaders() {
// Send P3P headers
if ($GLOBALS['_MAX']['CONF']['p3p']['policies']) {
MAX_header("P3P: ". _generateP3PHeader());
}
}
function MAX_Delivery_cookie_cappingOnRequest()
{
if (isset($GLOBALS['_OA']['invocationType']) && $GLOBALS['_OA']['invocationType'] == 'xml-rpc') {
return true;
}
return !$GLOBALS['_MAX']['CONF']['logging']['adImpressions'];
}
function MAX_Delivery_cookie_setCapping($type, $id, $block = 0, $cap = 0, $sessionCap = 0)
{
$conf = $GLOBALS['_MAX']['CONF'];
$setBlock = false;
if ($cap > 0) {
// This capping cookie requires a "permanent" expiration time
$expire = MAX_commonGetTimeNow() + $conf['cookie']['permCookieSeconds'];
// The unpack capping cookies function adds this value to the counter, so to reset it we add a negative number
if (!isset($_COOKIE[$conf['var']['cap' . $type]][$id])) {
$value = 1;
$setBlock = true;
} else if ($_COOKIE[$conf['var']['cap' . $type]][$id] >= $cap) {
$value = -$_COOKIE[$conf['var']['cap' . $type]][$id]+1;
// Also reset the last-seen when resetting the frequency counter
$setBlock = true;
} else {
$value = 1;
}
MAX_cookieSet("_{$conf['var']['cap' . $type]}[{$id}]", $value, $expire);
}
if ($sessionCap > 0) {
// The unpack capping cookies function deals with imcrementing the counter
// The expiry is set to 0 to make a session cookie
// The unpack capping cookies function adds this value to the counter, so to reset it we add a negative number
if (!isset($_COOKIE[$conf['var']['sessionCap' . $type]][$id])) {
$value = 1;
$setBlock = true;
} else if ($_COOKIE[$conf['var']['sessionCap' . $type]][$id] >= $sessionCap) {
$value = -$_COOKIE[$conf['var']['sessionCap' . $type]][$id]+1;
// Also reset the last-seen when resetting the frequency counter
$setBlock = true;
} else {
$value = 1;
}
MAX_cookieSet("_{$conf['var']['sessionCap' . $type]}[{$id}]", $value, 0);
}
if ($block > 0 || $setBlock) {
// This blocking cookie is limited to 30 days
// Store a cookie using the current time so that the system knows when
// the last time this viewer saw this ad, an ad in this campaign or an
// ad in this zone
MAX_cookieSet("_{$conf['var']['block' . $type]}[{$id}]", MAX_commonGetTimeNow(), _getTimeThirtyDaysFromNow());
}
}
function _generateP3PHeader()
{
$conf = $GLOBALS['_MAX']['CONF'];
$p3p_header = '';
if ($conf['p3p']['policies']) {
if ($conf['p3p']['policyLocation'] != '') {
$p3p_header .= " policyref=\"".$conf['p3p']['policyLocation']."\"";
}
if ($conf['p3p']['policyLocation'] != '' && $conf['p3p']['compactPolicy'] != '') {
$p3p_header .= ", ";
}
if ($conf['p3p']['compactPolicy'] != '') {
$p3p_header .= " CP=\"".$conf['p3p']['compactPolicy']."\"";
}
}
return $p3p_header;
}
$file = '/lib/max/Delivery/remotehost.php';
$GLOBALS['_MAX']['FILES'][$file] = true;
function MAX_remotehostSetInfo($run = false)
{
if (empty($GLOBALS['_OA']['invocationType']) || $run || ($GLOBALS['_OA']['invocationType'] != 'xml-rpc')) {
MAX_remotehostProxyLookup();
MAX_remotehostReverseLookup();
MAX_remotehostSetClientInfo();
MAX_remotehostSetGeoInfo();
}
}
function MAX_remotehostProxyLookup()
{
$conf = $GLOBALS['_MAX']['CONF'];
// Should proxy lookup conversion be performed?
if ($conf['logging']['proxyLookup']) {
// Determine if the viewer has come via an HTTP proxy
$proxy = false;
if (!empty($_SERVER['HTTP_VIA']) || !empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
$proxy = true;
} elseif (!empty($_SERVER['REMOTE_HOST'])) {
$aProxyHosts = array(
'proxy',
'cache',
'inktomi'
);
foreach ($aProxyHosts as $proxyName) {
if (strpos($_SERVER['REMOTE_HOST'], $proxyName) !== false) {
$proxy = true;
break;
}
}
}
// Has the viewer come via an HTTP proxy?
if ($proxy) {
// Try to find the "real" IP address the viewer has come from
$aHeaders = array(
'HTTP_FORWARDED',
'HTTP_FORWARDED_FOR',
'HTTP_X_FORWARDED',
'HTTP_X_FORWARDED_FOR',
'HTTP_CLIENT_IP'
);
foreach ($aHeaders as $header) {
if (!empty($_SERVER[$header])) {
$ip = $_SERVER[$header];
break;
}
}
if (!empty($ip)) {
// The "remote IP" may be a list, ensure that
// only the last item is used in that case
$ip = explode(',', $ip);
$ip = trim($ip[count($ip) - 1]);
// If the found address is not unknown or a private network address
if (($ip != 'unknown') && (!MAX_remotehostPrivateAddress($ip))) {
// Set the "real" remote IP address, and unset
// the remote host (as it will be wrong for the
// newly found IP address) and HTTP_VIA header
// (so that we don't accidently do this twice)
$_SERVER['REMOTE_ADDR'] = $ip;
$_SERVER['REMOTE_HOST'] = '';
$_SERVER['HTTP_VIA']    = '';
}
}
}
}
}
function MAX_remotehostReverseLookup()
{
// Is the remote host name already set?
if (empty($_SERVER['REMOTE_HOST'])) {
// Should reverse lookups be performed?
if ($GLOBALS['_MAX']['CONF']['logging']['reverseLookup']) {
$_SERVER['REMOTE_HOST'] = @gethostbyaddr($_SERVER['REMOTE_ADDR']);
} else {
$_SERVER['REMOTE_HOST'] = $_SERVER['REMOTE_ADDR'];
}
}
}
function MAX_remotehostSetClientInfo()
{
if ($GLOBALS['_MAX']['CONF']['logging']['sniff'] && isset($_SERVER['HTTP_USER_AGENT'])) {
if (!class_exists('phpSniff')) {
include MAX_PATH . '/lib/phpSniff/phpSniff.class.php';
}
$client = new phpSniff($_SERVER['HTTP_USER_AGENT']);
$GLOBALS['_MAX']['CLIENT'] = $client->_browser_info;
}
}
function MAX_remotehostSetGeoInfo()
{
if (!function_exists('parseDeliveryIniFile')) {
function parseDeliveryIniFile($configPath = null, $configFile = null, $sections = true)
{
// Set up the configuration .ini file path location
if (!$configPath) {
$configPath = MAX_PATH . '/var';
}
if ($configFile) {
$configFile = '.' . $configFile;
}
$host = getHostName();
$configFileName = $configPath . '/' . $host . $configFile . '.conf.php';
$conf = @parse_ini_file($configFileName, $sections);
if (isset($conf['realConfig'])) {
// added for backward compatibility - realConfig points to different config
$conf = @parse_ini_file(MAX_PATH . '/var/' . $conf['realConfig'] . '.conf.php', $sections);
}
if (!empty($conf)) {
return $conf;
} elseif ($configFile === '.plugin') {
// For plugins, if no configuration file is found, return the sane default values
$pluginType = basename($configPath);
$defaultConfig = MAX_PATH . '/plugins/' . $pluginType . '/default.plugin.conf.php';
$conf = @parse_ini_file($defaultConfig, $sections);
if ($conf !== false) {
// check for false here - it's possible file doesn't exist
return $conf;
}
echo "OpenX could not read the default configuration file for the {$pluginType} plugin";
exit(1);
}
// Check for a 'default.conf.php' file
$configFileName = $configPath . '/default' . $configFile . '.conf.php';
$conf = @parse_ini_file($configFileName, $sections);
if (isset($conf['realConfig'])) {
// added for backward compatibility - realConfig points to different config
$conf = @parse_ini_file(MAX_PATH . '/var/' . $conf['realConfig'] . '.conf.php', $sections);
}
if (!empty($conf)) {
return $conf;
}
// Check to ensure Max hasn't been installed
if (file_exists(MAX_PATH . '/var/INSTALLED')) {
echo "OpenX has been installed, but no configuration file was found.\n";
exit(1);
}
// Max hasn't been installed, so delivery engine can't run
echo "OpenX has not been installed yet -- please read the INSTALL.txt file.\n";
exit(1);
}
}
$aConf = $GLOBALS['_MAX']['CONF'];
$type = (!empty($aConf['geotargeting']['type'])) ? $aConf['geotargeting']['type'] : null;
if (!is_null($type) && $type != 'none') {
$functionName = 'MAX_Geo_'.$type.'_getInfo';
if (function_exists($functionName)) {
return;
}
@include(MAX_PATH . '/plugins/geotargeting/' . $type . '/' . $type . '.delivery.php');
if (function_exists($functionName)) {
$GLOBALS['_MAX']['CLIENT_GEO'] = $functionName();
}
}
}
function MAX_remotehostPrivateAddress($ip)
{
setupIncludePath();
require_once 'Net/IPv4.php';
// Define the private address networks, see
// http://rfc.net/rfc1918.html
$aPrivateNetworks = array(
'10.0.0.0/8',
'172.16.0.0/12',
'192.168.0.0/16',
'127.0.0.0/24'
);
foreach ($aPrivateNetworks as $privateNetwork) {
if (Net_IPv4::ipInNetwork($ip, $privateNetwork)) {
return true;
}
}
return false;
}
$file = '/lib/max/Delivery/log.php';
$GLOBALS['_MAX']['FILES'][$file] = true;
$file = '/lib/max/Dal/Delivery.php';
$GLOBALS['_MAX']['FILES'][$file] = true;
function MAX_Dal_Delivery_Include()
{
static $included;
if (isset($included)) {
return;
}
$included = true;
$conf = $GLOBALS['_MAX']['CONF'];
if (isset($conf['origin']['type']) && is_readable(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php')) {
require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['origin']['type']) . '.php');
} else {
require(MAX_PATH . '/lib/OA/Dal/Delivery/' . strtolower($conf['database']['type']) . '.php');
}
}
function MAX_Delivery_log_logAdRequest($viewerId, $adId, $creativeId, $zoneId)
{
if (_viewersHostOkayToLog()) {
$conf = $GLOBALS['_MAX']['CONF'];
list($geotargeting, $zoneInfo, $userAgentInfo, $maxHttps) = _prepareLogInfo();
$table = $conf['table']['prefix'] . $conf['table']['data_raw_ad_request'];
MAX_Dal_Delivery_Include();
OA_Dal_Delivery_logAction(
$table,
$viewerId,
$adId,
$creativeId,
$zoneId,
$geotargeting,
$zoneInfo,
$userAgentInfo,
$maxHttps
);
}
}
function MAX_Delivery_log_logAdImpression($viewerId, $adId, $creativeId, $zoneId)
{
if (_viewersHostOkayToLog()) {
$conf = $GLOBALS['_MAX']['CONF'];
list($geotargeting, $zoneInfo, $userAgentInfo, $maxHttps) = _prepareLogInfo();
$table = $conf['table']['prefix'] . $conf['table']['data_raw_ad_impression'];
MAX_Dal_Delivery_Include();
OA_Dal_Delivery_logAction(
$table,
$viewerId,
$adId,
$creativeId,
$zoneId,
$geotargeting,
$zoneInfo,
$userAgentInfo,
$maxHttps
);
}
}
function MAX_Delivery_log_logAdClick($viewerId, $adId, $creativeId, $zoneId)
{
if (_viewersHostOkayToLog()) {
$conf = $GLOBALS['_MAX']['CONF'];
list($geotargeting, $zoneInfo, $userAgentInfo, $maxHttps) = _prepareLogInfo();
$table = $conf['table']['prefix'] . $conf['table']['data_raw_ad_click'];
MAX_Dal_Delivery_Include();
OA_Dal_Delivery_logAction(
$table,
$viewerId,
$adId,
$creativeId,
$zoneId,
$geotargeting,
$zoneInfo,
$userAgentInfo,
$maxHttps
);
}
}
function MAX_Delivery_log_logTrackerImpression($viewerId, $trackerId)
{
if (_viewersHostOkayToLog()) {
$conf = $GLOBALS['_MAX']['CONF'];
if (empty($conf['rawDatabase']['host'])) {
if (!empty($conf['lb']['enabled'])) {
$conf['rawDatabase']['host'] = $_SERVER['SERVER_ADDR'];
} else {
$conf['rawDatabase']['host'] = 'singleDB';
}
}
if (isset($conf['rawDatabase']['serverRawIp'])) {
$serverRawIp = $conf['rawDatabase']['serverRawIp'];
} else {
$serverRawIp = $conf['rawDatabase']['host'];
}
list($geotargeting, $zoneInfo, $userAgentInfo, $maxHttps) = _prepareLogInfo();
$table = $conf['table']['prefix'] . $conf['table']['data_raw_tracker_impression'];
MAX_Dal_Delivery_Include();
$rawTrackerImpressionId = OA_Dal_Delivery_logTracker(
$table,
$viewerId,
$trackerId,
$serverRawIp,
$geotargeting,
$zoneInfo,
$userAgentInfo,
$maxHttps
);
return array('server_raw_tracker_impression_id' => $rawTrackerImpressionId, 'server_raw_ip' => $serverRawIp);
}
return false;
}
function MAX_Delivery_log_logVariableValues($variables, $trackerId, $serverRawTrackerImpressionId, $serverRawIp)
{
$conf = $GLOBALS['_MAX']['CONF'];
// Get the variable information, including the Variable ID
foreach ($variables as $variable) {
if (isset($_GET[$variable['name']])) {
$value = $_GET[$variable['name']];
// Do not save variable if empty or if the JS engine set it to "undefined"
if (!strlen($value) || $value == 'undefined') {
unset($variables[$variable['variable_id']]);
continue;
}
// Sanitize by datatype
switch ($variable['type']) {
case 'int':
case 'numeric':
// Strip useless chars, such as currency
$value = preg_replace('/[^0-9.]/', '', $value);
$value = floatval($value); break;
case 'date':
if (!empty($value)) {
$value = date('Y-m-d H:i:s', strtotime($value));
} else {
$value = '';
}
break;
}
} else {
// Do not save anything if the variable isn't set
unset($variables[$variable['variable_id']]);
continue;
}
$variables[$variable['variable_id']]['value'] = $value;
}
if (count($variables)) {
MAX_Dal_Delivery_Include();
OA_Dal_Delivery_logVariableValues($variables, $serverRawTrackerImpressionId, $serverRawIp);
}
}
function _viewersHostOkayToLog()
{
$conf = $GLOBALS['_MAX']['CONF'];
$agent = strtolower($_SERVER['HTTP_USER_AGENT']);
// Check the user-agent against the list of known browsers (if set)
if (!empty($conf['logging']['enforceUserAgents'])) {
$aKnownBrowsers = explode('|', strtolower($conf['logging']['enforceUserAgents']));
$allowed = false;
foreach ($aKnownBrowsers as $browser) {
if (strpos($agent, $browser) !== false) {
$allowed = true;
break;
}
}
if (!$allowed) return false;
}
// Check the user-agent against the list of known bots (if set)
if (!empty($conf['logging']['ignoreUserAgents'])) {
$aKnownBots = explode('|', strtolower($conf['logging']['ignoreUserAgents']));
foreach ($aKnownBots as $bot) {
if (strpos($agent, $bot) !== false) {
return false;
}
}
}
// Check if this IP address has been blocked
if (!empty($conf['logging']['ignoreHosts'])) {
$hosts = str_replace(',', '|', $conf['logging']['ignoreHosts']);
$hosts = '#('.$hosts.')$#i';
// Format the hosts to ignore in a PCRE format
$hosts = str_replace('.', '\.', $hosts);
$hosts = str_replace('*', '[^.]+', $hosts);
// Check if the viewer's IP address is in the ignore list
if (preg_match($hosts, $_SERVER['REMOTE_ADDR'])) {
return false;
}
// Check if the viewer's hostname is in the ignore list
if (preg_match($hosts, $_SERVER['REMOTE_HOST'])) {
return false;
}
}
return true;
}
function _prepareLogInfo()
{
$conf = $GLOBALS['_MAX']['CONF'];
// Get the Geotargeting information, if required
$geotargeting = array();
if (isset($conf['geotargeting']['saveStats']) && $conf['geotargeting']['saveStats'] && !empty($GLOBALS['_MAX']['CLIENT_GEO'])) {
$geotargeting = $GLOBALS['_MAX']['CLIENT_GEO'];
} else {
$geotargeting = array(
'country_code' => null,
'region' => null,
'city' => null,
'postal_code' => null,
'latitude' => null,
'longitude' => null,
'dma_code' => null,
'area_code' => null,
'organisation' => null,
'netspeed' => null,
'continent' => null);
}
// Get the zone location information, if set up to log this,
// and if possible
$zoneInfo = array();
if ($conf['logging']['pageInfo']) {
if (!empty($_GET['loc'])) {
$zoneInfo = parse_url($_GET['loc']);
} elseif (!empty($_SERVER['HTTP_REFERER'])) {
$zoneInfo = parse_url($_SERVER['HTTP_REFERER']);
} elseif (!empty($GLOBALS['loc'])) {
$zoneInfo = parse_url($GLOBALS['loc']);
}
if (!empty($zoneInfo['scheme'])) {
$zoneInfo['scheme'] = ($zoneInfo['scheme'] == 'https') ? 1 : 0;
}
if (isset($GLOBALS['_MAX']['CHANNELS'])) {
$zoneInfo['channel_ids'] = $GLOBALS['_MAX']['CHANNELS'];
}
}
// Get the operating system and browser type, if required
if ($conf['logging']['sniff'] && isset($GLOBALS['_MAX']['CLIENT'])) {
$userAgentInfo = array(
'os' => $GLOBALS['_MAX']['CLIENT']['os'],
'long_name' => $GLOBALS['_MAX']['CLIENT']['long_name'],
'browser'   => $GLOBALS['_MAX']['CLIENT']['browser'],
);
} else {
$userAgentInfo = array();
}
// Determine if the access to OpenX was made using HTTPS
$maxHttps = 0;  // https is false
if ($_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) {
$maxHttps = 1;   // https is true
}
if (!isset($zoneInfo['channel_ids'])) $zoneInfo['channel_ids'] = null;
if (!isset($zoneInfo['scheme'])) $zoneInfo['scheme'] = null;
if (!isset($zoneInfo['host'])) $zoneInfo['host'] = null;
if (!isset($zoneInfo['path'])) $zoneInfo['path'] = null;
if (!isset($zoneInfo['query'])) $zoneInfo['query'] = null;
if (!isset($userAgentInfo['os'])) $userAgentInfo['os'] = '';
if (!isset($userAgentInfo['browser'])) $userAgentInfo['browser'] = '';
return array($geotargeting, $zoneInfo, $userAgentInfo, $maxHttps);
}
function MAX_Delivery_log_getArrGetVariable($name)
{
$varName = $GLOBALS['_MAX']['CONF']['var'][$name];
return isset($_GET[$varName]) ? explode($GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'], $_GET[$varName]) : array();
}
function MAX_Delivery_log_ensureIntegerSet(&$aArray, $index)
{
if (!is_array($aArray)) {
$aArray = array();
}
if (empty($aArray[$index])) {
$aArray[$index] = 0;
} else {
if (!is_integer($aArray[$index])) {
$aArray[$index] = intval($aArray[$index]);
}
}
}
function MAX_Delivery_log_setAdLimitations($index, $aAds, $aCaps)
{
_setLimitations('Ad', $index, $aAds, $aCaps);
}
function MAX_Delivery_log_setCampaignLimitations($index, $aCampaigns, $aCaps)
{
_setLimitations('Campaign', $index, $aCampaigns, $aCaps);
}
function MAX_Delivery_log_setZoneLimitations($index, $aZones, $aCaps)
{
_setLimitations('Zone', $index, $aZones, $aCaps);
}
function _setLimitations($type, $index, $aItems, $aCaps)
{
// Ensure that the capping values for this item are set
MAX_Delivery_log_ensureIntegerSet($aCaps['block'], $index);
MAX_Delivery_log_ensureIntegerSet($aCaps['capping'], $index);
MAX_Delivery_log_ensureIntegerSet($aCaps['session_capping'], $index);
// Set the capping cookies
MAX_Delivery_cookie_setCapping(
$type,
$aItems[$index],
$aCaps['block'][$index],
$aCaps['capping'][$index],
$aCaps['session_capping'][$index]
);
}
function MAX_commonGetDeliveryUrl($file = null)
{
$conf = $GLOBALS['_MAX']['CONF'];
if (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) {
$url = MAX_commonConstructSecureDeliveryUrl($file);
} else {
$url = MAX_commonConstructDeliveryUrl($file);
}
return $url;
}
function MAX_commonConstructDeliveryUrl($file)
{
$conf = $GLOBALS['_MAX']['CONF'];
return 'http://' . $conf['webpath']['delivery'] . '/' . $file;
}
function MAX_commonConstructSecureDeliveryUrl($file)
{
$conf = $GLOBALS['_MAX']['CONF'];
if ($conf['openads']['sslPort'] != 443) {
// Fix the delivery host
$path = preg_replace('#/#', ':' . $conf['openads']['sslPort'] . '/', $conf['webpath']['deliverySSL']);
} else {
$path = $conf['webpath']['deliverySSL'];
}
return 'https://' . $path . '/' . $file;
}
function MAX_commonConstructPartialDeliveryUrl($file, $ssl = false)
{
$conf = $GLOBALS['_MAX']['CONF'];
if ($ssl) {
return '//' . $conf['webpath']['deliverySSL'] . '/' . $file;
} else {
return '//' . $conf['webpath']['delivery'] . '/' . $file;
}
}
function MAX_commonRemoveSpecialChars(&$var)
{
static $magicQuotes;
if (!isset($magicQuotes)) {
$magicQuotes = get_magic_quotes_gpc();
}
if (isset($var)) {
if (!is_array($var)) {
if ($magicQuotes) {
$var = stripslashes($var);
}
$var = strip_tags($var);
$var = str_replace(array("\n", "\r"), array('', ''), $var);
$var = trim($var);
} else {
array_walk($var, 'MAX_commonRemoveSpecialChars');
}
}
}
function MAX_commonSetNoCacheHeaders()
{
MAX_header('Pragma: no-cache');
MAX_header('Cache-Control: private, max-age=0, no-cache');
MAX_header('Date: '.gmdate('D, d M Y H:i:s', MAX_commonGetTimeNow()).' GMT');
}
function MAX_commonAddslashesRecursive($a)
{
if (is_array($a)) {
reset($a);
while (list($k,$v) = each($a)) {
$a[$k] = MAX_commonAddslashesRecursive($v);
}
reset ($a);
return ($a);
} else {
return is_null($a) ? null : addslashes($a);
}
}
function MAX_commonRegisterGlobalsArray($args = array())
{
static $magic_quotes_gpc;
if (!isset($magic_quotes_gpc)) {
$magic_quotes_gpc = ini_get('magic_quotes_gpc');
}
$found = false;
foreach($args as $key) {
if (isset($_GET[$key])) {
$value = $_GET[$key];
$found = true;
}
if (isset($_POST[$key])) {
$value = $_POST[$key];
$found = true;
}
if ($found) {
if (!$magic_quotes_gpc) {
if (!is_array($value)) {
$value = addslashes($value);
} else {
$value = MAX_commonAddslashesRecursive($value);
}
}
$GLOBALS[$key] = $value;
$found = false;
}
}
}
function MAX_commonDeriveSource($source)
{
return MAX_commonEncrypt(trim(urldecode($source)));
}
function MAX_commonEncrypt($string)
{
$convert = '';
if (isset($string) && substr($string,1,4) != 'obfs' && $GLOBALS['_MAX']['CONF']['delivery']['obfuscate']) {
$strLen = strlen($string);
for ($i=0; $i < $strLen; $i++) {
$dec = ord(substr($string,$i,1));
if (strlen($dec) == 2) {
$dec = 0 . $dec;
}
$dec = 324 - $dec;
$convert .= $dec;
}
$convert = '{obfs:' . $convert . '}';
return ($convert);
} else {
return $string;
}
}
function MAX_commonDecrypt($string)
{
$conf = $GLOBALS['_MAX']['CONF'];
$convert = '';
if (isset($string) && substr($string,1,4) == 'obfs' && $conf['delivery']['obfuscate']) {
$strLen = strlen($string);
for ($i=6; $i < $strLen-1; $i = $i+3) {
$dec = substr($string,$i,3);
$dec = 324 - $dec;
$dec = chr($dec);
$convert .= $dec;
}
return ($convert);
} else {
return($string);
}
}
function MAX_commonInitVariables()
{
MAX_commonRegisterGlobalsArray(array('context', 'source', 'target', 'withText', 'withtext', 'ct0', 'what', 'loc', 'referer', 'zoneid', 'campaignid', 'bannerid', 'clientid'));
global $context, $source, $target, $withText, $withtext, $ct0, $what, $loc, $referer, $zoneid, $campaignid, $bannerid, $clientid;
if (!isset($context)) 	$context = array();
if (!isset($source))	$source = '';
if (!isset($target)) 	$target = '_blank';
if (isset($withText) && !isset($withtext))  $withtext = $withText;
if (!isset($withtext)) 	$withtext = '';
if (!isset($ct0)) 	$ct0 = '';
if (!isset($what)) {
if (!empty($bannerid)) {
$what = 'bannerid:'.$bannerid;
} elseif (!empty($campaignid)) {
$what = 'campaignid:'.$campaignid;
} elseif (!empty($zoneid)) {
$what = 'zone:'.$zoneid;
} else {
$what = '';
}
} elseif (preg_match('/^(.+):(.+)$/', $what, $matches)) {
switch ($matches[1]) {
case 'zoneid':
case 'zone':        $zoneid     = $matches[2]; break;
case 'bannerid':    $bannerid   = $matches[2]; break;
case 'campaignid':  $campaignid = $matches[2]; break;
case 'clientid':    $clientid   = $matches[2]; break;
}
}
// 2.0 backwards compatibility - clientid parameter was used to fetch a campaign
if (!isset($clientid)) $clientid = '';
if (!isset($campaignid))  $campaignid = $clientid;
$source = MAX_commonDeriveSource($source);
if (!empty($loc)) {
$loc = stripslashes($loc);
} elseif (!empty($_SERVER['HTTP_REFERER'])) {
$loc = $_SERVER['HTTP_REFERER'];
} else {
$loc = '';
}
// Set real referer - Only valid if passed in
if (!empty($referer)) {
$_SERVER['HTTP_REFERER'] = stripslashes($referer);
} else {
if (isset($_SERVER['HTTP_REFERER'])) unset($_SERVER['HTTP_REFERER']);
}
$GLOBALS['_MAX']['COOKIE']['LIMITATIONS']['arrCappingCookieNames'] = array(
$GLOBALS['_MAX']['CONF']['var']['blockAd'],
$GLOBALS['_MAX']['CONF']['var']['capAd'],
$GLOBALS['_MAX']['CONF']['var']['sessionCapAd'],
$GLOBALS['_MAX']['CONF']['var']['blockCampaign'],
$GLOBALS['_MAX']['CONF']['var']['capCampaign'],
$GLOBALS['_MAX']['CONF']['var']['sessionCapCampaign'],
$GLOBALS['_MAX']['CONF']['var']['blockZone'],
$GLOBALS['_MAX']['CONF']['var']['capZone'],
$GLOBALS['_MAX']['CONF']['var']['sessionCapZone']);
}
function MAX_commonDisplay1x1()
{
MAX_header('Content-Type: image/gif');
MAX_header('Content-Length: 43');
// 1 x 1 gif
echo base64_decode('R0lGODlhAQABAIAAAP///wAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==');
}
function MAX_commonGetTimeNow()
{
static $now;
if (!isset($now)) {
$now = $GLOBALS['_MAX']['NOW'] = time();
}
return $now;
}
function MAX_setcookie($name, $value, $expire, $path, $domain)
{
if (isset($GLOBALS['_OA']['invocationType']) && $GLOBALS['_OA']['invocationType'] == 'xml-rpc') {
if (!isset($GLOBALS['_OA']['COOKIE']['XMLRPC_CACHE'])) {
$GLOBALS['_OA']['COOKIE']['XMLRPC_CACHE'] = array();
}
$GLOBALS['_OA']['COOKIE']['XMLRPC_CACHE'][$name] = array($value, $expire);
} else {
@setcookie($name, $value, $expire, $path, $domain);
}
}
function MAX_header($value)
{
header($value);
}
function MAX_redirect($url)
{
header('Location: '.$url);
MAX_sendStatusCode(302);
}
function MAX_sendStatusCode($iStatusCode) {
$aConf = $GLOBALS['_MAX']['CONF'];
$arr = array(
100 => 'Continue',
101 => 'Switching Protocols',
200 => 'OK',
201 => 'Created',
202 => 'Accepted',
203 => 'Non-Authoritative Information',
204 => 'No Content',
205 => 'Reset Content',
206 => 'Partial Content',
300 => 'Multiple Choices',
301 => 'Moved Permanently',
302 => 'Found',
303 => 'See Other',
304 => 'Not Modified',
305 => 'Use Proxy',
306 => '[Unused]',
307 => 'Temporary Redirect',
400 => 'Bad Request',
401 => 'Unauthorized',
402 => 'Payment Required',
403 => 'Forbidden',
404 => 'Not Found',
405 => 'Method Not Allowed',
406 => 'Not Acceptable',
407 => 'Proxy Authentication Required',
408 => 'Request Timeout',
409 => 'Conflict',
410 => 'Gone',
411 => 'Length Required',
412 => 'Precondition Failed',
413 => 'Request Entity Too Large',
414 => 'Request-URI Too Long',
415 => 'Unsupported Media Type',
416 => 'Requested Range Not Satisfiable',
417 => 'Expectation Failed',
500 => 'Internal Server Error',
501 => 'Not Implemented',
502 => 'Bad Gateway',
503 => 'Service Unavailable',
504 => 'Gateway Timeout',
505 => 'HTTP Version Not Supported'
);
if (isset($arr[$iStatusCode])) {
$text = $iStatusCode . ' ' . $arr[$iStatusCode];
// Using header('Status: foo') with CGI sapis appears to be deprecated but PHP-CGI seems to discard
// the Reason-Phrase and some webservers do not add a default one. Some bad spiders do not cope
// with that, that's why we added the cgiForceStatusHeader confgiuration directive. If enabled
// with CGI sapis, OpenX will use a "Status: NNN Reason" header, which seems to fix the behaviour
// on the tested webserver (Apache 1.3, running php-cgi)
if (!empty($aConf['delivery']['cgiForceStatusHeader']) && strpos(php_sapi_name(), 'cgi') !== 0) {
header('Status: ' . $text);
} else {
header($_SERVER["SERVER_PROTOCOL"] .' ' . $text);
}
}
}
function MAX_commonPackContext($context = array())
{
//return base64_encode(serialize($context));
$include = array();
$exclude = array();
foreach ($context as $idx => $value) {
reset($value);
list($key, $value) = each($value);
list($item,$id) = explode(':', $value);
switch ($item) {
case 'campaignid':  $value = 'c:' . $id; break;
case 'bannerid':    $value = 'b:' . $id; break;
case 'companionid': $value = 'p:' . $id; break;
}
switch ($key) {
case '!=': $exclude[] = $value; break;
case '==': $include[] = $value; break;
}
}
return base64_encode(implode('#', $exclude) . '|' . implode('#', $include));
}
function MAX_commonUnpackContext($context = '')
{
//return unserialize(base64_decode($context));
list($exclude,$include) = explode('|', base64_decode($context));
return array_merge(_convertContextArray('!=', explode('#', $exclude)), _convertContextArray('==', explode('#', $include)));
}
function _convertContextArray($key, $array)
{
$unpacked = array();
foreach ($array as $value) {
if (empty($value)) { continue; }
list($item, $id) = explode(':', $value);
switch ($item) {
case 'c': $unpacked[] = array($key => 'campaignid:'. $id); break;
case 'b': $unpacked[] = array($key => 'bannerid:' .  $id); break;
case 'p': $unpacked[] = array($key => 'companionid:'.$id); break;
}
}
return $unpacked;
}
$file = '/lib/max/Delivery/cache.php';
$GLOBALS['_MAX']['FILES'][$file] = true;
define ('OA_DELIVERY_CACHE_FUNCTION_ERROR', 'Function call returned an error');
$GLOBALS['OA_Delivery_Cache'] = array(
'path'   => MAX_PATH.'/var/cache/',
'prefix' => 'deliverycache_',
'host'   => getHostName(),
'expiry' => $GLOBALS['_MAX']['CONF']['delivery']['cacheExpire']
);
if (!empty($GLOBALS['_MAX']['CONF']['delivery']['cachePath'])) {
$GLOBALS['OA_Delivery_Cache']['path'] = trim($GLOBALS['_MAX']['CONF']['delivery']['cachePath']).'/';
}
function OA_Delivery_Cache_fetch($name, $isHash = false, $expiryTime = null)
{
$filename = OA_Delivery_Cache_buildFileName($name, $isHash);
$cache_complete = false;
$cache_contents = '';
// We are assuming that most of the time cache will exists
$ok = @include($filename);
if ($ok && $cache_complete == true) {
// Make sure that the cache name matches
if ($cache_name != $name) {
return false;
}
// The method used to implement cache expiry imposes two cache writes if the cache is
// expired and the database is available, but avoid the need to check for file existence
// and modification time.
if ($expiryTime === null) {
$expiryTime = $GLOBALS['OA_Delivery_Cache']['expiry'];
}
$now = MAX_commonGetTimeNow();
if (    (isset($cache_time) && $cache_time + $expiryTime < $now)
|| (isset($cache_expire) && $cache_expire < $now) )
{
// Update expiry, needed to enable permanent caching if needed
OA_Delivery_Cache_store($name, $cache_contents, $isHash);
return false;
}
return $cache_contents;
}
return false;
}
function OA_Delivery_Cache_store($name, $cache, $isHash = false, $expireAt = null)
{
if ($cache === OA_DELIVERY_CACHE_FUNCTION_ERROR) {
// Don't store the result to enable permanent caching
return false;
}
if (!is_writable($GLOBALS['OA_Delivery_Cache']['path'])) {
return false;
}
$filename = OA_Delivery_Cache_buildFileName($name, $isHash);
$cache_literal  = "<"."?php\n\n";
$cache_literal .= "$"."cache_contents   = ".var_export($cache, true).";\n\n";
$cache_literal .= "$"."cache_name       = '".addcslashes($name, "\\'")."';\n";
$cache_literal .= "$"."cache_time       = ".MAX_commonGetTimeNow().";\n";
if ($expireAt !== null) {
$cache_literal .= "$"."cache_expire     = ".$expireAt.";\n";
}
$cache_literal .= "$"."cache_complete   = true;\n\n";
$cache_literal .= "?".">";
// Write cache to a temp file, then rename it, overwritng the old cache
// On *nix systems this should guarantee atomicity
$tmp_filename = tempnam($GLOBALS['OA_Delivery_Cache']['path'], $GLOBALS['OA_Delivery_Cache']['prefix'].'tmp_');
if ($fp = @fopen($tmp_filename, 'wb')) {
@fwrite ($fp, $cache_literal, strlen($cache_literal));
@fclose ($fp);
if (!@rename($tmp_filename, $filename)) {
// On some systems rename() doesn't overwrite destination
@unlink($filename);
if (!@rename($tmp_filename, $filename)) {
// Make sure that no temporary file is left over
// if the destination is not writable
@unlink($tmp_filename);
}
}
return true;
}
return false;
}
function OA_Delivery_Cache_store_return($name, $cache, $isHash = false, $expireAt = null)
{
if (OA_Delivery_Cache_store($name, $cache, $isHash, $expireAt)) {
return $cache;
}
return OA_Delivery_Cache_fetch($name, $isHash);
}
function OA_Delivery_Cache_delete($name = '')
{
if ($name != '') {
$filename = OA_Delivery_Cache_buildFileName($name);
if (file_exists($filename)) {
@unlink ($filename);
return true;
}
} else {
$cachedir = @opendir($GLOBALS['OA_Delivery_Cache']['path']);
while (false !== ($filename = @readdir($cachedir))) {
if (preg_match("#^{$GLOBALS['OA_Delivery_Cache']['prefix']}[0-9A-F]{32}.php$#i", $filename))
@unlink ($filename);
}
@closedir($cachedir);
return true;
}
return false;
}
function OA_Delivery_Cache_info()
{
$result = array();
$cachedir = @opendir($GLOBALS['OA_Delivery_Cache']['path']);
while (false !== ($filename = @readdir($cachedir))) {
if (preg_match("#^{$GLOBALS['OA_Delivery_Cache']['prefix']}[0-9A-F]{32}.php$#i", $filename)) {
$cache_complete = false;
$cache_contents = '';
$cache_name     = '';
$ok = @include($filename);
if ($ok && $cache_complete == true) {
$result[$cache_name] = strlen(serialize($cache_contents));
}
}
}
@closedir($cachedir);
return $result;
}
function OA_Delivery_Cache_buildFileName($name, $isHash = false)
{
if(!$isHash) {
// If not a hash yet
$name = md5($name);
}
return $GLOBALS['OA_Delivery_Cache']['path'].$GLOBALS['OA_Delivery_Cache']['prefix'].$name.'.php';
}
function OA_Delivery_Cache_getName($functionName)
{
$args = func_get_args();
$args[0] = strtolower(str_replace('MAX_cacheGet', '', $args[0]));
return join('^', $args).'@'.$GLOBALS['OA_Delivery_Cache']['host'];
}
function MAX_cacheGetAd($ad_id, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $ad_id);
if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aRows = OA_Dal_Delivery_getAd($ad_id);
$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
}
return $aRows;
}
function MAX_cacheGetZoneLinkedAds($zoneId, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $zoneId);
if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aRows = OA_Dal_Delivery_getZoneLinkedAds($zoneId);
$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
}
return $aRows;
}
function MAX_cacheGetZoneInfo($zoneId, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $zoneId);
if (!$cached || ($aRows = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aRows = OA_Dal_Delivery_getZoneInfo($zoneId);
$aRows = OA_Delivery_Cache_store_return($sName, $aRows);
}
return $aRows;
}
function MAX_cacheGetLinkedAds($search, $campaignid, $laspart, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $search, $campaignid, $laspart);
if (!$cached || ($aAds = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aAds = OA_Dal_Delivery_getLinkedAds($search, $campaignid, $laspart);
$aAds = OA_Delivery_Cache_store_return($sName, $aAds);
}
return $aAds;
}
function MAX_cacheGetCreative($filename, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $filename);
if (!$cached || ($aCreative = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aCreative = OA_Dal_Delivery_getCreative($filename);
$aCreative['contents'] = addslashes(serialize($aCreative['contents']));
$aCreative = OA_Delivery_Cache_store_return($sName, $aCreative);
}
$aCreative['contents'] = unserialize(stripslashes($aCreative['contents']));
return $aCreative;
}
function MAX_cacheGetTracker($trackerid, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $trackerid);
if (!$cached || ($aTracker = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aTracker = OA_Dal_Delivery_getTracker($trackerid);
$aTracker = OA_Delivery_Cache_store_return($sName, $aTracker, $isHash = true);
}
return $aTracker;
}
function MAX_cacheGetTrackerVariables($trackerid, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $trackerid);
if (!$cached || ($aVariables = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$aVariables = OA_Dal_Delivery_getTrackerVariables($trackerid);
$aVariables = OA_Delivery_Cache_store_return($sName, $aVariables);
}
return $aVariables;
}
function MAX_cacheCheckIfMaintenanceShouldRun($cached = true)
{
// Default delay is 5 minutes
$interval    = $GLOBALS['_MAX']['CONF']['maintenance']['operationInterval'] * 60;
$delay       = !empty($GLOBALS['_MAX']['CONF']['maintenance']['autoMaintenanceDelay']) ?
$GLOBALS['_MAX']['CONF']['maintenance']['autoMaintenanceDelay'] * 60 :
300;
// Auto-maintenance is disabled if the delay is lower than the OI
if ($delay <= 0 || $delay >= $interval) {
return false;
}
$now         = MAX_commonGetTimeNow();
$today       = strtotime(date('Y-m-d'), $now);
$nextRunTime = $today + (floor(($now - $today) / $interval) + 1) * $interval + $delay;
// Adding the delay could shift the time to the next operation interval,
// make sure to fix it in case it happens
if ($nextRunTime - $now > $interval) {
$nextRunTime -= $interval;
}
$cName  = OA_Delivery_Cache_getName(__FUNCTION__);
if (!$cached || ($lastRunTime = OA_Delivery_Cache_fetch($cName)) === false) {
MAX_Dal_Delivery_Include();
$lastRunTime = OA_Dal_Delivery_getMaintenanceInfo();
// Cache until the next operation interval if scheduled maintenance was run
// during the delay
if ($lastRunTime >= $nextRunTime - $delay) {
$nextRunTime += $interval;
}
OA_Delivery_Cache_store($cName, $lastRunTime, false, $nextRunTime);
}
return $lastRunTime < $nextRunTime - $interval;
}
function MAX_cacheGetChannelLimitations($channelid, $cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__, $channelid);
if (!$cached || ($limitations = OA_Delivery_Cache_fetch($sName)) === false) {
MAX_Dal_Delivery_Include();
$limitations = OA_Dal_Delivery_getChannelLimitations($channelid);
$limitations = OA_Delivery_Cache_store_return($sName, $limitations);
}
return $limitations;
}
function MAX_cacheGetGoogleJavaScript($cached = true)
{
$sName  = OA_Delivery_Cache_getName(__FUNCTION__);
if (!$cached || ($output = OA_Delivery_Cache_fetch($sName)) === false) {
include MAX_PATH . '/lib/max/Delivery/google.php';
$output = MAX_googleGetJavaScript();
$output = OA_Delivery_Cache_store_return($sName, $output);
}
return $output;
}
// Set the viewer's remote information used in logging
// and delivery limitation evaluation
MAX_remotehostSetInfo();
// Set common delivery parameters in the global scope
MAX_commonInitVariables();
// Unpack the packed capping cookies
MAX_cookieUnpackCapping();
// Required files
function MAX_limitationsCheckAcl($row, $source = '')
{
if (!empty($row['compiledlimitation'])) {
static $aIncludedPlugins;
if (!isset($aIncludedPlugins)) {
$aIncludedPlugins = array();
}
// Set to true in case of error in eval
$result = true;
// Include required delivery files...
if(strlen($row['acl_plugins'])) {
$acl_plugins = explode(',', $row['acl_plugins']);
foreach ($acl_plugins as $acl_plugin) {
list($package, $name) = explode(':', $acl_plugin);
$pluginName = MAX_PATH . "/plugins/deliveryLimitations/{$package}/{$name}.delivery.php";
if (!isset($aIncludedPlugins[$pluginName])) {
require($pluginName);
$aIncludedPlugins[$pluginName] = true;
}
}
}
$GLOBALS['_MAX']['CHANNELS'] = '';
@eval('$result = (' . $row['compiledlimitation'] . ');');
if (!$result)
{
unset($GLOBALS['_MAX']['CHANNELS']);
}
else
{
$GLOBALS['_MAX']['CHANNELS'] .= $GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'];
}
return $result;
} else {
return true;
}
}
function MAX_limitationsIsAdForbidden($aAd)
{
$adId = $aAd['ad_id'];
$campaignId = $aAd['placement_id'];
return (_limitationsIsAdCapped($adId, $aAd['cap_ad'], $aAd['session_cap_ad'], $aAd['block_ad']) ||
_limitationsIsCampaignCapped($campaignId, $aAd['cap_campaign'], $aAd['session_cap_campaign'], $aAd['block_campaign']));
}
function MAX_limitationsIsZoneForbidden($zoneId, $aCapping)
{
$capZone = isset($aCapping['cap_zone']) ? $aCapping['cap_zone'] : null;
$sessionCapZone = isset($aCapping['session_cap_zone']) ? $aCapping['session_cap_zone'] : null;
$blockZone = isset($aCapping['block_zone']) ? $aCapping['block_zone'] : null;
return (_limitationsIsZoneCapped($zoneId, $capZone, $sessionCapZone, $blockZone));
}
function _limitationsIsAdCapped($adId, $cap, $sessionCap = 0, $block)
{
return _limitationsIsCapped('Ad', $adId, $cap, $sessionCap, $block);
}
function _limitationsIsCampaignCapped($campaignId, $cap, $sessionCap = 0, $block)
{
return _limitationsIsCapped('Campaign', $campaignId, $cap, $sessionCap, $block);
}
function _limitationsIsZoneCapped($zoneId, $cap, $sessionCap = 0, $block)
{
return _limitationsIsCapped('Zone', $zoneId, $cap, $sessionCap, $block);
}
function _limitationsIsCapped($type, $id, $cap, $sessionCap, $block)
{
// Always return true (capped) if cookies have been disabled by the viewer
if (_areCookiesDisabled(($cap > 0) || ($sessionCap > 0) || ($block > 0))) {
return true;
}
// Get the capping cookie name from the configuration file
$conf = $GLOBALS['_MAX']['CONF'];
$cookieName = $conf['var']['cap' . $type];
// How many times (total) has the item been by the viewer?
if (isset($_COOKIE[$cookieName][$id])) {
$totalImpressions = $_COOKIE[$cookieName][$id];
}
// Get the session capping cookie name from the configuration file
$cookieName = $conf['var']['sessionCap' . $type];
// How many times (session) has the item been by the viewer?
if (isset($_COOKIE[$cookieName][$id])) {
$sessionImpressions = $_COOKIE[$cookieName][$id];
}
// When was the ad last seen
$cookieName = $conf['var']['block' . $type];
if (isset($_COOKIE[$cookieName][$id])) {
$lastSeen = $_COOKIE[$cookieName][$id];
}
// If the ad has been seen the requisite number of times...
if ((($cap > 0) && isset($totalImpressions) && ($totalImpressions >= $cap)) ||
(($sessionCap > 0) && isset($sessionImpressions) && ($sessionImpressions >= $sessionCap))) {
if ($block > 0 && MAX_commonGetTimeNow() > $lastSeen + $block) {
// This ad was last seen outside the block window, so it can now be seen again
// The log mechanism will deal with resetting the frequency counter
return false;
} else {
return true;
}
} else if ($block > 0  && ($cap == 0 && $sessionCap == 0) && MAX_commonGetTimeNow() <= $lastSeen + $block) {
return true;
} else {
return false;
}
}
function _areCookiesDisabled($filterActive = true)
{
// Since MAX_cookieGetUniqueViewerID() has to have been called by this point
return !empty($GLOBALS['_MAX']['COOKIE']['newViewerId']) && $filterActive;
}
function MAX_adRender($aBanner, $zoneId=0, $source='', $target='', $ct0='', $withText=false, $logClick=true, $logView=true, $richMedia=true, $loc='', $referer='', $context = array())
{
$conf = $GLOBALS['_MAX']['CONF'];
// Sanitize these user-inputted variables before passing to the _adRenderX calls
if (empty($target)) {
$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
}
$target = htmlspecialchars($target, ENT_QUOTES);
$source = htmlspecialchars($source, ENT_QUOTES);
$code = '';
switch ($aBanner['contenttype']) {
case 'gif'  :
case 'jpeg' :
case 'png'  :
$code = _adRenderImage($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, false, $richMedia, $loc, $referer);
break;
case 'swf'  :
if ($richMedia) {
$code = _adRenderFlash($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, $loc, $referer);
} else {
$code = _adRenderImage($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, true, $richMedia, $loc, $referer);
}
break;
case 'txt'  :
$code = _adRenderText($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, false, $loc, $referer);
break;
case 'mov'  :
$code = _adRenderQuicktime($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, $loc, $referer);
break;
default :
switch ($aBanner['type']) {
case 'html' :
$code = _adRenderHtml($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, false, $loc, $referer);
break;
case 'url' : // External banner without a recognised content type - assume image...
$code = _adRenderImage($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, false, $richMedia, $loc, $referer);
break;
case 'txt' :
$code = _adRenderText($aBanner, $zoneId, $source, $ct0, $withText, $logClick, $logView, false, $loc, $referer);
}
break;
}
// Transform any code
// Get a timestamp
list($usec, $sec) = explode(' ', microtime());
$time = (float)$usec + (float)$sec;
// Get a random number
$random = substr(md5(uniqid($time, true)), 0, 10);
global $cookie_random;  // Temporary fix to get doubleclick tracking working (Bug # 88)
$cookie_random = $random;
// Get the click URL
$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, urlencode($ct0), $logClick, true);
// Get URL prefix, stripping the traling slash
$urlPrefix = substr(MAX_commonGetDeliveryUrl(), 0, -1);
$code = str_replace('{clickurl}', $clickUrl, $code);  // This step needs to be done separately because {clickurl} can contain {random}...
if (strpos($code, '{logurl}') !== false) {
$logUrl = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&');
$code = str_replace('{logurl}', $logUrl, $code);  // This step needs to be done separately because {logurl} does contain {random}...
}
if (strpos($code, '{logurl_enc}') !== false) {
$logUrl_enc = urlencode(_adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&'));
$code = str_replace('{logurl_enc}', $logUrl_enc, $code);  // This step needs to be done separately because {logurl} does contain {random}...
}
if (strpos($code, '{clickurlparams}')) {
$maxparams = _adRenderBuildParams($aBanner, $zoneId, $source, urlencode($ct0), $logClick, true);
$code = str_replace('{clickurlparams}', $maxparams, $code);  // This step needs to be done separately because {clickurlparams} does contain {random}...
}
$search = array('{timestamp}','{random}','{target}','{url_prefix}','{bannerid}','{zoneid}','{source}', '{pageurl}', '{width}', '{height}');
$locReplace = isset($GLOBALS['loc']) ? $GLOBALS['loc'] : '';
$replace = array($time, $random, $target, $urlPrefix, $aBanner['ad_id'], $zoneId, $source, urlencode($locReplace), $aBanner['width'], $aBanner['height']);
// Arrival URLs
if (preg_match('#^\?(m3_data=[a-z0-9]+)#i', $logClick, $arrivalClick)) {
$arrivalClick = $arrivalClick[1];
preg_match_all('#{arrivalurl:(.*?)}#', $code, $arrivals);
for ($i=0;$i<count($arrivals[1]);$i++) {
$search[] = $arrivals[0][$i];
$replace[] = strpos($arrivals[1][$i], '?') === false ? $arrivals[1][$i].'?'.$arrivalClick : $arrivals[1][$i].'&amp;'.$arrivalClick;
}
}
preg_match_all('#{(.*?)}#', $code, $macros);
for ($i=0;$i<count($macros[1]);$i++) {
if (!in_array($macros[0][$i], $search) && isset($_REQUEST[$macros[1][$i]])) {
$search[] = $macros[0][$i];
$replace[] = urlencode($_REQUEST[$macros[1][$i]]);
}
}
$code = str_replace($search, $replace, $code);
return $code;
}
function _adRenderImage($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $richMedia=true, $loc, $referer, $useAppend=true)
{
$conf = $GLOBALS['_MAX']['CONF'];
if (!$richMedia) {
return _adRenderBuildFileUrl($aBanner, $useAlt);
}
$prepend = (!empty($aBanner['prepend']) && $useAppend) ? $aBanner['prepend'] : '';
$append = (!empty($aBanner['append']) && $useAppend) ? $aBanner['append'] : '';
// Create the anchor tag..
$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
if (!empty($clickUrl)) {  // There is a link
$status = _adRenderBuildStatusCode($aBanner);
//$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
$clickTag = "<a href='$clickUrl' target='{target}'$status>";
$clickTagEnd = '</a>';
} else {
$clickTag = '';
$clickTagEnd = '';
}
// Create the image tag..
$imageUrl = _adRenderBuildFileUrl($aBanner, $useAlt);
if (!empty($imageUrl)) {
$imgStatus = empty($clickTag) ? $status : '';
$width = !empty($aBanner['width']) ? $aBanner['width'] : 0;
$height = !empty($aBanner['height']) ? $aBanner['height'] : 0;
$alt = !empty($aBanner['alt']) ? $aBanner['alt'] : '';
$imageTag = "$clickTag<img src='$imageUrl' width='$width' height='$height' alt='$alt' title='$alt' border='0'$imgStatus />$clickTagEnd";
} else {
$imageTag = '';
}
// Get the text below the banner
$bannerText = $withText && !empty($aBanner['bannertext']) ? "<br />$clickTag{$aBanner['bannertext']}$clickTagEnd" : '';
// Get the image beacon...
$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
return $prepend . $imageTag . $bannerText . $beaconTag . $append;
}
function _adRenderFlash($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $loc, $referer)
{
$conf = $GLOBALS['_MAX']['CONF'];
$prepend = !empty($aBanner['prepend']) ? $aBanner['prepend'] : '';
$append = !empty($aBanner['append']) ? $aBanner['append'] : '';
$width = !empty($aBanner['width']) ? $aBanner['width'] : 0;
$height = !empty($aBanner['height']) ? $aBanner['height'] : 0;
$pluginVersion = !empty($aBanner['pluginversion']) ? $aBanner['pluginversion'] : '4';
// $imageUrlPrefix = ($_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) ? $conf['type_web_ssl_url'] : $conf['type_web_url'];
$altImageAdCode = !empty($aBanner['alt_filename'])
? _adRenderImage($aBanner, $zoneId, $source, $ct0, false, $logClick, false, true, true, $loc, $referer, false)
// An empty image is required because the javascript is parsed before the DOM tree
: "<img src='" . _adRenderBuildImageUrlPrefix() . '/1x1.gif' . "' alt='".$aBanner['alt']."' title='".$aBanner['alt']."' border='0' />";
// Create the anchor tag..
$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
if (!empty($clickUrl)) {  // There is a link
$status = _adRenderBuildStatusCode($aBanner);
$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
$swfParams = array('clickTARGET' => $target, 'clickTAG' => $clickUrl);
$clickTag = "<a href='$clickUrl' target='$target'$status>";
$clickTagEnd = '</a>';
} else {
$swfParams = array();
$clickTag = '';
$clickTagEnd = '';
}
if (!empty($aBanner['parameters'])) {
$aAdParams = unserialize($aBanner['parameters']);
if (isset($aAdParams['swf']) && is_array($aAdParams['swf'])) {
// Converted SWF file, use paramters content
$swfParams = array();
$aBannerSwf = $aBanner;
// Set the flag to let _adRenderBuildClickUrl know that we're not using clickTAG
$aBannerSwf['noClickTag'] = true;
foreach ($aAdParams['swf'] as $iKey => $aSwf) {
$aBannerSwf['url'] = $aSwf['link'];
$swfParams["alink{$iKey}"] = _adRenderBuildClickUrl($aBannerSwf, $zoneId, $source, $ct0, $logClick);
$swfParams["atar{$iKey}"]  = $aSwf['tar'];
}
}
}
$fileUrl = _adRenderBuildFileUrl($aBanner, false);
$rnd = md5(microtime());
$swfId .= (!empty($aBanner['alt']) ? $aBanner['alt'] : 'Advertisement');
$code = "
<div id='ox_$rnd' style='display: inline;'>$altImageAdCode</div>
<script type='text/javascript'><!--/"."/ <![CDATA[
var ox_swf = new FlashObject('{$fileUrl}', '{$swfId}', '{$width}', '{$height}', '{$pluginVersion}');\n";
foreach ($swfParams as $key => $value) {
// URL encode the value, but leave any Openads "magic macros" unescaped to allow substitution
$code .= "    ox_swf.addVariable('{$key}', '" . preg_replace('#%7B(.*?)%7D#', '{$1}', urlencode($value)) . "');\n";
}
if (!empty($aBanner['transparent'])) {
$code .= "\n   ox_swf.addParam('wmode','transparent');";
}
$code .= "
ox_swf.addParam('allowScriptAccess','always');
ox_swf.write('ox_$rnd');
/"."/ ]]> --></script>";
$bannerText = $withText && !empty($aBanner['bannertext']) ? "<br />{$clickTag}{$aBanner['bannertext']}{$clickTagEnd}" : '';
$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
return $prepend . $code . $bannerText . $beaconTag . $append;
}
function _adRenderQuicktime($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $loc, $referer)
{
$conf = $GLOBALS['_MAX']['CONF'];
$prepend = !empty($aBanner['prepend']) ? $aBanner['prepend'] : '';
$append = !empty($aBanner['append']) ? $aBanner['append'] : '';
$width = !empty($aBanner['width']) ? $aBanner['width'] : 0;
$height = !empty($aBanner['height']) ? $aBanner['height'] : 0;
$pluginVersion = !empty($aBanner['pluginversion']) ? $aBanner['pluginversion'] : '4';
// $imageUrlPrefix = ($_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) ? $conf['type_web_ssl_url'] : $conf['type_web_url'];
$fileName = !empty($aBanner['filename']) ? $aBanner['filename'] : '';
$altImageBannercode = _adRenderImage($aBanner, $zoneId, $source, $ct0, false, $logClick, false, true, true, $loc, $referer);
// Create the anchor tag..
$clickTag = _adRenderBuildClickUrl($aBanner, $source, $ct0, $logClick);
if (!empty($clickTag)) {  // There is a link
$status = _adRenderBuildStatusCode($aBanner);
$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
$swfParams = 'clickTAG=' . $clickTag;
$anchor = "<a href='$clickTag' target='$target'$status>";
$anchorEnd = '</a>';
} else {
$swfParams = '';
$anchor = '';
$anchorEnd = '';
}
$clickTag = _adRenderBuildFileUrl($aBanner, $source, $ct0, $logClick);
$fileUrl = _adRenderBuildFileUrl($aBanner, false, $swfParams);
$code = "
<object classid='clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B' codebase='http://www.apple.com/qtactivex/qtplugin.cab' width='$width' height='$height'>
<param name='src' value='$fileUrl'>
<param name='controller' value='false'>
<param name='autoplay' value='true'>
<embed src='$fileUrl' controller='false' autoplay='true' width='$width' height='$height' pluginspace='http://www.apple.com/quicktime/download/'></embed>
<noembed>$altImageBannercode</noembed>
</object>";
$bannerText = $withText && !empty($aBanner['bannertext']) ? "<br />{$anchor}{$aBanner['bannertext']}{$anchorEnd}" : '';
// Get the image beacon...
$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
return $prepend . $code . $bannerText . $beaconTag . $append;
}
function _adRenderHtml($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $loc, $referer)
{
$conf = $GLOBALS['_MAX']['CONF'];
$prepend = !empty($aBanner['prepend']) ? $aBanner['prepend'] : '';
$append = !empty($aBanner['append']) ? $aBanner['append'] : '';
$code = !empty($aBanner['htmlcache']) ? $aBanner['htmlcache'] : '';
// Parse PHP code
if ($conf['delivery']['execPhp'])
{
if (preg_match ("#(\<\?php(.*)\?\>)#i", $code, $parser_regs))
{
// Extract PHP script
$parser_php     = $parser_regs[2];
$parser_result     = '';
// Replace output function
$parser_php = preg_replace ("#echo([^;]*);#i", '$parser_result .=\\1;', $parser_php);
$parser_php = preg_replace ("#print([^;]*);#i", '$parser_result .=\\1;', $parser_php);
$parser_php = preg_replace ("#printf([^;]*);#i", '$parser_result .= sprintf\\1;', $parser_php);
// Split the PHP script into lines
$parser_lines = explode (";", $parser_php);
for ($parser_i = 0; $parser_i < sizeof($parser_lines); $parser_i++)
{
if (trim ($parser_lines[$parser_i]) != '')
eval (trim ($parser_lines[$parser_i]).';');
}
// Replace the script with the result
$code = str_replace ($parser_regs[1], $parser_result, $code);
}
}
// Get the text below the banner
$bannerText = !empty($aBanner['bannertext']) ? "$clickTag{$aBanner['bannertext']}$clickTagEnd" : '';
// Get the image beacon...
if ((strpos($code, '{logurl}') === false) && (strpos($code, '{logurl_enc}') === false)) {
$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
} else {
$beaconTag = '';
}
return $prepend . $code . $bannerText . $beaconTag . $append;
}
function _adRenderText($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $useAlt=false, $loc, $referer)
{
$conf = $GLOBALS['_MAX']['CONF'];
$prepend = !empty($aBanner['prepend']) ? $aBanner['prepend'] : '';
$append = !empty($aBanner['append']) ? $aBanner['append'] : '';
// Create the anchor tag..
$clickUrl = _adRenderBuildClickUrl($aBanner, $zoneId, $source, $ct0, $logClick);
if (!empty($clickUrl)) {  // There is a link
$status = _adRenderBuildStatusCode($aBanner);
$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
$clickTag = "<a href='$clickUrl' target='$target'$status>";
$clickTagEnd = '</a>';
} else {
$clickTag = '';
$clickTagEnd = '';
}
// Get the text below the banner
$bannerText = !empty($aBanner['bannertext']) ? "$clickTag{$aBanner['bannertext']}$clickTagEnd" : '';
// Get the image beacon...
$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
return $prepend . $bannerText . $beaconTag . $append;
}
function _adRenderReal($aBanner, $zoneId=0, $source='', $ct0='', $withText=false, $logClick=true, $logView=true, $loc, $referer)
{
$conf = $GLOBALS['_MAX']['CONF'];
$prepend = !empty($aBanner['prepend']) ? $aBanner['prepend'] : '';
$append = !empty($aBanner['append']) ? $aBanner['append'] : '';
$width = !empty($aBanner['width']) ? $aBanner['width'] : 0;
$height = !empty($aBanner['height']) ? $aBanner['height'] : 0;
$pluginVersion = !empty($aBanner['pluginversion']) ? $aBanner['pluginversion'] : '4';
// $imageUrlPrefix = ($_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) ? $conf['type_web_ssl_url'] : $conf['type_web_url'];
$fileName = !empty($aBanner['filename']) ? $aBanner['filename'] : '';
$altImageBannercode = _adRenderImage($aBanner, $zoneId, $source, $ct0, false, $logClick, false, true, true, $loc, $referer);
// Create the anchor tag..
$clickTag = _adRenderBuildClickUrl($aBanner, $source, $ct0, $logClick);
if (!empty($clickTag)) {  // There is a link
$status = _adRenderBuildStatusCode($aBanner);
$target = !empty($aBanner['target']) ? $aBanner['target'] : '_blank';
$swfParams = 'clickTAG=' . $clickTag;
$anchor = "<a href='$clickTag' target='$target'$status>";
$anchorEnd = '</a>';
} else {
$swfParams = '';
$anchor = '';
$anchorEnd = '';
}
$clickTag = _adRenderBuildClickUrl($aBanner, $source, $ct0, $logClick);
$fileUrl = _adRenderBuildFileUrl($aBanner, false, $swfParams);
$code = "
<object classid='clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA' width='$width' height='$height'>
<param name='src' value='$fileUrl'>
<param name='controls' value='ImageWindow'>
<param name='autostart' value='true'>
<embed src='$fileUrl' controls='ImageWindow' autostart='true' width='$width' height='$height' type='audio/x-pn-realaudio-plugin'></embed>
<noembed>$altImageBannercode</noembed>
</object>";
$bannerText = $withText && !empty($aBanner['bannertext']) ? "<br />{$anchor}{$aBanner['bannertext']}{$anchorEnd}" : '';
// Get the image beacon...
$beaconTag = ($logView && $conf['logging']['adImpressions']) ? _adRenderImageBeacon($aBanner, $zoneId, $source, $loc, $referer) : '';
return $prepend . $code . $bannerText . $beaconTag . $append;
}
function _adRenderBuildFileUrl($aBanner, $useAlt = false, $params = '')
{
$conf = $GLOBALS['_MAX']['CONF'];
$fileUrl = '';
if ($aBanner['type'] == 'url') {
$fileUrl = $aBanner['imageurl'];
if (!empty($params)) {
$fileUrl .= "?{$params}";
}
} else {
$fileName = $useAlt ? $aBanner['alt_filename'] : $aBanner['filename'];
$params = !empty($params) ? $params : '';
if (!empty($fileName)) {
if ($aBanner['type'] == 'web') {
$fileUrl = _adRenderBuildImageUrlPrefix() . "/{$fileName}";
if (!empty($params)) {
$fileUrl .= "?{$params}";
}
} elseif ($aBanner['type'] == 'sql') {
$fileUrl = MAX_commonGetDeliveryUrl($conf['file']['image']) . "?filename={$fileName}&contenttype={$aBanner['contenttype']}";
if (!empty($params)) {
$fileUrl .= "&{$params}";
}
}
}
}
return $fileUrl;
}
function _adRenderBuildImageUrlPrefix()
{
$conf = $GLOBALS['_MAX']['CONF'];
return (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == $conf['openads']['sslPort']) ?
'https://' . $conf['webpath']['imagesSSL'] :
'http://' . $conf['webpath']['images'];
}
function _adRenderBuildLogURL($aBanner, $zoneId = 0, $source = '', $loc = '', $referer = '', $amp = '&amp;')
{
$conf = $GLOBALS['_MAX']['CONF'];
// If there is an OpenX->OpenX internal redirect, log both zones information
$delimiter = $GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'];
if (!empty($GLOBALS['_MAX']['adChain'])) {
foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
$aBanner['ad_id'] .= $delimiter . $ad['ad_id'];
$aBanner['placement_id'] .= $delimiter . $ad['placement_id'];
$zoneId .= $delimiter . $ad['zoneid'];
$aBanner['block_ad'] .= $delimiter . $ad['block_ad'];
$aBanner['cap_ad'] .= $delimiter . $ad['cap_ad'];
$aBanner['session_cap_ad'] .= $delimiter . $ad['session_cap_ad'];
$aBanner['block_campaign'] .= $delimiter . $ad['block_campaign'];
$aBanner['cap_campaign'] .= $delimiter . $ad['cap_campaign'];
$aBanner['session_cap_campaign'] .= $delimiter . $ad['session_cap_campaign'];
$aBanner['block_zone'] .= $delimiter . $ad['block_zone'];
$aBanner['cap_zone'] .= $delimiter . $ad['cap_zone'];
$aBanner['session_cap_zone'] .= $delimiter . $ad['session_cap_zone'];
}
}
$url = MAX_commonGetDeliveryUrl($conf['file']['log']);
$url .= "?bannerid=" . $aBanner['ad_id'];
$url .= $amp . "campaignid=" . $aBanner['placement_id'];
$url .= $amp . "zoneid=" . $zoneId;
if (!empty($source)) $url .= $amp . "source=" . $source;
if (isset($GLOBALS['_MAX']['CHANNELS'])) {
$url .= $amp . "channel_ids=" . str_replace($delimiter, $conf['delivery']['chDelimiter'], $GLOBALS['_MAX']['CHANNELS']);
}
if (!empty($aBanner['block_ad'])) $url .= $amp . $conf['var']['blockAd'] . "=" . $aBanner['block_ad'];
if (!empty($aBanner['cap_ad'])) $url .= $amp . $conf['var']['capAd'] . "=" . $aBanner['cap_ad'];
if (!empty($aBanner['session_cap_ad'])) $url .= $amp . $conf['var']['sessionCapAd'] . "=" . $aBanner['session_cap_ad'];
if (!empty($aBanner['block_campaign'])) $url .= $amp . $conf['var']['blockCampaign'] . "=" . $aBanner['block_campaign'];
if (!empty($aBanner['cap_campaign'])) $url .= $amp . $conf['var']['capCampaign'] . "=" . $aBanner['cap_campaign'];
if (!empty($aBanner['session_cap_campaign'])) $url .= $amp . $conf['var']['sessionCapCampaign'] . "=" . $aBanner['session_cap_campaign'];
if (!empty($aBanner['block_zone'])) $url .= $amp . $conf['var']['blockZone'] . "=" . $aBanner['block_zone'];
if (!empty($aBanner['cap_zone'])) $url .= $amp . $conf['var']['capZone'] . "=" . $aBanner['cap_zone'];
if (!empty($aBanner['session_cap_zone'])) $url .= $amp . $conf['var']['sessionCapZone'] . "=" . $aBanner['session_cap_zone'];
if (!empty($loc)) $url .= $amp . "loc=" . urlencode($loc);
if (!empty($referer)) $url .= $amp . "referer=" . urlencode($referer);
$url .= $amp . "cb={random}";
return $url;
}
function _adRenderImageBeacon($aBanner, $zoneId = 0, $source = '', $loc = '', $referer = '')
{
$conf = $GLOBALS['_MAX']['CONF'];
// Add beacon image for logging
if (isset($_SERVER['HTTP_USER_AGENT']) && preg_match("#Mozilla/(1|2|3|4)#", $_SERVER['HTTP_USER_AGENT'])
&& !preg_match("#compatible#", $_SERVER['HTTP_USER_AGENT'])) {
$div = "<layer id='beacon_{$aBanner['ad_id']}' width='0' height='0' border='0' visibility='hide'>";
$style = '';
$divEnd = '</layer>';
} else {
$div = "<div id='beacon_{$aBanner['ad_id']}' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>";
$style = " style='width: 0px; height: 0px;'";
$divEnd = '</div>';
}
$logUrl = _adRenderBuildLogURL($aBanner, $zoneId, $source, $loc, $referer, '&amp;');
$beacon = "$div<img src='$logUrl' width='0' height='0' alt=''{$style} />{$divEnd}";
return $beacon;
}
function _adRenderBuildParams($aBanner, $zoneId=0, $source='', $ct0='', $logClick=true, $overrideDest=false)
{
// HACK - sometimes $aBanner has the banner ID as bannerid, and others it is ad_id.  This needs
//  to be sorted in all parts of the application to reference ad_id rather than bannerid.
if (isset($aBanner['ad_id']) && empty($aBanner['bannerid'])) {
$aBanner['bannerid'] = $aBanner['ad_id'];
}
$conf = $GLOBALS['_MAX']['CONF'];
$delimiter = $GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'];
// If there is an OpenX->OpenX internal redirect, log both zones information
if (!empty($GLOBALS['_MAX']['adChain'])) {
foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
$aBanner['bannerid'] .= $delimiter . $ad['bannerid'];
$aBanner['placement_id'] .= $delimiter . $ad['placement_id'];
$zoneId .= $delimiter . $ad['zoneid'];
}
}
$maxparams = '';
$channelIds = '';
if (!empty($aBanner['url']) || $overrideDest) {
// There is a link
$del = $conf['delivery']['ctDelimiter'];
$delnum = strlen($del);
$random = "{$del}cb={random}";
$bannerId = !empty($aBanner['bannerid']) ? "{$del}bannerid={$aBanner['bannerid']}" : '';
$source = !empty($source) ? "{$del}source=" . urlencode($source) : '';
$log = $logClick ? '' : "{$del}log=no";
// Determine the destination
$dest = !empty($aBanner['url']) ? $aBanner['url'] : '';
// If the passed in a ct0= value that is not a valid URL (simple checking), then ignore it
$ct0 = (empty($ct0) || strtolower(substr($ct0, 0, 4)) != 'http') ? '' : htmlspecialchars($ct0, ENT_QUOTES);
if ($aBanner['contenttype'] == "swf" && empty($aBanner['noClickTag'])) {
// Strip maxdest with SWF banners using clickTAG
$maxdest = '';
} else {
$maxdest = "{$del}maxdest={$ct0}{$dest}";
}
if (isset($GLOBALS['_MAX']['CHANNELS']) && ($GLOBALS['_MAX']['CHANNELS'] != $GLOBALS['_MAX']['MAX_DELIVERY_MULTIPLE_DELIMITER'])) {
$channelIds = $del. "channel_ids=" . str_replace($delimiter, $conf['delivery']['chDelimiter'], $GLOBALS['_MAX']['CHANNELS']);
} else {
$channelIds = '';
}
$maxparams = "{$delnum}{$bannerId}{$del}zoneid={$zoneId}{$channelIds}{$source}{$log}{$random}{$maxdest}";
// hmmm... 2__bannerid=1__zoneid=1__cb={random}__maxdest=__channel_ids=__1__1__
}
return $maxparams;
}
function _adRenderBuildClickUrl($aBanner, $zoneId=0, $source='', $ct0='', $logClick=true, $overrideDest=false)
{
$conf = $GLOBALS['_MAX']['CONF'];
$clickUrl = '';
if (is_string($logClick)) {
$clickUrl = $logClick;
} elseif (!empty($aBanner['url']) || $overrideDest) {
$clickUrl = MAX_commonGetDeliveryUrl($conf['file']['click']) . '?' . $conf['var']['params'] . '=' . _adRenderBuildParams($aBanner, $zoneId, $source, $ct0, $logClick, true);
}
return $clickUrl;
}
function _adRenderBuildStatusCode($aBanner)
{
return !empty($aBanner['status']) ? " onmouseover=\"self.status='" . addslashes($aBanner['status']) . "'; return true;\" onmouseout=\"self.status=''; return true;\"" : '';
}
function MAX_adSelect($what, $campaignid = '', $target = '', $source = '', $withtext = 0, $context = array(), $richmedia = true, $ct0 = '', $loc = '', $referer = '')
{
$conf = $GLOBALS['_MAX']['CONF'];
// For local mode and XML-RPC calls the some parameters are not set in the global scope
// So we need to override the empty globals with the values passed into this function.
if (empty($GLOBALS['source'])) {
$GLOBALS['source'] = $source;
}
if (empty($GLOBALS['loc'])) {
$GLOBALS['loc'] = $loc;
}
// Store the original zone, campaign or banner IDs for later use
if (strpos($what,'zone:') === 0) {
$originalZoneId = intval(substr($what,5));
} elseif (strpos($what,'campaignid:') === 0) {
$originalCampaignId = intval(substr($what,11));
} elseif (strpos($what, 'bannerid:') === 0) {
$originalBannerId = intval(substr($what,9));
}
$userid = MAX_cookieGetUniqueViewerID();
MAX_cookieSet($conf['var']['viewerId'], $userid, MAX_commonGetTimeNow()+31536000); // 365*24*60*60
$outputbuffer = '';
// Set flag
$found = false;
// Reset followed zone chain
$GLOBALS['_MAX']['followedChain'] = array();
$GLOBALS['_MAX']['adChain'] = array();
$first = true;
global $g_append, $g_prepend;
$g_append = '';
$g_prepend = '';
while ($first || ($what != '' && $found == false)) {
$first = false;
// Get first part, store second part
$ix = strpos($what, '|');
if ($ix === false) {
$remaining = '';
} else {
$remaining = substr($what, $ix+1);
$what = substr($what, 0, $ix);
}
if (strpos($what, 'zone:') === 0) {
$zoneId  = intval(substr($what,5));
$row = _adSelectZone($zoneId, $context, $source, $richmedia);
} else {
// Expand paths to regular statements
if (strpos($what, '/') > 0) {
if (strpos($what, '@') > 0) {
list ($what, $append) = explode ('@', $what);
} else {
$append = '';
}
$separate  = explode ('/', $what);
$expanded  = '';
$collected = array();
reset($separate);
while (list(,$v) = each($separate)) {
$expanded .= ($expanded != '' ? ',+' : '') . $v;
$collected[] = $expanded . ($append != '' ? ',+'.$append : '');
}
$what = strtok(implode('|', array_reverse ($collected)), '|');
$remaining = strtok('').($remaining != '' ? '|'.$remaining : '');
}
$row = _adSelectDirect($what, $campaignid, $context, $source, $richmedia, $remaining == '');
}
if (is_array($row) && empty($row['default'])) {
// Log the ad request
if ($conf['logging']['adRequests']) {
MAX_Delivery_log_logAdRequest($userid, $row['bannerid'], null, $row['zoneid']);
}
if ($row['adserver'] == 'max' && preg_match("#{$conf['webpath']['delivery']}.*zoneid=([0-9]+)#", $row['htmltemplate'], $matches) && !stristr($row['htmltemplate'], $conf['file']['popup'])) {
// The ad selected was an OpenX HTML ad on the same server... do internal redirecty stuff
$GLOBALS['_MAX']['adChain'][] = $row;
$found = false;
$what = "zone:{$matches[1]}";
} else {
$found = true;
}
} else {
$what  = $remaining;
}
}
// Return the banner information
if ($found) {
$zoneId = empty($row['zoneid']) ? 0 : $row['zoneid'];
// For internal redirected creatives, make sure that any appended code in the adChain is appended
if (!empty($GLOBALS['_MAX']['adChain'])) {
foreach ($GLOBALS['_MAX']['adChain'] as $index => $ad) {
if (($ad['ad_id'] != $row['ad_id']) && !empty($ad['append'])) {
$row['append'] .= $ad['append'];
}
}
}
$outputbuffer = MAX_adRender($row, $zoneId, $source, $target, $ct0, $withtext, true, true, $richmedia, $loc, $referer, $context);
$output = array('html'       => $outputbuffer,
'bannerid'   => $row['bannerid'],
'contenttype'=> $row['contenttype'],
'alt'        => $row['alt'],
'width'      => $row['width'],
'height'     => $row['height'],
'url'        => $row['url'],
'campaignid' => $row['campaignid'],
);
$output['context'] = (!empty($row['zone_companion']) && (is_array($row['zone_companion']))) ? _adSelectBuildCompanionContext($row, $context) : array();
// If ad-logging is disabled, the log beacon won't be sent, so set the capping at request
if (MAX_Delivery_cookie_cappingOnRequest()) {
if ($row['block_ad'] > 0 || $row['cap_ad'] > 0 || $row['session_cap_ad'] > 0) {
MAX_Delivery_cookie_setCapping('Ad', $row['bannerid'], $row['block_ad'], $row['cap_ad'], $row['session_cap_ad']);
}
if ($row['block_campaign'] > 0 || $row['cap_campaign'] > 0 || $row['session_cap_campaign'] > 0) {
MAX_Delivery_cookie_setCapping('Campaign', $row['campaign_id'], $row['block_campaign'], $row['cap_campaign'], $row['session_cap_campaign']);
}
if ($row['block_zone'] > 0 || $row['cap_zone'] > 0 || $row['session_cap_zone'] > 0) {
MAX_Delivery_cookie_setCapping('Zone', $row['zoneid'], $row['block_zone'], $row['cap_zone'], $row['session_cap_zone']);
}
}
return $output;
} else {
// No banner found
if (!empty($row['default'])) {
// Return the default banner
if (empty($target)) {
$target = '_blank';  // Default
}
$outputbuffer = $g_prepend . '<a href=\'' . $row['default_banner_dest'] . '\' target=\'' .
$target . '\'><img src=\'' . $row['default_banner_url'] .
'\' border=\'0\' alt=\'\'></a>' . $g_append;
return array('html' => $outputbuffer, 'bannerid' => '' );
} else {
// No default banner was returned, return no banner
$outputbuffer = $g_prepend . $g_append;
return array('html' => $outputbuffer, 'bannerid' => '' );
}
}
}
function _adSelectDirect($what, $campaignid = '', $context = array(), $source = '', $richMedia = true, $lastpart = true)
{
$aDirectLinkedAds = MAX_cacheGetLinkedAds($what, $campaignid, $lastpart);
$aLinkedAd = _adSelectCommon($aDirectLinkedAds, $context, $source, $richMedia);
if (is_array($aLinkedAd)) {
$aLinkedAd['zoneid'] = 0;
$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
$aLinkedAd['storagetype'] = $aLinkedAd['type'];
$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
$aLinkedAd['prepend'] = '';
return $aLinkedAd;
}
if (!empty($aDirectLinkedAds['default_banner_url'])) {
return array(
'default' => true,
'default_banner_url' =>  $aZoneLinkedAds['default_banner_url'],
'default_banner_dest' => $aZoneLinkedAds['default_banner_dest']
);
}
return false;
}
function _getNextZone($zoneId, $arrZone)
{
if (!empty($arrZone['chain']) && (substr($arrZone['chain'],0,5) == 'zone:')) {
return intval(substr($arrZone['chain'],5));
}
else {
return $zoneId;
}
}
function _adSelectZone($zoneId, $context = array(), $source = '', $richMedia = true)
{
global $g_append, $g_prepend;
while (!in_array($zoneId, $GLOBALS['_MAX']['followedChain'])) {
$GLOBALS['_MAX']['followedChain'][] = $zoneId;
$appendedThisZone = false;
// Get all ads which are linked to the zone
$aZoneLinkedAds = MAX_cacheGetZoneLinkedAds($zoneId);
if ($zoneId != 0 && MAX_limitationsIsZoneForbidden($zoneId, $aZoneLinkedAds)) {
$zoneId = _getNextZone($zoneId, $aZoneLinkedAds);
continue;
}
if (is_array($aZoneLinkedAds)) {
if (isset($aZoneLinkedAds['forceappend']) && $aZoneLinkedAds['forceappend'] == 't') {
$g_prepend .= $aZoneLinkedAds['prepend'];
$g_append = $aZoneLinkedAds['append'] . $g_append;
$appendedThisZone = true;
}
$aLinkedAd = _adSelectCommon($aZoneLinkedAds, $context, $source, $richMedia);
if (is_array($aLinkedAd)) {
$aLinkedAd['zoneid'] = $zoneId;
$aLinkedAd['bannerid'] = $aLinkedAd['ad_id'];
$aLinkedAd['storagetype'] = $aLinkedAd['type'];
$aLinkedAd['campaignid'] = $aLinkedAd['placement_id'];
$aLinkedAd['zone_companion'] = $aZoneLinkedAds['zone_companion'];
$aLinkedAd['block_zone'] = $aZoneLinkedAds['block_zone'];
$aLinkedAd['cap_zone'] = $aZoneLinkedAds['cap_zone'];
$aLinkedAd['session_cap_zone'] = $aZoneLinkedAds['session_cap_zone'];
if (!$appendedThisZone) {
$aLinkedAd['append'] .= $aZoneLinkedAds['append'] . $g_append;
$aLinkedAd['prepend'] = $g_prepend . $aZoneLinkedAds['prepend'];
} else {
$aLinkedAd['append'] .= $g_append;
$aLinkedAd['prepend'] = $g_prepend;
}
return ($aLinkedAd);
}
$zoneId = _getNextZone($zoneId, $aZoneLinkedAds);
}
}
if (!empty($aZoneLinkedAds['default_banner_url'])) {
return array(
'default' => true,
'default_banner_url' =>  $aZoneLinkedAds['default_banner_url'],
'default_banner_dest' => $aZoneLinkedAds['default_banner_dest']
);
}
return false;
}
function _adSelectCommon($aAds, $context, $source, $richMedia)
{
// Are there any ads linked?
if (!empty($aAds['count_active'])) {
// Get an ad from the any exclusive campaigns first...
$aLinkedAd = _adSelect($aAds, $context, $source, $richMedia, 'xAds');
// If no ad selected, and a previous ad on the page has set that companion ads should be selected...
if (!is_array($aLinkedAd) && isset($aAds['zone_companion']) && is_array($aAds['zone_companion']) && !empty($context)) {
// Try to select a normal companion ad...
$aLinkedAd = _adSelect($aAds, $context, $source, $richMedia, 'cAds');
// If still no ad selected...
if (!is_array($aLinkedAd)) {
// Select one of the low-priority companion ads
$aLinkedAd = _adSelect($aAds, $context, $source, $richMedia, 'clAds');
}
}
// If still no ad selected...
if (!is_array($aLinkedAd)) {
// Select one of the normal ads
// The normal ads are now grouped by campaign-priority so we need to iterate over the
for ($i=10;$i>0;$i--) {
if (!empty($aAds['ads'][$i])) {
$aLinkedAd = _adSelect($aAds, $context, $source, $richMedia, 'ads', $i);
// Did we pick an ad from this campaign-priority level?
if (is_array($aLinkedAd)) { break; }
}
}
}
// If still no ad selected...
if (!is_array($aLinkedAd)) {
// Select one of the low-priority ads
$aLinkedAd = _adSelect($aAds, $context, $source, $richMedia, 'lAds');
}
if (is_array($aLinkedAd)) {
return $aLinkedAd;
}
}
return false;
}
function _adSelect(&$aLinkedAds, $context, $source, $richMedia, $adArrayVar = 'ads', $cp = null)
{
// If there are no linked ads, we can return
if (!is_array($aLinkedAds)) { return; }
if (!is_null($cp) && isset($aLinkedAds[$adArrayVar][$cp])) {
$aAds = $aLinkedAds[$adArrayVar][$cp];
} elseif (isset($aLinkedAds[$adArrayVar])) {
$aAds = $aLinkedAds[$adArrayVar];
} else {
$aAds = array();
}
// If there are no linked ads of the specified type, we can return
if (count($aAds) == 0) { return; }
// Build preconditions
$aContext = _adSelectBuildContextArray($aAds, $adArrayVar, $context);
// New delivery algorithm: discard all invalid ads before iterating over them
$aAds = _adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia);
// If there are no linked ads of the specified type, we can return
if (count($aAds) == 0) { return; }
if (!is_null($cp)) {
// Scale priorities
$total_priority = 0;
foreach ($aAds as $ad) {
$total_priority += $ad['priority'] * $ad['priority_factor'];
}
if ($total_priority) {
foreach ($aAds as $key => $ad) {
$aAds[$key]['priority'] = $ad['priority'] * $ad['priority_factor'] *
$aLinkedAds['priority'][$adArrayVar][$cp] / $total_priority;
}
}
}
// Seed the random number generator
global $n;
mt_srand(floor((isset($n) && strlen($n) > 5 ? hexdec($n[0].$n[2].$n[3].$n[4].$n[5]): 1000000) * (double)microtime()));
$conf = $GLOBALS['_MAX']['CONF'];
$prioritysum = 0;
if (($adArrayVar == 'ads') || ($adArrayVar == 'cAds')) {
$prioritysum = 1;
} else {
foreach ($aAds as $aAd) {
$prioritysum += $aAd['priority'];
}
}
while ($prioritysum && sizeof($aAds) > 0) {
$low = 0;
$high = 0;
$paidPriorityCounter = 0;
if (($adArrayVar == 'ads') || ($adArrayVar == 'cAds')) {
// Paid campaigns have a sum of priorities of unity, so pick
// a random number between 0 and $prioritysum, inclusive.
$ranweight = (mt_rand(0, $GLOBALS['_MAX']['MAX_RAND']) / $GLOBALS['_MAX']['MAX_RAND']) * $prioritysum;
} else {
// All other campaigns have integer-based priority values, so
// select a random number between 0 and the sum of all the
// priority values
$ranweight = ($prioritysum > 1) ? mt_rand(0, $prioritysum - 1) : 0;
}
// Perform selection of an ad, based on the random number
foreach($aAds as $adId => $aLinkedAd) {
if (is_array($aLinkedAd)) {
$placementId = $aLinkedAd['placement_id'];
$low = $high;
$high += $aLinkedAd['priority'];
if ($high > $ranweight && $low <= $ranweight) {
// We have already tested the delivery limitations against the current impression
return $aLinkedAd;
} else {
// This ad did not match the random value generated. If we
// are also looking for a paid placement ad, count the number
// of iterations (ads we have looked at), so that we know
// when we have selected the blank ad
if (($adArrayVar == 'ads') || ($adArrayVar == 'cAds')) {
$paidPriorityCounter++;
}
// Have we tested all the ads yet?
if ($paidPriorityCounter == count($aAds)) {
// Yes, and no ad was suitable, so no paid ad should be shown
return;
}
}
}
}
}
}
function _adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)
{
$conf = $GLOBALS['_MAX']['CONF'];
// Excludelist banners
if (isset($aContext['banner']['exclude'][$aAd['ad_id']])) {
return false;
}
if (isset($aContext['campaign']['exclude'][$aAd['placement_id']])) {
// Excludelist campaigns
return false;
}
if (sizeof($aContext['banner']['include']) && !isset($aContext['banner']['include'][$aAd['ad_id']])) {
// Includelist banners
return false;
}
if (sizeof($aContext['campaign']['include']) && !isset($aContext['campaign']['include'][$aAd['placement_id']])) {
// Includelist campaigns
return false;
}
if (   // Exclude richmedia banners if no alt image is specified
$richMedia == false &&
$aAd['alt_filename'] == '' &&
!($aAd['contenttype'] == 'jpeg' || $aAd['contenttype'] == 'gif' || $aAd['contenttype'] == 'png') &&
!($aAd['type'] == 'url' && $aAd['contenttype'] == '')
) {
return false;
}
if (MAX_limitationsIsAdForbidden($aAd)) {
return false;
}
if ($_SERVER['SERVER_PORT'] == 443 && $aAd['type'] == 'html' && ($aAd['adserver'] != 'max' || preg_match("#src\s?=\s?['\"]http:#", $aAd['htmlcache']))) {
// HTML Banners that contain 'http:' on SSL
return false;
}
if ($_SERVER['SERVER_PORT'] == 443 && $aAd['type'] == 'url' && (substr($aAd['imageurl'], 0, 5) == 'http:')) {
// It only matters if the initial call is to non-SSL (it can/could contain http:)
return false;
}
if ($conf['delivery']['acls'] && !MAX_limitationsCheckAcl($aAd, $source)) {
return false;
}
// If any of the above failed, this function will have already returned false
// So to get this far means that the ad was valid
return true;
}
function _adSelectBuildContextArray(&$aLinkedAds, $adArrayVar, $context)
{
$aContext = array(
'campaign' => array('exclude' => array(), 'include' => array()),
'banner'   => array('exclude' => array(), 'include' => array()),
);
if (is_array($context) && !empty($context)) {
$cContext = count($context);
for ($i=0; $i < $cContext; $i++) {
reset($context[$i]);
list ($key, $value) = each($context[$i]);
$valueArray = explode(':', $value);
if (count($valueArray) == 1) {
list($value) = $valueArray;
$type = "";
} else {
list($type, $value) = $valueArray;
}
switch($type) {
case 'campaignid':
switch ($key) {
case '!=': $aContext['campaign']['exclude'][$value] = true; break;
case '==': $aContext['campaign']['include'][$value] = true; break;
}
break;
case 'companionid':
switch ($key) {
case '!=': $aContext['campaign']['exclude'][$value]   = true; break;
case '==':
if ($adArrayVar == 'cAds') {
$includeCampaignID[$value] = true;
// Rescale the priorities for the available companion campaigns...
$companionPrioritySum = 0;
foreach ($aLinkedAds[$adArrayVar] as $iAdId => $aAd) {
if (isset($aContext['campaign']['include'][$aAd['placement_id']])) {
$companionPrioritySum += $aAd['priority'];
} else {
unset($aLinkedAds[$adArrayVar][$iAdId]);
}
}
if ($companionPrioritySum > 0) {
$companionScaleFactor = 1 / $companionPrioritySum;
foreach($aLinkedAds[$adArrayVar] as $iAdId => $aAd) {
$aLinkedAds[$adArrayVar][$iAdId]['priority'] *= $companionScaleFactor;
}
}
}
$aContext['campaign']['include'][$value] = true;
break;
}
break;
default:
switch ($key) {
case '!=': $aContext['banner']['exclude'][$value] = true; break;
case '==': $aContext['banner']['include'][$value] = true; break;
}
}
}
}
return $aContext;
}
function _adSelectBuildCompanionContext($aBanner, $context) {
if (count($aBanner['zone_companion']) > 0) {
// This zone call has companion banners linked to it.
// So pass into the next call that we would like a banner from this campaign, and not from the other companion linked campaigns;
foreach ($aBanner['zone_companion'] AS $companionCampaign) {
$key = ($aBanner['placement_id'] == $companionCampaign) ? '==' : '!=';
$context[] = array($key => "companionid:$companionCampaign");
}
}
return $context;
}
function _adSelectDiscardNonMatchingAds($aAds, $aContext, $source, $richMedia)
{
foreach ($aAds as $adId => $aAd) {
if (!_adSelectCheckCriteria($aAd, $aContext, $source, $richMedia)) {
unset($aAds[$adId]);
}
}
return $aAds;
}
// No Caching
MAX_commonSetNoCacheHeaders();
//Register any script specific input variables
MAX_commonRegisterGlobalsArray(
array(
'left',
'top',
'popunder',
'timeout',
'delay',
'toolbars',
'location',
'menubar',
'status',
'resizable',
'scrollbars'
)
);
// Set defaults for script specific input variables
if (!isset($left))       $left       = 0;
if (!isset($top))        $top        = 0;
if (!isset($popunder))   $popunder   = 0;
if (!isset($timeout))    $timeout    = 0;
if (!isset($delay))      $delay      = 0;
if (!isset($toolbars))   $toolbars   = 0;
if (!isset($location))	 $location   = 0;
if (!isset($menubar))	 $menubar    = 0;
if (!isset($status))	 $status     = 0;
if (!isset($resizable))  $resizable  = 0;
if (!isset($scrollbars)) $scrollbars = 0;
// Get the banner
$row = MAX_adSelect($what, $campaignid, $target, $source, $withtext, $context, true, $ct0, $GLOBALS['loc'], $GLOBALS['referer']);
$row['zoneid'] = 0;
if (isset($zoneid)) {
$row['zoneid'] = $zoneid;
}
// Do not pop a window if not banner was found..
if (!$row['bannerid']) {
exit;
}
$contenturl = MAX_commonGetDeliveryUrl($conf['file']['content']) . "?bannerid={$row['bannerid']}&zoneid={$row['zoneid']}&target={$target}&withtext={$withtext}&source=".urlencode($source)."&timeout={$timeout}&ct0={$ct0}";
header("Content-type: application/x-javascript");
echo "
var MAX_errorhandler = null;
if (window.captureEvents && Event.ERROR)
window.captureEvents (Event.ERROR);
// Error handler to prevent 'Access denied' errors
function MAX_onerror(e) {
window.onerror = MAX_errorhandler;
return true;
}
function MAX_{$row['bannerid']}_pop() {
MAX_errorhandler = window.onerror;
window.onerror = MAX_onerror;
// Determine the size of the window
var X={$row['width']};
var Y={$row['height']};
// If Netscape 3 is used add 20 to the size because it doesn't support a margin of 0
if(!window.resizeTo) {
X+=20;
Y+=20;
}
// Open the window if needed
window.MAX_{$row['bannerid']}=window.open('', 'MAX_{$row['bannerid']}','height='+Y+',width='+X+',toolbar=".($toolbars == 1 ? 'yes' : 'no').",location=".($location == 1 ? 'yes' : 'no').",menubar=".($menubar == 1 ? 'yes' : 'no').",status=".($status == 1 ? 'yes' : 'no').",resizable=".($resizable == 1 ? 'yes' : 'no').",scrollbars=".($scrollbars == 1 ? 'yes' : 'no')."');
if (window.MAX_{$row['bannerid']}.document.title == '' || window.MAX_{$row['bannerid']}.location == 'about:blank' || window.MAX_{$row['bannerid']}.location == '') {
var browser = navigator.userAgent.toLowerCase();
// Resize window to correct size on IE < 6, determine outer width and height - IE 5.1x on MAC should't resize!
if (window.resizeTo && browser.match(/msie [345]/) && browser.indexOf('msie 5.1') == -1 && browser.indexOf('mac') == -1) {
if(MAX_{$row['bannerid']}.innerHeight) {
var diffY = MAX_{$row['bannerid']}.outerHeight-Y;
var diffX = MAX_{$row['bannerid']}.outerWidth-X;
var outerX = X+diffX;
var outerY = Y+diffY;
} else {
MAX_{$row['bannerid']}.resizeTo(X, Y);
var time = new Date().getTime();
while (!MAX_{$row['bannerid']}.document.body) {
if (new Date().getTime() - time > 250) {
MAX_{$row['bannerid']}.close();
return false;
}
}
var diffY = MAX_{$row['bannerid']}.document.body.clientHeight-Y;
var diffX = MAX_{$row['bannerid']}.document.body.clientWidth-X;
var outerX = X-diffX;
var outerY = Y-diffY;
}
MAX_{$row['bannerid']}.resizeTo(outerX, outerY);
}";
if (!empty($left) && !empty($top)) {
echo "
if (window.moveTo) {";
if ($left == 'center') {
echo "
var posX = parseInt((screen.width/2)-(outerX/2));";
} elseif ($left >= 0) {
echo "
var posX = $left;";
} elseif ($left < 0) {
echo "
var posX = screen.width-outerX+$left;";
}
if ($top == 'center') {
echo "
var posY = parseInt((screen.height/2)-(outerY/2));";
} elseif ($top  >= 0) {
echo "
var posY = $top;";
} elseif ($top  < 0) {
echo "
var posY = screen.height-outerY+$top;";
}
echo "
MAX_{$row['bannerid']}.moveTo(posX, posY);
}";
}
// Set the actual location after resize otherwise we might get 'access denied' errors
echo "
MAX_{$row['bannerid']}.location='$contenturl';";
// Move main window to the foreground if we are dealing with a popunder
if (isset($popunder) && $popunder == '1') {
echo "
window.focus();";
}
echo "
}
window.onerror = MAX_errorhandler;
return true;
}";
if (!empty($delay) && $delay == 'exit') {
echo "
if (window.captureEvents && Event.UNLOAD)
window.captureEvents (Event.UNLOAD);
window.onunload = MAX_{$row['bannerid']}_pop;";
} elseif (isset($delay) && $delay > 0) {
echo "
window.setTimeout(\"MAX_{$row['bannerid']}_pop();\", ".($delay * 1000).");";
} else {
echo "
MAX_{$row['bannerid']}_pop();";
}


?>