/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2000-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * @(#)ClientConstants.java	1.5 06/28/07
 */ 

package com.sun.messaging.jmq;

/**
 * <code>ClientConstants</code> encapsulates JMQ specific
 * constant definitions and static strings used by the client that
 * need to be shared with the admin.
 */
public class ClientConstants {

    /* No public constructor needed */
    private ClientConstants(){}

    /** The connection type indicator for NORMAL connections */
    public static final String CONNECTIONTYPE_NORMAL = "NORMAL";
 
    /** The connection type indicator for ADMIN connections */
    public static final String CONNECTIONTYPE_ADMIN = "ADMIN";
 
    /** The connection type indicator for ADMINKEY connections */
    public static final String CONNECTIONTYPE_ADMINKEY = "ADMINKEY";
 
    /** The URI prefix for a temporary destination name */
    public static final String TEMPORARY_DESTINATION_URI_PREFIX = "temporary_destination://";

    /** The URI component for a temporary queue */
    public static final String TEMPORARY_QUEUE_URI_NAME = "queue/";

    /** The URI component for a temporary topic */
    public static final String TEMPORARY_TOPIC_URI_NAME = "topic/";

    /** The Destination Type value for an Unknown Destination */
    public static final int DESTINATION_TYPE_UNKNOWN = 0;

    /** The Destination Type value for a Queue Destination */
    public static final int DESTINATION_TYPE_QUEUE = 1;

    /** The Destination Type value for a Topic Destination */
    public static final int DESTINATION_TYPE_TOPIC = 2;

}
