/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)JMSPacketProperties.java	1.4 06/29/07
 */ 

package com.sun.messaging.jmq.jmsservice;

import java.util.Hashtable;
import java.util.Map;

/**
 *  The JMSPacketProperties class encapsulates the properties as used by the
 *  MQ wire protocol.<p>
 *  All relevant properties that need to be passed can be correctly
 *  set using methods that follow the pattern {@code set<PropertyName>}, where
 *  {@code <PropertyName>} is replaced with the name of the property in the
 *  MQ wire protocol.<br>
 */
public class JMSPacketProperties extends Hashtable <String, Object> {

    /**
     * Creates a new instance of JMSPacketProperties
     */
    public JMSPacketProperties() {
        super();
    }

    public JMSPacketProperties(Map <? extends String, ? extends Object> map){
        super(map);
    }

    /**
     *  Sets the JMQUserAgent property for JMS-DIRECT mode clients
     */
    public void setJMQUserAgent(){
        String ua = "SJSMQ/4.1 JMS-DIRECT; "
                + System.getProperty("os.name") +" "
                + System.getProperty("os.version") +" "
                + System.getProperty("os.arch") +" )";
        super.put("JMQUserAgent", ua);
    }

    /**
     *  Gets the JMQUserAgent property from this JMSService request parameter
     *
     *  @return The JMQUserAgent string
     */
    public String getJMQUserAgent(){
        return (String)super.get("JMQUserAgent");
    }

    /**
     *  Sets the JMQConnectionID property for JMS-DIRECT clients
     */
    public void setJMQConnectionID(long connectionID){
        super.put("JMQConnectionID", connectionID);
    }
}
