/*
 * @(#)MQAuditManager.java	1.2 06/24/04
 *
 * Copyright (c) 2004 by Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.messaging.jmq.jmsserver.audit;

import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

/**
 * The MQAuditManager takes care of writing audit logs for the broker.
 *
 * @version    1.2
 */
public class MQAuditManager extends MQAuditSession {

    private MQAuditSession logAuditSession = null;
    private MQAuditSession bsmAuditSession = null;

    MQAuditManager() {
	// if auditing is not licensed, do nothing
	if (!MQAuditService.AUDIT_LOGGING_LICENSED)
	    return;

	// if audit logging through broker log is enabled
	if (MQAuditService.logAuditEnabled) {
	    try {
		logAuditSession = MQAuditService.getAuditSession(
						MQAuditService.LOG_TYPE);
		auditOn = logAuditSession.isAuditOn();
	    } catch (BrokerException e) {
		logger.log(logger.ERROR,
			"Failed to get audit session to log audit records");
	    }
	}

	// if audit logging through BSM is enabled
	if (MQAuditService.bsmAudit) {
	    try {
		bsmAuditSession = MQAuditService.getAuditSession(
						MQAuditService.BSM_TYPE);
		auditOn = auditOn || bsmAuditSession.isAuditOn();
	    } catch (BrokerException e) {
		logger.log(logger.ERROR,
			"Failed to get audit session to log BSM audit records");
	    }
	}
    }

    public void setInstance(String name, String host, int port) {
	super.setInstance(name, host, port);

	if (logAuditSession != null) {
	    logAuditSession.setInstance(name, host, port);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.setInstance(name, host, port);
	}
    }

    /**
     * Invoked post authentication.
     * @param user	user who is being authenticated
     * @param remoteHost host the user connects from
     * @param success	status of authentication
     */
    public void authentication(String user, String host, boolean success) {
	if (logAuditSession != null) {
	    logAuditSession.authentication(user, host, success);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.authentication(user, host, success);
	}
    }

    public void brokerOperation(String user, String host, String op) {
	if (logAuditSession != null) {
	    logAuditSession.brokerOperation(user, host, op);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.brokerOperation(user, host, op);
	}
    }

    public void connectionAuth(
	String user, String host, String type, String name, boolean success) {
	if (logAuditSession != null) {
	    logAuditSession.connectionAuth(user, host, type, name, success);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.connectionAuth(user, host, type, name, success);
	}
    }

    public void destinationAuth(String user, String host, String type,
	String name, String op, boolean success) {
	if (logAuditSession != null) {
	    logAuditSession.destinationAuth(user, host, type, name, op, success);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.destinationAuth(user, host, type, name, op, success);
	}
    }

    public void storeOperation(String user, String host, String op) {
	if (logAuditSession != null) {
	    logAuditSession.storeOperation(user, host, op);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.storeOperation(user, host, op);
	}
    }

    public void destinationOperation(
	String user, String host, String op, String type, String name) {
	if (logAuditSession != null) {
	    logAuditSession.destinationOperation(user, host, op, type, name);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.destinationOperation(user, host, op, type, name);
	}
    }

    public void durableSubscriberOperation(
	String user, String host, String op, String name, String clientID) {
	if (logAuditSession != null) {
	    logAuditSession.durableSubscriberOperation(user, host, op, name,
	    						clientID);
	}
	if (bsmAuditSession != null) {
	    bsmAuditSession.durableSubscriberOperation(user, host, op, name,
	    						clientID);
	}
    }
}
