/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder.
 */

package com.sun.messaging.bridge.service.jms; 

import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

/**
 * @author amyk
 *
 */
public class XAConnectionFactoryImpl implements XAConnectionFactory, Refable  {
    
    private XAConnectionFactory _cf = null;
    private String _ref = null;
    private boolean _isEmbeded = false;
    private boolean _isMultiRM = false;
    private boolean _firstTime = true;

    public XAConnectionFactoryImpl(XAConnectionFactory cf, 
                                   String ref, 
                                   boolean isMultiRM) {
        this(cf, false, ref, isMultiRM);
    }

    public XAConnectionFactoryImpl(XAConnectionFactory cf, 
                                   boolean isEmbeded,
                                   String ref, 
                                   boolean isMultiRM) {
        _cf = cf;
        _ref = ref;
        _isEmbeded = isEmbeded;
        _isMultiRM = isMultiRM;
    }

    public XAConnection
    createXAConnection() throws JMSException {
    return _cf.createXAConnection();
    }


    public XAConnection
    createXAConnection(String userName, String password) 
                                    throws JMSException {
    return _cf.createXAConnection(userName, password);
    }

    public String getRef() {
        return _ref;
    }

    public Object getRefed() {
        return _cf;
    }

    public boolean isEmbeded() {
        return _isEmbeded; 
    }

    public boolean isMultiRM() {
        return _isMultiRM; 
    }

    public String toString() {
        String refs = _ref+(_isEmbeded ? ", embeded":"")+(_isMultiRM ? ", multirm":"");
        String s = null;
        if (_firstTime) {
            s = "["+refs+"]"+_cf.toString();
            _firstTime = false;
        } else {
            s = "["+refs+"]"+_cf.getClass().getName();
        }
        return s;
    }
}
