/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)iMQDestinationShim.cpp	1.12 06/26/07
 */ 

#include "mqdestination.h"
#include "shimUtils.hpp"
#include "../client/Destination.hpp"
#include "../client/Session.hpp"


EXPORTED_SYMBOL MQStatus 
MQFreeDestination(MQDestinationHandle destinationHandle)
{
  CLEAR_ERROR_TRACE(PR_FALSE);
  
  return freeHandledObject(destinationHandle.handle, DESTINATION_OBJECT);
}

/**
 * Get destination type of a destination
 *
 * @param destinationHandle the destination to type from
 * @param destinationType the output parameter for the type
 * @return the status of the function call.  Pass this value to
 *         MQStatusIsError to determine if the call was
 *         successful.  */
EXPORTED_SYMBOL MQStatus
MQGetDestinationType(const MQDestinationHandle destinationHandle,
                     MQDestinationType *       destinationType)
{
  static const char FUNCNAME[] = "MQGetDestinationType";
  MQError errorCode = MQ_SUCCESS;
  Destination * destination = NULL;

  CLEAR_ERROR_TRACE(PR_FALSE);

  CNDCHK( destinationType == NULL, MQ_NULL_PTR_ARG );
  destination = (Destination*)getHandledObject(destinationHandle.handle,
                                               DESTINATION_OBJECT);
  CNDCHK( destination == NULL, MQ_STATUS_INVALID_HANDLE);
  if ( destination->getIsQueue() == PR_TRUE) {
    *destinationType = MQ_QUEUE_DESTINATION;
  } else {
    *destinationType = MQ_TOPIC_DESTINATION;
  }

  releaseHandledObject(destination);
  RETURN_STATUS( MQ_SUCCESS );
Cleanup:
  releaseHandledObject(destination);
  MQ_ERROR_TRACE( FUNCNAME, errorCode );
  RETURN_STATUS( errorCode );
}


/**
 * Get the destination name of a destination. The returned
 * destinationName is a copy which the caller is responsible
 * to free by calling MQFreeString
 *
 * @param destinationHandle the destination to get name from 
 * @param destinationName the output parameter for the name 
 * @return the status of the function call.  Pass this value to
 *         MQStatusIsError to determine if the call was
 *         successful.  */
EXPORTED_SYMBOL MQStatus
MQGetDestinationName(const MQDestinationHandle destinationHandle,
                     MQString *                destinationName)
{
  static const char FUNCNAME[] = "MQGetDestinationName";
  MQError errorCode = MQ_SUCCESS;
  Destination * destination = NULL;

  CLEAR_ERROR_TRACE(PR_FALSE);

  CNDCHK( destinationName == NULL, MQ_NULL_PTR_ARG );
  *destinationName = NULL;

  destination = (Destination*)getHandledObject(destinationHandle.handle,
                                               DESTINATION_OBJECT);
  CNDCHK( destination == NULL, MQ_STATUS_INVALID_HANDLE);
  {
  const UTF8String * name = destination->getName();
  CNDCHK( name == NULL, MQ_DESTINATION_NO_NAME );
  ConstMQString namec = name->getCharStr(); 
  MQString destName = new MQChar[STRLEN(namec)+1];
  CNDCHK( destName == NULL, MQ_OUT_OF_MEMORY );
  STRCPY(destName, namec);
  *destinationName = destName;
  }

  releaseHandledObject(destination);
  RETURN_STATUS( MQ_SUCCESS );
Cleanup:
  releaseHandledObject(destination);
  MQ_ERROR_TRACE( FUNCNAME, errorCode );
  RETURN_STATUS( errorCode );
}

