/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.LinkedList;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AnimatedAttributeListener;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMElement;

public abstract class AbstractSVGAnimatedValue
implements AnimatedLiveAttributeValue {
    protected AbstractElement element;
    protected String namespaceURI;
    protected String localName;
    protected boolean hasAnimVal;
    protected LinkedList listeners = new LinkedList();

    public AbstractSVGAnimatedValue(AbstractElement abstractElement, String string, String string2) {
        this.element = abstractElement;
        this.namespaceURI = string;
        this.localName = string2;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isSpecified() {
        return this.hasAnimVal || this.element.hasAttributeNS(this.namespaceURI, this.localName);
    }

    protected abstract void updateAnimatedValue(AnimatableValue var1);

    public void addAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        if (!this.listeners.contains(animatedAttributeListener)) {
            this.listeners.add(animatedAttributeListener);
        }
    }

    public void removeAnimatedAttributeListener(AnimatedAttributeListener animatedAttributeListener) {
        this.listeners.remove(animatedAttributeListener);
    }

    protected void fireBaseAttributeListeners() {
        if (this.element instanceof SVGOMElement) {
            ((SVGOMElement)this.element).fireBaseAttributeListeners(this.namespaceURI, this.localName);
        }
    }

    protected void fireAnimatedAttributeListeners() {
        for (AnimatedAttributeListener animatedAttributeListener : this.listeners) {
            animatedAttributeListener.animatedAttributeChanged(this.element, this);
        }
    }
}

