/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.SquareVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import de.latlon.deejump.plugin.style.BitmapVertexStyle;
import de.latlon.deejump.plugin.style.CircleVertexStyle;
import de.latlon.deejump.plugin.style.CrossVertexStyle;
import de.latlon.deejump.plugin.style.StarVertexStyle;
import de.latlon.deejump.plugin.style.TriangleVertexStyle;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.openjump.util.CustomTexturePaint;
import org.openjump.util.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLDImporter {
    private static final Logger LOG = Logger.getLogger(SLDImporter.class);
    public static final String SLDNS = "http://www.opengis.net/sld";
    public static final String OGCNS = "http://www.opengis.net/ogc";
    public static final NamespaceContext NSCONTEXT = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("sld")) {
                return SLDImporter.SLDNS;
            }
            if (prefix.equals("ogc")) {
                return SLDImporter.OGCNS;
            }
            return null;
        }

        @Override
        public String getPrefix(String namespace) {
            if (namespace.equals(SLDImporter.SLDNS)) {
                return "sld";
            }
            if (namespace.equals(SLDImporter.OGCNS)) {
                return "ogc";
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespace) {
            if (namespace.equals(SLDImporter.SLDNS)) {
                return new Iterator<String>(){
                    boolean done = false;

                    @Override
                    public boolean hasNext() {
                        return !this.done;
                    }

                    @Override
                    public String next() {
                        this.done = true;
                        return "sld";
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            if (namespace.equals(SLDImporter.OGCNS)) {
                return new Iterator<String>(){
                    boolean done = false;

                    @Override
                    public boolean hasNext() {
                        return !this.done;
                    }

                    @Override
                    public String next() {
                        this.done = true;
                        return "ogc";
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return null;
        }
    };

    public static LinkedList<String> getRuleNames(Document doc) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            LinkedList<Element> elems = XPathUtils.getElements("//sld:Rule/sld:Name", doc.getDocumentElement(), NSCONTEXT);
            for (Element e : elems) {
                list.add(e.getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static LinkedList<String> getRuleNamesWithGeometrySymbolizers(Document doc) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            LinkedList<Element> elems = XPathUtils.getElements("//sld:Rule[(count(sld:PointSymbolizer)+count(sld:LineSymbolizer)+count(sld:PolygonSymbolizer))>0]/sld:Name", doc.getDocumentElement(), NSCONTEXT);
            for (Element e : elems) {
                list.add(e.getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static LinkedList<String> getPossibleColorThemingStyleNames(Document doc) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            LinkedList<Element> elems = XPathUtils.getElements("//sld:UserStyle[count(sld:FeatureTypeStyle/sld:Rule/ogc:Filter) > 0]/sld:Name", doc.getDocumentElement(), NSCONTEXT);
            for (Element e : elems) {
                list.add(e.getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static LinkedList<String> getRuleNamesWithTextSymbolizers(Document doc) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            LinkedList<Element> elems = XPathUtils.getElements("//sld:Rule[count(sld:TextSymbolizer)>0]/sld:Name", doc.getDocumentElement(), NSCONTEXT);
            for (Element e : elems) {
                list.add(e.getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static BasicStyle getBasicStyle(String name, Document doc) {
        try {
            return SLDImporter.getBasicStyle(XPathUtils.getElement("//sld:Rule[sld:Name='" + name + "']", doc.getDocumentElement(), NSCONTEXT));
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public static BasicStyle getBasicStyle(Element rule) {
        if (rule == null) {
            return null;
        }
        try {
            BasicStyle style = new BasicStyle();
            style.setRenderingFill(false);
            style.setRenderingFillPattern(false);
            style.setRenderingLine(false);
            style.setRenderingLinePattern(false);
            boolean oneApplied = false;
            Element symbolizer = XPathUtils.getElement("sld:PointSymbolizer", rule, NSCONTEXT);
            if (symbolizer != null) {
                oneApplied = true;
            }
            SLDImporter.applyPointSymbolizer(symbolizer, style);
            symbolizer = XPathUtils.getElement("sld:LineSymbolizer", rule, NSCONTEXT);
            if (symbolizer != null) {
                oneApplied = true;
            }
            SLDImporter.applyLineSymbolizer(symbolizer, style);
            symbolizer = XPathUtils.getElement("sld:PolygonSymbolizer", rule, NSCONTEXT);
            if (symbolizer != null) {
                oneApplied = true;
            }
            SLDImporter.applyPolygonSymbolizer(symbolizer, style);
            if (!oneApplied) {
                return null;
            }
            return style;
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public static VertexStyle getVertexStyle(String name, Document doc) {
        try {
            Element rule = XPathUtils.getElement("//sld:Rule[sld:Name='" + name + "']", doc.getDocumentElement(), NSCONTEXT);
            if (rule == null) {
                return null;
            }
            Element symbolizer = XPathUtils.getElement("sld:PointSymbolizer", rule, NSCONTEXT);
            return SLDImporter.applyPointSymbolizer(symbolizer, new BasicStyle());
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    private static VertexStyle applyPointSymbolizer(Element symbolizer, BasicStyle style) throws XPathExpressionException {
        int size;
        if (symbolizer == null) {
            return null;
        }
        Element e = XPathUtils.getElement(".//sld:WellKnownName", symbolizer, NSCONTEXT);
        VertexStyle extra = null;
        if (e != null) {
            String n = e.getTextContent();
            if (n != null) {
                n = n.trim();
            }
            if (n != null) {
                if (n.equalsIgnoreCase("circle")) {
                    extra = new CircleVertexStyle();
                }
                if (n.equalsIgnoreCase("cross")) {
                    extra = new CrossVertexStyle();
                }
                if (n.equalsIgnoreCase("square")) {
                    extra = new SquareVertexStyle();
                }
                if (n.equalsIgnoreCase("star")) {
                    extra = new StarVertexStyle();
                }
                if (n.equalsIgnoreCase("triangle")) {
                    extra = new TriangleVertexStyle();
                }
            }
        }
        if (extra == null) {
            extra = SLDImporter.parseGraphic(symbolizer);
        }
        if ((size = XPathUtils.getInt("sld:size", symbolizer, NSCONTEXT)) != 0) {
            extra.setSize(size / 2);
        }
        Element fill = XPathUtils.getElement(".//sld:Fill", symbolizer, NSCONTEXT);
        Element stroke = XPathUtils.getElement(".//sld:Stroke", symbolizer, NSCONTEXT);
        SLDImporter.applyFill(fill, style);
        SLDImporter.applyStroke(stroke, style);
        if (extra != null) {
            SLDImporter.applyFill(fill, extra);
            SLDImporter.applyStroke(stroke, extra);
        }
        return extra;
    }

    private static BasicStyle applyLineSymbolizer(Element symbolizer, BasicStyle style) throws XPathExpressionException {
        if (symbolizer == null) {
            return null;
        }
        Element fill = XPathUtils.getElement("sld:Fill", symbolizer, NSCONTEXT);
        Element stroke = XPathUtils.getElement("sld:Stroke", symbolizer, NSCONTEXT);
        SLDImporter.applyFill(fill, style);
        SLDImporter.applyStroke(stroke, style);
        return style;
    }

    private static BasicStyle applyPolygonSymbolizer(Element symbolizer, BasicStyle style) throws XPathExpressionException {
        if (symbolizer == null) {
            return null;
        }
        Element fill = XPathUtils.getElement("sld:Fill", symbolizer, NSCONTEXT);
        Element stroke = XPathUtils.getElement("sld:Stroke", symbolizer, NSCONTEXT);
        URL u = SLDImporter.parseGraphicURL(symbolizer);
        if (u != null) {
            CustomTexturePaint p = new CustomTexturePaint(u);
            style.setFillPattern(p);
            style.setRenderingFillPattern(true);
        }
        SLDImporter.applyFill(fill, style);
        SLDImporter.applyStroke(stroke, style);
        return style;
    }

    private static void applyFill(Element fill, StrokeFillStyle style) throws XPathExpressionException {
        if (fill == null) {
            return;
        }
        if (style instanceof BasicStyle) {
            ((BasicStyle)style).setRenderingFill(true);
        }
        LinkedList<Element> params = XPathUtils.getElements("sld:CssParameter", fill, NSCONTEXT);
        for (Element p : params) {
            String type = p.getAttribute("name");
            String a = p.getTextContent();
            if (a == null || a.trim().length() == 0) continue;
            a = a.trim();
            if (type.equals("fill")) {
                style.setFillColor(Color.decode(a));
            }
            if (!type.equals("fill-opacity")) continue;
            style.setAlpha((int)(255.0 * Double.parseDouble(a)));
        }
    }

    private static void applyStroke(Element stroke, StrokeFillStyle style) throws XPathExpressionException {
        if (stroke == null) {
            return;
        }
        if (style instanceof BasicStyle) {
            ((BasicStyle)style).setRenderingLine(true);
        }
        LinkedList<Element> params = XPathUtils.getElements("sld:CssParameter", stroke, NSCONTEXT);
        for (Element p : params) {
            String type = p.getAttribute("name");
            String a = p.getTextContent();
            if (a == null || a.trim().length() == 0) continue;
            a = a.trim();
            if (type.equals("stroke")) {
                style.setLineColor(Color.decode(a));
            }
            if (type.equals("stroke-width")) {
                style.setLineWidth((int)Double.parseDouble(a));
            }
            if (type.equals("stroke-opacity")) {
                style.setAlpha((int)(255.0 * Double.parseDouble(a)));
            }
            if (!type.equals("stroke-dasharray")) continue;
            style.setLinePattern(a.replace(' ', ','));
            style.setRenderingLinePattern(true);
        }
    }

    private static URL parseGraphicURL(Element e) throws XPathExpressionException {
        if ((e = XPathUtils.getElement(".//sld:OnlineResource", e, NSCONTEXT)) == null) {
            return null;
        }
        String s = e.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException ex) {
            try {
                u = new File(s).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        return u;
    }

    private static VertexStyle parseGraphic(Element e) throws XPathExpressionException {
        URL u = SLDImporter.parseGraphicURL(e);
        if (u != null) {
            return new BitmapVertexStyle(u.getFile());
        }
        return null;
    }

    public static LabelStyle getLabelStyle(String name, Document doc) {
        try {
            LabelStyle style = new LabelStyle();
            Element symbolizer = XPathUtils.getElement("//sld:Rule[sld:Name='" + name + "']/sld:TextSymbolizer", doc.getDocumentElement(), NSCONTEXT);
            if (symbolizer == null) {
                return null;
            }
            Element label = XPathUtils.getElement("sld:Label", symbolizer, NSCONTEXT);
            String lAtt = XPathUtils.getElement("ogc:PropertyName", label, NSCONTEXT).getTextContent();
            lAtt = lAtt.substring(lAtt.indexOf(58) + 1);
            style.setAttribute(lAtt);
            Element fill = XPathUtils.getElement("sld:Fill", symbolizer, NSCONTEXT);
            if (fill != null) {
                LinkedList<Element> params = XPathUtils.getElements("sld:CssParameter", fill, NSCONTEXT);
                for (Element p : params) {
                    String type = p.getAttribute("name");
                    String a = p.getTextContent();
                    if (a == null || a.trim().length() == 0) continue;
                    a = a.trim();
                    if (!type.equals("fill")) continue;
                    style.setColor(Color.decode(a));
                }
            }
            Element font = XPathUtils.getElement("sld:Font", symbolizer, NSCONTEXT);
            LinkedList<Element> params = XPathUtils.getElements("sld:CssParameter", font, NSCONTEXT);
            String fFamily = null;
            int fStyle = 0;
            int fSize = 0;
            for (Element p : params) {
                String type = p.getAttribute("name");
                String a = p.getTextContent();
                if (a == null || a.trim().length() == 0) continue;
                a = a.trim();
                if (type.equals("font-family")) {
                    fFamily = a;
                }
                if (type.equals("font-style")) {
                    if (a.equalsIgnoreCase("normal")) {
                        fStyle |= 0;
                    }
                    if (a.equalsIgnoreCase("italic")) {
                        fStyle |= 2;
                    }
                }
                if (type.equals("font-weight")) {
                    if (a.equalsIgnoreCase("normal")) {
                        fStyle |= 0;
                    }
                    if (a.equalsIgnoreCase("bold")) {
                        fStyle |= 1;
                    }
                }
                if (!type.equals("font-size")) continue;
                fSize = (int)Math.round(Double.parseDouble(a));
            }
            style.setFont(new Font(fFamily, fStyle, fSize));
            style.setEnabled(true);
            Element halo = XPathUtils.getElement("sld:Halo", symbolizer, NSCONTEXT);
            if (halo != null) {
                style.setOutlineShowing(true);
                Element rad = XPathUtils.getElement("sld:Radius", halo, NSCONTEXT);
                if (rad != null) {
                    style.setOutlineWidth((int)Double.parseDouble(rad.getTextContent()));
                }
                params = XPathUtils.getElements("sld:CssParameter", XPathUtils.getElement("sld:Fill", halo, NSCONTEXT), NSCONTEXT);
                for (Element p : params) {
                    String type = p.getAttribute("name");
                    String a = p.getTextContent();
                    if (a == null || a.trim().length() == 0) continue;
                    a = a.trim();
                    if (!type.equals("fill")) continue;
                    style.setOutlineColor(Color.decode(a));
                }
            }
            return style;
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    private static Object parseValues(Element filter) throws XPathExpressionException {
        if (filter == null) {
            LOG.warn((Object)"An ogc:filter could not be found while trying to parse a color theming style.");
            return null;
        }
        Element lower = XPathUtils.getElement(".//ogc:LowerBoundary", filter, NSCONTEXT);
        Element upper = XPathUtils.getElement(".//ogc:UpperBoundary", filter, NSCONTEXT);
        if (lower != null && upper != null) {
            String s1 = XPathUtils.getElement("ogc:Literal", lower, NSCONTEXT).getTextContent().trim();
            String s2 = XPathUtils.getElement("ogc:Literal", upper, NSCONTEXT).getTextContent().trim();
            return new Range(s1, true, s2, false);
        }
        boolean lowerEqual = false;
        boolean upperEqual = false;
        upper = XPathUtils.getElement(".//ogc:PropertyIsLessThan", filter, NSCONTEXT);
        if (upper == null) {
            upper = XPathUtils.getElement(".//ogc:PropertyIsLessThanOrEqualTo", filter, NSCONTEXT);
            upperEqual = true;
        }
        if ((lower = XPathUtils.getElement(".//ogc:PropertyIsGreaterThan", filter, NSCONTEXT)) == null) {
            lower = XPathUtils.getElement(".//ogc:PropertyIsGreaterThanOrEqualTo", filter, NSCONTEXT);
            lowerEqual = true;
        }
        if (lower != null && upper != null) {
            String s1 = XPathUtils.getElement("ogc:Literal", lower, NSCONTEXT).getTextContent().trim();
            String s2 = XPathUtils.getElement("ogc:Literal", upper, NSCONTEXT).getTextContent().trim();
            return new Range(s1, lowerEqual, s2, upperEqual);
        }
        return XPathUtils.getElement(".//ogc:Literal", filter, NSCONTEXT).getTextContent().trim();
    }

    public static ColorThemingStyle getColorThemingStyle(String name, Document doc) {
        try {
            Element featureTypeStyle = XPathUtils.getElement("//sld:UserStyle[(count(sld:FeatureTypeStyle/sld:Rule/ogc:Filter) > 0) and sld:Name='" + name + "']/sld:FeatureTypeStyle", doc.getDocumentElement(), NSCONTEXT);
            if (featureTypeStyle == null) {
                return null;
            }
            ColorThemingStyle style = new ColorThemingStyle();
            String att = XPathUtils.getElement(".//ogc:PropertyName", featureTypeStyle, NSCONTEXT).getTextContent();
            style.setAttributeName(att);
            HashMap<Object, BasicStyle> map = new HashMap<Object, BasicStyle>();
            HashMap<Object, String> labelMap = new HashMap<Object, String>();
            LinkedList<Element> rules = XPathUtils.getElements("sld:Rule", featureTypeStyle, NSCONTEXT);
            for (Element rule : rules) {
                BasicStyle basic = SLDImporter.getBasicStyle(rule);
                Object val = SLDImporter.parseValues(XPathUtils.getElement("ogc:Filter", rule, NSCONTEXT));
                if (val == null) continue;
                map.put(val, basic);
                labelMap.put(val, val.toString());
            }
            style.setAttributeValueToBasicStyleMap(map);
            style.setAttributeValueToLabelMap(labelMap);
            return style;
        }
        catch (XPathExpressionException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public static interface SizedStrokeFillStyle
    extends StrokeFillStyle,
    SizedStyle {
    }

    public static interface StrokeFillStyle
    extends StrokeStyle,
    FillStyle,
    Style {
    }

    public static interface SizedStyle {
        public void setSize(int var1);
    }

    public static interface StrokeStyle {
        public void setLineColor(Color var1);

        public void setLineWidth(int var1);

        public void setAlpha(int var1);

        public BasicStyle setRenderingLinePattern(boolean var1);

        public BasicStyle setLinePattern(String var1);
    }

    public static interface FillStyle {
        public void setFillColor(Color var1);

        public void setAlpha(int var1);
    }
}

