/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing.wizard;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardContext;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.openjump.core.ui.swing.wizard.WizardGroup;
import org.openjump.core.ui.swing.wizard.WizardGroupListCellRenderer;
import org.openjump.swing.listener.InvokeMethodListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardGroupDialog
extends WizardDialog
implements WizardContext,
InputChangedListener {
    private List<WizardGroup> wizards = new ArrayList<WizardGroup>();
    private JList groupSelectList;
    public WizardGroup currentWizard;
    private WorkbenchContext workbenchContext;

    public WizardGroupDialog(WorkbenchContext workbenchContext, Frame frame, String title) {
        super(frame, title, workbenchContext.getErrorHandler());
        this.workbenchContext = workbenchContext;
        this.initUi();
    }

    private void initUi() {
        Container contentPane = this.getContentPane();
        this.groupSelectList = new JList(new DefaultListModel());
        this.groupSelectList.setSelectionMode(0);
        this.groupSelectList.setVisibleRowCount(-1);
        this.groupSelectList.setLayoutOrientation(0);
        this.groupSelectList.setCellRenderer(new WizardGroupListCellRenderer());
        this.groupSelectList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.groupSelectList.addListSelectionListener(new InvokeMethodListSelectionListener(this, "updateSelectedWizard"));
        JScrollPane groupScrollPane = new JScrollPane(this.groupSelectList);
        contentPane.add((Component)groupScrollPane, "West");
    }

    public void addWizard(WizardGroup wizard) {
        DefaultListModel model = (DefaultListModel)this.groupSelectList.getModel();
        model.addElement(wizard);
    }

    public void addWizards(List<WizardGroup> wizards) {
        for (WizardGroup wizard : wizards) {
            this.addWizard(wizard);
        }
    }

    public void updateSelectedWizard() {
        WizardGroup selectedWizard = this.getSelectedWizard();
        if (selectedWizard != null && this.currentWizard != selectedWizard) {
            this.initSelectedWizard(selectedWizard);
        }
    }

    private void initSelectedWizard(WizardGroup selectedWizard) {
        this.currentWizard = selectedWizard;
        this.currentWizard.initialize(this.workbenchContext, this);
        this.setPanels(selectedWizard.getPanels());
        this.setCurrentWizardPanel(this.currentWizard.getFirstId());
        this.pack();
    }

    public WizardGroup getSelectedWizard() {
        return (WizardGroup)this.groupSelectList.getSelectedValue();
    }

    public void setSelectedWizard(WizardGroup wizardGroup) {
        if (wizardGroup != null) {
            if (wizardGroup == this.currentWizard) {
                this.initSelectedWizard(wizardGroup);
            } else {
                this.groupSelectList.setSelectedValue(wizardGroup, true);
            }
        } else {
            this.groupSelectList.setSelectedIndex(0);
        }
    }
}

