/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing.factory.field;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.openjump.core.ui.swing.CheckBoxComponentPanel;
import org.openjump.swing.factory.field.FieldComponentFactory;
import org.openjump.swing.listener.ValueChangeEvent;
import org.openjump.swing.listener.ValueChangeListener;

public class CheckBoxFieldComponentFactory
implements FieldComponentFactory {
    private WorkbenchContext workbenchContext;
    private String option;

    public CheckBoxFieldComponentFactory(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }

    public CheckBoxFieldComponentFactory(WorkbenchContext workbenchContext, String option) {
        this.workbenchContext = workbenchContext;
        this.option = option;
    }

    public Object getValue(JComponent component) {
        if (component instanceof CheckBoxComponentPanel) {
            CheckBoxComponentPanel checkBoxComponentPanel = (CheckBoxComponentPanel)component;
            if (checkBoxComponentPanel == null) {
                return null;
            }
            if (checkBoxComponentPanel.isSelected()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public void setValue(JComponent component, Object value) {
        if (component instanceof CheckBoxComponentPanel) {
            CheckBoxComponentPanel checkBoxComponentPanel = (CheckBoxComponentPanel)component;
            if (value != null && value == Boolean.TRUE) {
                checkBoxComponentPanel.getCheckBox().setSelected(true);
            } else if (value != null && value == Boolean.FALSE) {
                checkBoxComponentPanel.getCheckBox().setSelected(false);
            }
        }
    }

    public JComponent createComponent() {
        CheckBoxComponentPanel checkBoxComponentPanel = new CheckBoxComponentPanel(this.option, this.workbenchContext.getErrorHandler());
        return checkBoxComponentPanel;
    }

    public JComponent createComponent(final ValueChangeListener listener) {
        final CheckBoxComponentPanel checkBoxComponentPanel = new CheckBoxComponentPanel(this.option, this.workbenchContext.getErrorHandler());
        checkBoxComponentPanel.getCheckBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Boolean value = new Boolean(checkBoxComponentPanel.isSelected());
                listener.valueChanged(new ValueChangeEvent(checkBoxComponentPanel, value));
            }
        });
        return checkBoxComponentPanel;
    }
}

