/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.geometrychange;

import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.List;
import javax.swing.JComboBox;
import org.openjump.core.graph.polygongraph.PolygonGraph;

public class ExtractCommonBoundaryBetweenPolysPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sName = "Extract Common Boundary Between Polygons";
    private String sSidebar = "Classifies the boundaries of a polygon by using a neighbourhood graph.";
    private String sCreateGraph = "create graph";
    private String sBoundaries = "boundaries";
    private String LAYERREGIONS = "select layer with polygons";
    private FeatureCollection regions = null;
    private Layer input = null;
    private MultiInputDialog dialog;

    public void initialize(PlugInContext context) throws Exception {
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.Extract-Common-Boundary-Between-Polygons");
        this.sSidebar = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.Classifies-the-boundaries-of-a-polygon-by-using-a-neighbourhood-graph");
        this.sCreateGraph = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.create-graph");
        this.sBoundaries = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.boundaries");
        this.LAYERREGIONS = I18N.get("org.openjump.core.ui.plugin.tools.ExtractCommonBoundaryBetweenPolysPlugIn.select-layer-with-polygons");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.sName + "...", false, null, ExtractCommonBoundaryBetweenPolysPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.input = this.dialog.getLayer(this.LAYERREGIONS);
        this.regions = this.input.getFeatureCollectionWrapper();
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        System.gc();
        monitor.allowCancellationRequests();
        List features = this.regions.getFeatures();
        Feature firstFeature = (Feature)features.iterator().next();
        if (firstFeature.getGeometry() instanceof Polygon) {
            monitor.report(this.sCreateGraph);
            PolygonGraph pg = new PolygonGraph(features, monitor);
            FeatureCollection resultD = pg.getSharedBoundaries();
            resultD.addAll(pg.getNonSharedBoundaries().getFeatures());
            context.addLayer(StandardCategoryNames.RESULT, this.input + "-" + this.sBoundaries, resultD);
        } else {
            context.getWorkbenchFrame().warnUser("no (simple) polygon geometries found");
        }
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.dialog.setSideBarDescription(this.sSidebar);
        try {
            JComboBox addLayerComboBoxRegions = this.dialog.addLayerComboBox(this.LAYERREGIONS, context.getCandidateLayer(0), null, context.getLayerManager());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        GUIUtil.centreOnWindow(this.dialog);
    }
}

