/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openjump.sigle.utilities.gui.DialogUtil;

public class ReplaceValuePlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private MultiInputDialog dialog;
    private static String ATTRIBUTE = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute");
    private static String VALUE = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.New-value");
    private static String ATTRIBUTE_SRC = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute-src");
    private static String BY_ATTRIBUTE = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.New-value-by-copy");
    private static String TYPE = "";
    private static String SELECTED_ONLY = GenericNames.USE_SELECTED_FEATURES_ONLY;
    private static String DESCRIPTION = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Description");
    private Layer layer;
    private String attrName;
    private String attrNameSrc;
    private String value = "";
    private boolean useSelected = true;
    private boolean byAttribute = false;
    public static final ImageIcon ICON = IconLoader.icon("Wrench.gif");

    public void initialize(PlugInContext context) {
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName(), false, null, ReplaceValuePlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public String getName() {
        return I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Replace-Attribute-Value");
    }

    public boolean execute(PlugInContext context) throws Exception {
        ATTRIBUTE = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute");
        VALUE = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.New-value");
        ATTRIBUTE_SRC = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute-src");
        BY_ATTRIBUTE = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.New-value-by-copy");
        SELECTED_ONLY = GenericNames.USE_SELECTED_FEATURES_ONLY;
        DESCRIPTION = I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Description");
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        if (this.layer.isEditable()) {
            GUIUtil.centreOnWindow(this.dialog);
            this.dialog.setVisible(true);
            if (!this.dialog.wasOKPressed()) {
                return false;
            }
            this.getDialogValues(this.dialog);
            return true;
        }
        JOptionPane.showMessageDialog(this.dialog, I18N.get("ui.SchemaPanel.layer-must-be-editable"));
        return false;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        if (this.layer == null) {
            return;
        }
        if (this.attrName == null) {
            return;
        }
        if (this.value == null && this.attrNameSrc == null) {
            return;
        }
        List srcFeatures = this.layer.getFeatureCollectionWrapper().getFeatures();
        if (this.useSelected) {
            Collection featureSelected = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(this.layer);
            monitor.report(I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Replacing-values"));
            if (this.byAttribute) {
                this.replaceByAttributeValue(featureSelected, this.attrName, this.attrNameSrc);
            } else {
                this.replaceValue(featureSelected, this.attrName, this.value);
            }
        } else if (this.byAttribute) {
            this.replaceByAttributeValue(srcFeatures, this.attrName, this.attrNameSrc);
        } else {
            this.replaceValue(srcFeatures, this.attrName, this.value);
        }
        this.layer.fireAppearanceChanged();
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(DESCRIPTION);
        this.layer = context.getSelectedLayer(0);
        List columns = DialogUtil.getFieldsFromLayerWithoutGeometry(this.layer);
        String column1 = null;
        if (columns.size() > 0) {
            column1 = (String)columns.get(0);
        }
        dialog.addComboBox(ATTRIBUTE, column1, columns, "Attribute to modify");
        final JTextField textfield = dialog.addTextField(I18N.get("org.openjump.sigle.plugin.ReplaceValuePlugIn.Attribute-type"), this.layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(column1).toString(), 10, null, null);
        textfield.setEnabled(false);
        dialog.getComboBox(ATTRIBUTE).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String attributeName = (String)cb.getSelectedItem();
                textfield.setText(ReplaceValuePlugIn.this.layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(attributeName).toString());
            }
        });
        dialog.addCheckBox(BY_ATTRIBUTE, this.byAttribute);
        dialog.addComboBox(ATTRIBUTE_SRC, column1, columns, "Nom du champ source de la valeur");
        dialog.getComboBox(ATTRIBUTE_SRC).setEnabled(this.byAttribute);
        final JTextField valuetextfield = dialog.addTextField(VALUE, this.value, 20, null, null);
        valuetextfield.setEnabled(!this.byAttribute);
        dialog.getCheckBox(BY_ATTRIBUTE).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox chk = (JCheckBox)e.getSource();
                valuetextfield.setEnabled(!chk.isSelected());
                dialog.getComboBox(ATTRIBUTE_SRC).setEnabled(chk.isSelected());
            }
        });
        dialog.addCheckBox(SELECTED_ONLY, true);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.attrName = dialog.getText(ATTRIBUTE);
        this.value = dialog.getText(VALUE);
        this.useSelected = dialog.getBoolean(SELECTED_ONLY);
        this.attrNameSrc = dialog.getText(ATTRIBUTE_SRC);
        this.byAttribute = dialog.getBoolean(BY_ATTRIBUTE);
    }

    private void replaceValue(Collection selectedFC, String attrName, String value) {
        AttributeType type = ((Feature)selectedFC.iterator().next()).getSchema().getAttributeType(attrName);
        for (Feature f : selectedFC) {
            if (this.byAttribute) continue;
            if (type == AttributeType.DOUBLE) {
                f.setAttribute(attrName, (Object)new Double(value));
                continue;
            }
            if (type == AttributeType.INTEGER) {
                f.setAttribute(attrName, (Object)new Integer(value));
                continue;
            }
            if (type != AttributeType.STRING) continue;
            f.setAttribute(attrName, (Object)new String(value));
        }
    }

    private void replaceByAttributeValue(Collection selectedFC, String attrNameDest, String attrNameSrc) {
        AttributeType typeDest = ((Feature)selectedFC.iterator().next()).getSchema().getAttributeType(attrNameDest);
        for (Feature f : selectedFC) {
            String AttrValue = (String)f.getAttribute(attrNameSrc);
            if (!this.byAttribute) continue;
            if (typeDest == AttributeType.DOUBLE) {
                f.setAttribute(attrNameDest, (Object)new Double(AttrValue));
                continue;
            }
            if (typeDest == AttributeType.INTEGER) {
                f.setAttribute(attrNameDest, (Object)new Integer(AttrValue));
                continue;
            }
            if (typeDest != AttributeType.STRING) continue;
            f.setAttribute(attrNameDest, (Object)new String(AttrValue));
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck());
    }
}

