/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import java.util.Collection;
import javax.swing.JComponent;
import org.openjump.core.geomutils.GeoUtils;

public class PlumePlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private static final String sNew = I18N.get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.New");
    private static final String sTheradius = I18N.get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.The-arc-radius");
    private static final String selectLineStrings = I18N.get("ui.cursortool.SelectLineStringsTool.select-linestrings");
    private static final String RADIUS = I18N.get("org.openjump.core.ui.plugin.tools.JoinWithArcPlugIn.Radius");
    private static final String RADIUS1 = RADIUS + " 1";
    private static final String RADIUS2 = RADIUS + " 2";
    private double radius1 = 5.0;
    private double radius2 = 50.0;

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, this.createEnableCheck(this.workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        Geometry plume = null;
        if (selectedFeatures.size() != 1) {
            return false;
        }
        Geometry geo = ((Feature)selectedFeatures.iterator().next()).getGeometry();
        if (geo instanceof LineString) {
            plume = GeoUtils.createPlume(geo.getCoordinates(), this.radius1, this.radius2);
        }
        if (plume != null) {
            Feature currFeature = (Feature)selectedFeatures.iterator().next();
            Feature newFeature = (Feature)currFeature.clone();
            newFeature.setGeometry(plume);
            Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
            LayerManager layerManager = context.getLayerManager();
            FeatureDataset newFeatures = new FeatureDataset(currFeature.getSchema());
            newFeatures.add(newFeature);
            layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layerManager.uniqueLayerName(sNew), newFeatures);
            layerManager.getLayer(0).setFeatureCollectionModified(true);
            layerManager.getLayer(0).setEditable(true);
        }
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addDoubleField(RADIUS1, this.radius1, 6, sTheradius);
        dialog.addDoubleField(RADIUS2, this.radius2, 6, sTheradius);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.radius1 = dialog.getDouble(RADIUS1);
        this.radius2 = dialog.getDouble(RADIUS2);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createOnlyOneLayerMayHaveSelectedFeaturesCheck()).add(checkFactory.createExactlyNFeaturesMustHaveSelectedItemsCheck(1)).add(this.onlyOneLinestringMayBeSelected(workbenchContext));
    }

    public EnableCheck onlyOneLinestringMayBeSelected(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            public String check(JComponent component) {
                Collection selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                if ((Geometry)selectedItems.iterator().next() instanceof LineString) {
                    return null;
                }
                return selectLineStrings;
            }
        };
    }
}

