/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import de.latlon.deejump.plugin.style.VertexStylesFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel;

public class MeasurementStyle
implements Style {
    private Layer layer;
    private boolean enabled = false;
    private String areaAttribute = "area";
    private String lengthAttribute = "length";
    private boolean paintSummaryLength = true;
    private boolean paintSummaryArea = true;
    private Font summaryFont = AdvancedMeasureOptionsPanel.DEFAULT_SUMMARY_FONT;
    private Color summaryColor = AdvancedMeasureOptionsPanel.DEFAULT_SUMMARY_COLOR;
    private boolean vertexPaintDistance = true;
    private Font vertexFont = new Font("Dialog", 0, 12);
    private Color vertexFontColor = AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FONT_COLOR;
    private boolean vertexPaint = true;
    private Color vertexFirstColor = AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FIRST_COLOR;
    private String vertexFirstForm = "SQUARE";
    private int vertexFirstSize = 10;
    private Color vertexFollowingColor = AdvancedMeasureOptionsPanel.DEFAULT_VERTEX_FOLLOWING_COLOR;
    private String vertexFollowingForm = "SQUARE";
    private int vertexFollowingSize = 5;
    private VertexStyle vertexStyleFirst = VertexStylesFactory.createVertexStyle(this.vertexFirstForm);
    private VertexStyle vertexStyleFollowing;

    public MeasurementStyle() {
        this.vertexStyleFirst.setFillColor(this.vertexFirstColor);
        this.vertexStyleFirst.setAlpha(255);
        this.vertexStyleFirst.setSize(this.vertexFirstSize);
        this.vertexStyleFollowing = VertexStylesFactory.createVertexStyle(this.vertexFollowingForm);
        this.vertexStyleFollowing.setFillColor(this.vertexFollowingColor);
        this.vertexStyleFollowing.setAlpha(255);
        this.vertexStyleFollowing.setSize(this.vertexFollowingSize);
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        TextLayout layout;
        Point2D centerPoint;
        Double area = (Double)f.getAttribute(this.areaAttribute);
        Double length = (Double)f.getAttribute(this.lengthAttribute);
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
        String formatPattern = "#,##0.00";
        formatPattern = length >= 10.0 ? "#,##0.00" : (length >= 1.0 ? "#,##0.000" : (length >= 0.1 ? "#,##0.0000" : (length >= 0.01 ? "#,##0.00000" : "#,##0.000000")));
        decimalFormat.applyPattern(formatPattern);
        Coordinate[] coordinates = f.getGeometry().getCoordinates();
        double actualLength = 0.0;
        int numberOfCoordinates = coordinates.length;
        for (int i = 0; i < numberOfCoordinates; ++i) {
            centerPoint = viewport.toViewPoint(coordinates[i]);
            if (i > 0) {
                if (this.vertexPaint && (area > 0.0 && i < numberOfCoordinates - 1 || area == 0.0)) {
                    this.vertexStyleFollowing.paint(g, centerPoint);
                }
                if (!this.vertexPaintDistance) continue;
                layout = new TextLayout(decimalFormat.format(actualLength += coordinates[i].distance(coordinates[i - 1])) + "m", this.vertexFont, g.getFontRenderContext());
                g.setColor(this.vertexFontColor);
                layout.draw(g, (float)centerPoint.getX() - layout.getAdvance() / 2.0f, (float)centerPoint.getY() - layout.getAscent());
                continue;
            }
            if (this.vertexPaint) {
                this.vertexStyleFirst.paint(g, centerPoint);
            }
            if (!this.vertexPaintDistance) continue;
            layout = new TextLayout(decimalFormat.format(actualLength) + "m", this.vertexFont, g.getFontRenderContext());
            g.setColor(this.vertexFontColor);
            layout.draw(g, (float)centerPoint.getX() - layout.getAdvance() / 2.0f, (float)centerPoint.getY() + layout.getAscent() + 5.0f);
        }
        g.setColor(this.summaryColor);
        centerPoint = viewport.toViewPoint(f.getGeometry().getEnvelope().getCentroid().getCoordinate());
        double x = centerPoint.getX();
        double y = centerPoint.getY();
        if (this.paintSummaryLength) {
            layout = new TextLayout(I18N.get("org.openjump.core.ui.plugin.tools.MeasurementStyle.distance") + " " + decimalFormat.format(length) + "m", this.summaryFont, g.getFontRenderContext());
            layout.draw(g, (float)(x -= (double)(layout.getAdvance() / 2.0f)), (float)y);
            y += (double)layout.getAscent();
        }
        if (area > 0.0 && this.paintSummaryArea) {
            layout = new TextLayout(I18N.get("org.openjump.core.ui.plugin.tools.MeasurementStyle.area") + " " + decimalFormat.format(area) + "m\u00b2", this.summaryFont, g.getFontRenderContext());
            if (!this.paintSummaryLength) {
                x -= (double)(layout.getAdvance() / 2.0f);
            }
            layout.draw(g, (float)x, (float)y);
        }
    }

    public void initialize(Layer layer) {
        this.layer = layer;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public String getAreaAttribute() {
        return this.areaAttribute;
    }

    public void setAreaAttribute(String areaAttribute) {
        this.areaAttribute = areaAttribute;
    }

    public String getLengthAttribute() {
        return this.lengthAttribute;
    }

    public void setLengthAttribute(String lengthAttribute) {
        this.lengthAttribute = lengthAttribute;
    }

    public Font getSummaryFont() {
        return this.summaryFont;
    }

    public void setSummaryFont(Font font) {
        this.summaryFont = font;
    }

    public Color getSummaryColor() {
        return this.summaryColor;
    }

    public void setSummaryColor(Color summaryColor) {
        this.summaryColor = summaryColor;
    }

    public boolean isPaintSummaryLength() {
        return this.paintSummaryLength;
    }

    public void setPaintSummaryLength(boolean paintSummary) {
        this.paintSummaryLength = paintSummary;
    }

    public boolean isPaintSummaryArea() {
        return this.paintSummaryArea;
    }

    public void setPaintSummaryArea(boolean paintSummaryArea) {
        this.paintSummaryArea = paintSummaryArea;
    }

    public Font getVertexFont() {
        return this.vertexFont;
    }

    public void setVertexFont(Font vertexFont) {
        this.vertexFont = vertexFont;
    }

    public Color getVertexFontColor() {
        return this.vertexFontColor;
    }

    public void setVertexFontColor(Color vertexFontColor) {
        this.vertexFontColor = vertexFontColor;
    }

    public boolean isVertexPaintDistance() {
        return this.vertexPaintDistance;
    }

    public void setVertexPaintDistance(boolean vertexPaintDistance) {
        this.vertexPaintDistance = vertexPaintDistance;
    }

    public boolean isVertexPaint() {
        return this.vertexPaint;
    }

    public void setVertexPaint(boolean vertexPaint) {
        this.vertexPaint = vertexPaint;
    }

    public Color getVertexFirstColor() {
        return this.vertexFirstColor;
    }

    public void setVertexFirstColor(Color vertexFirstColor) {
        this.vertexFirstColor = vertexFirstColor;
        this.vertexStyleFirst.setFillColor(vertexFirstColor);
    }

    public String getVertexFirstForm() {
        return this.vertexFirstForm;
    }

    public void setVertexFirstForm(String vertexFirstForm) {
        this.vertexFirstForm = vertexFirstForm;
        this.vertexStyleFirst = VertexStylesFactory.createVertexStyle(vertexFirstForm);
        this.vertexStyleFirst.setFillColor(this.vertexFirstColor);
        this.vertexStyleFirst.setAlpha(255);
        this.vertexStyleFirst.setSize(this.vertexFirstSize);
    }

    public int getVertexFirstSize() {
        return this.vertexFirstSize;
    }

    public void setVertexFirstSize(int vertexFirstSize) {
        this.vertexFirstSize = vertexFirstSize;
        this.vertexStyleFirst.setSize(vertexFirstSize);
    }

    public Color getVertexFollowingColor() {
        return this.vertexFollowingColor;
    }

    public void setVertexFollowingColor(Color vertexFollowingColor) {
        this.vertexFollowingColor = vertexFollowingColor;
        this.vertexStyleFollowing.setFillColor(vertexFollowingColor);
    }

    public String getVertexFollowingForm() {
        return this.vertexFollowingForm;
    }

    public void setVertexFollowingForm(String vertexFollowingForm) {
        this.vertexFollowingForm = vertexFollowingForm;
        this.vertexStyleFollowing = VertexStylesFactory.createVertexStyle(vertexFollowingForm);
        this.vertexStyleFollowing.setFillColor(this.vertexFollowingColor);
        this.vertexStyleFollowing.setAlpha(255);
        this.vertexStyleFollowing.setSize(this.vertexFollowingSize);
    }

    public int getVertexFollowingSize() {
        return this.vertexFollowingSize;
    }

    public void setVertexFollowingSize(int vertexFollowingSize) {
        this.vertexFollowingSize = vertexFollowingSize;
        this.vertexStyleFollowing.setSize(vertexFollowingSize);
    }
}

