/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BlendLineStringsPlugIn
extends AbstractPlugIn {
    private WorkbenchContext workbenchContext;
    private final String THE_BLEND_TOLERANCE_TOOLTIP = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.The-blend-tolerance");
    private final String NEW_LAYER = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.New");
    private final String TOLERANCE = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Tolerance");
    private final String PLUGIN_NAME = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Blend-LineStrings");
    private final String REMOVE_SOURCE_LINES = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.remove-source-lines");
    private final String REMOVE_SOURCE_LINES_TOOLTIP = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.The-source-lines-will-be-removed");
    private final String TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.transfer-first-attributes-to-all-resulting-linesstrings");
    private final String TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS_TOOLTIP = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.the-attributes-of-the-first-linestring-will-be-transfered");
    private String CREATE_NEW_LAYER = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.Create-a-new-layer-for-the-results");
    private final String CREATE_NEW_LAYER_TOOLTIP = I18N.get("org.openjump.core.ui.plugin.tools.BlendLineStringsPlugIn.A-new-layer-will-be-created-for-the-results");
    private double blendTolerance = 0.1;
    private boolean removeSourceLines = false;
    private boolean transferFirstAttributesToAllResultingLineStrings = false;
    private boolean createNewLayer = false;
    private JCheckBox removeCheckBox = null;
    private JCheckBox newLayerCheckBox = null;

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.PLUGIN_NAME, false, null, this.createEnableCheck(this.workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Feature currFeature = (Feature)selectedFeatures.iterator().next();
        Collection selectedCategories = context.getLayerNamePanel().getSelectedCategories();
        LayerManager layerManager = context.getLayerManager();
        FeatureDataset newFeatures = new FeatureDataset(currFeature.getSchema());
        ArrayList<Feature> inputFeatures = new ArrayList<Feature>(selectedFeatures.size());
        Layer selectedLayer = (Layer)context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
        for (Feature feature : selectedFeatures) {
            if (!(feature.getGeometry() instanceof LineString)) continue;
            inputFeatures.add(feature);
        }
        while (inputFeatures.size() > 0) {
            boolean blended = false;
            Feature inputFeature = (Feature)inputFeatures.get(0);
            Feature blendedFeature = this.transferFirstAttributesToAllResultingLineStrings ? currFeature.clone(false) : inputFeature.clone(false);
            CoordinateList blendedCoords = new CoordinateList(inputFeature.getGeometry().getCoordinates());
            Feature startFeature = (Feature)inputFeatures.remove(0);
            int currIndex = 0;
            while (currIndex < inputFeatures.size()) {
                inputFeature = (Feature)inputFeatures.get(currIndex);
                CoordinateList lsCoords = new CoordinateList(inputFeature.getGeometry().getCoordinates());
                if (this.blended(blendedCoords, lsCoords)) {
                    inputFeatures.remove(currIndex);
                    currIndex = 0;
                    blended = true;
                    if (!this.removeSourceLines || this.createNewLayer) continue;
                    selectedLayer.getFeatureCollectionWrapper().remove(inputFeature);
                    continue;
                }
                ++currIndex;
            }
            if (!blended) continue;
            if (this.removeSourceLines && !this.createNewLayer) {
                selectedLayer.getFeatureCollectionWrapper().remove(startFeature);
            }
            blendedFeature.setGeometry((Geometry)new GeometryFactory().createLineString(blendedCoords.toCoordinateArray()));
            if (this.createNewLayer) {
                newFeatures.add(blendedFeature);
                continue;
            }
            selectedLayer.getFeatureCollectionWrapper().add(blendedFeature);
        }
        if (this.createNewLayer) {
            layerManager.addLayer(selectedCategories.isEmpty() ? StandardCategoryNames.WORKING : selectedCategories.iterator().next().toString(), layerManager.uniqueLayerName(this.NEW_LAYER), newFeatures);
            layerManager.getLayer(0).setFeatureCollectionModified(true);
            layerManager.getLayer(0).setEditable(true);
        }
        return true;
    }

    private boolean blended(CoordinateList blendedCoords, CoordinateList lsCoords) {
        Coordinate start = blendedCoords.getCoordinate(0);
        Coordinate end = blendedCoords.getCoordinate(blendedCoords.size() - 1);
        Coordinate first = lsCoords.getCoordinate(0);
        Coordinate last = lsCoords.getCoordinate(lsCoords.size() - 1);
        if (start.distance(first) < this.blendTolerance) {
            for (int i = 1; i < lsCoords.size(); ++i) {
                blendedCoords.add(0, (Object)lsCoords.getCoordinate(i));
            }
        } else if (start.distance(last) < this.blendTolerance) {
            for (int i = lsCoords.size() - 2; i >= 0; --i) {
                blendedCoords.add(0, (Object)lsCoords.getCoordinate(i));
            }
        } else if (end.distance(first) < this.blendTolerance) {
            for (int i = 1; i < lsCoords.size(); ++i) {
                blendedCoords.add((Object)lsCoords.getCoordinate(i));
            }
        } else if (end.distance(last) < this.blendTolerance) {
            for (int i = lsCoords.size() - 2; i >= 0; --i) {
                blendedCoords.add((Object)lsCoords.getCoordinate(i));
            }
        } else {
            return false;
        }
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addDoubleField(this.TOLERANCE, this.blendTolerance, 6, this.THE_BLEND_TOLERANCE_TOOLTIP);
        this.removeCheckBox = dialog.addCheckBox(this.REMOVE_SOURCE_LINES, this.removeSourceLines, this.REMOVE_SOURCE_LINES_TOOLTIP);
        this.removeCheckBox.setEnabled(!this.createNewLayer);
        dialog.addCheckBox(this.TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS, this.transferFirstAttributesToAllResultingLineStrings, this.TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS_TOOLTIP);
        this.newLayerCheckBox = dialog.addCheckBox(this.CREATE_NEW_LAYER, this.createNewLayer, this.CREATE_NEW_LAYER_TOOLTIP);
        this.newLayerCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BlendLineStringsPlugIn.this.removeCheckBox.setEnabled(!((JCheckBox)e.getSource()).isSelected());
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.blendTolerance = dialog.getDouble(this.TOLERANCE);
        this.removeSourceLines = dialog.getBoolean(this.REMOVE_SOURCE_LINES);
        this.transferFirstAttributesToAllResultingLineStrings = dialog.getBoolean(this.TRANSFER_FIRST_ATTRIBUTES_TO_ALL_RESULTING_LINE_STRINGS);
        this.createNewLayer = dialog.getBoolean(this.CREATE_NEW_LAYER);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createOnlyOneLayerMayHaveSelectedFeaturesCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(2));
    }
}

