/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openjump.core.ui.plugin.style.ImportSLDPlugIn;
import org.w3c.dom.Document;

public class ImportArcMapStylePlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        EnableCheckFactory enableCheckFactory = new EnableCheckFactory(context.getWorkbenchContext());
        MultiEnableCheck enableCheck = new MultiEnableCheck().add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(enableCheckFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.LAYER}, I18N.get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.name"), false, null, enableCheck);
    }

    private static File findArcMap2SLD(WorkbenchFrame wbframe, Blackboard bb) throws IOException, InterruptedException {
        File am2sld;
        String arcmap2sld = (String)bb.get("ArcMapStylePlugin.toollocation");
        if (arcmap2sld == null) {
            String s;
            File tmp = File.createTempFile("amtsldreg", null);
            ProcessBuilder pb = new ProcessBuilder("regedit", "/e", tmp.toString(), "HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion");
            pb.start().waitFor();
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmp), "UTF-16"));
            while ((s = in.readLine()) != null) {
                if (!s.startsWith("\"ProgramFilesDir\"=\"")) continue;
                s = s.split("=")[1];
                s = s.substring(1, s.length() - 1);
                arcmap2sld = s + "\\i3mainz\\ArcMap2SLD_Full_Setup\\ArcGIS_SLD_Converter.exe";
                break;
            }
            in.close();
            tmp.delete();
        }
        JFileChooser chooser = new JFileChooser();
        File file = am2sld = arcmap2sld == null ? null : new File(arcmap2sld);
        if (am2sld == null || !am2sld.exists()) {
            int res;
            JOptionPane.showMessageDialog(wbframe, I18N.get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.Must-Select-Location-Of-Tool"), I18N.get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Question"), 1);
            if (arcmap2sld != null) {
                chooser.setSelectedFile(new File(arcmap2sld));
            }
            if ((res = chooser.showOpenDialog(wbframe)) == 0) {
                am2sld = chooser.getSelectedFile();
                if (!am2sld.exists()) {
                    return null;
                }
                bb.put("ArcMapStylePlugin.toollocation", am2sld.getAbsoluteFile().toString());
            } else {
                return null;
            }
        }
        return am2sld;
    }

    public boolean execute(PlugInContext context) throws Exception {
        int res;
        Blackboard bb = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        WorkbenchFrame wbframe = context.getWorkbenchFrame();
        String fileName = (String)bb.get("ArcMapStylePlugin.filename");
        File am2sld = ImportArcMapStylePlugIn.findArcMap2SLD(wbframe, bb);
        if (am2sld == null) {
            return false;
        }
        ProcessBuilder pb = new ProcessBuilder(am2sld.toString());
        pb.start().waitFor();
        JOptionPane.showMessageDialog(wbframe, I18N.get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.Must-Select-Location-Of-SLD"), I18N.get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Question"), 1);
        JFileChooser chooser = new JFileChooser();
        if (fileName != null) {
            chooser.setCurrentDirectory(new File(fileName).getParentFile());
        }
        if ((res = chooser.showOpenDialog(context.getWorkbenchFrame())) == 0) {
            File f = chooser.getSelectedFile();
            if (!f.exists()) {
                return false;
            }
            bb.put("ArcMapStylePlugin.filename", f.getAbsoluteFile().toString());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(f);
            ImportSLDPlugIn.importSLD(doc, context);
        }
        return false;
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.name");
    }
}

