/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu.category;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelListener;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.apache.log4j.Logger;
import org.openjump.core.apitools.PlugInContextTools;

public class SetCategoryVisibilityPlugIn
extends AbstractPlugIn
implements LayerNamePanelListener {
    protected Map cathegory2Visibility = new HashMap();
    protected Map layer2Visibility = new HashMap();
    protected PlugInContext context = null;
    protected JCheckBoxMenuItem menuItem = null;
    protected static SetCategoryVisibilityPlugIn instance = null;
    private static final Logger LOG = Logger.getLogger(SetCategoryVisibilityPlugIn.class);

    public SetCategoryVisibilityPlugIn() {
        instance = this;
    }

    public static SetCategoryVisibilityPlugIn getInstance(PlugInContext context) {
        if (instance == null) {
            instance = new SetCategoryVisibilityPlugIn();
            SetCategoryVisibilityPlugIn.instance.context = context;
        }
        return instance;
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.mousemenu.category.SetCategoryVisibilityPlugIn.Set-Category-Visibility");
    }

    public void initialize(PlugInContext context) throws Exception {
        this.context = context;
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
        FeatureInstaller featInst = context.getFeatureInstaller();
        featInst.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, this.getName() + "...", true, GUIUtil.toSmallIcon((ImageIcon)this.getIcon()), (EnableCheck)SetCategoryVisibilityPlugIn.createEnableCheck(context.getWorkbenchContext()));
        MenuElement[] elements = layerNamePopupMenu.getSubElements();
        for (int i = 0; i < elements.length; ++i) {
            if (!JCheckBoxMenuItem.class.isInstance(elements[i]) || !((JCheckBoxMenuItem)elements[i]).getText().startsWith(this.getName())) continue;
            ((JCheckBoxMenuItem)elements[i]).setSelected(true);
            this.menuItem = (JCheckBoxMenuItem)elements[i];
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createAtLeastNLayersMustExistCheck(1));
        multiEnableCheck.add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
        multiEnableCheck.add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1));
        return multiEnableCheck;
    }

    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("eye.png"));
    }

    public boolean execute(PlugInContext context) throws Exception {
        try {
            context.getLayerNamePanel().addListener(this);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        Collection selCats = context.getLayerNamePanel().getSelectedCategories();
        for (Category cat : selCats) {
            if (!this.cathegory2Visibility.containsKey(cat)) {
                this.cathegory2Visibility.put(cat, new Boolean(true));
            }
            Boolean visible = (Boolean)this.cathegory2Visibility.get(cat);
            this.cathegory2Visibility.remove(cat);
            this.cathegory2Visibility.put(cat, new Boolean(visible == false));
            this.setLayerVisibility(cat.getLayerables(), visible == false);
        }
        return true;
    }

    protected void setLayerVisibility(List layers, boolean visible) {
        for (Layerable layer : layers) {
            if (!visible && !this.layer2Visibility.containsKey(layer)) {
                this.layer2Visibility.put(layer, new Boolean(layer.isVisible()));
            }
            if (layer.isVisible() == visible) continue;
            if (!visible) {
                layer.setVisible(visible);
                continue;
            }
            if (this.layer2Visibility.containsKey(layer)) {
                layer.setVisible((Boolean)this.layer2Visibility.get(layer));
                this.layer2Visibility.remove(layer);
                continue;
            }
            layer.setVisible(visible);
        }
    }

    protected void checkAndFixInvisibility() {
        if (this.context == null) {
            LOG.warn((Object)"SetCategoryVisibilityPlugIn: context == null!");
            return;
        }
        PlugInContext context = PlugInContextTools.getContext(this.context);
        List cathegories = context.getLayerManager().getCategories();
        for (Category cat : cathegories) {
            if (!this.cathegory2Visibility.containsKey(cat) || ((Boolean)this.cathegory2Visibility.get(cat)).booleanValue()) continue;
            this.setLayerVisibility(cat.getLayerables(), false);
        }
    }

    public boolean IsCategoryVisible(Category cat) {
        if (this.cathegory2Visibility.containsKey(cat)) {
            return (Boolean)this.cathegory2Visibility.get(cat);
        }
        return true;
    }

    public void setCategoryVisibility(Category cat, boolean visible) {
        this.cathegory2Visibility.put(cat, new Boolean(visible));
        this.checkAndFixInvisibility();
    }

    public void layerSelectionChanged() {
        Category cat2;
        PlugInContext context = PlugInContextTools.getContext(this.context);
        List cathegories = context.getLayerManager().getCategories();
        for (Category cat2 : cathegories) {
            if (this.cathegory2Visibility.containsKey(cat2)) continue;
            this.cathegory2Visibility.put(cat2, new Boolean(true));
        }
        this.checkAndFixInvisibility();
        Collection selCats = context.getLayerNamePanel().getSelectedCategories();
        if (selCats.isEmpty()) {
            return;
        }
        cat2 = (Category)selCats.toArray()[0];
        this.menuItem.setSelected((Boolean)this.cathegory2Visibility.get(cat2));
    }
}

