/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu.category;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.openjump.core.ui.plugin.mousemenu.category.CategoryMover;

public class MoveCategoryOneDown
extends AbstractPlugIn {
    public boolean execute(PlugInContext context) throws Exception {
        CategoryMover cm = new CategoryMover(context);
        Collection cats = context.getLayerNamePanel().getSelectedCategories();
        if (cats.size() > 1 || cats.size() <= 0) {
            String s = I18N.get("org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryOneDown.Only-a-single-category-can-be-moved!");
            context.getWorkbenchFrame().warnUser(s);
            return false;
        }
        Object[] catsArray = cats.toArray();
        cm.moveCategoryOneDown((Category)catsArray[0]);
        return true;
    }

    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("bullet_arrow_down.png"));
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryOneDown.Move-Category-One-Down");
    }

    public void initialize(PlugInContext context) throws Exception {
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
        FeatureInstaller featInst = context.getFeatureInstaller();
        featInst.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, this.getName() + "...", false, GUIUtil.toSmallIcon((ImageIcon)this.getIcon()), (EnableCheck)MoveCategoryOneDown.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
        multiEnableCheck.add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1));
        return multiEnableCheck;
    }
}

