/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.openjump.core.ui.plugin.mousemenu.EditSelectedSideDialog;

public class EditSelectedSidePlugIn
extends AbstractPlugIn {
    private static final String sEditSelectedSide = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSidePlugIn.Edit-Selected-Side");
    private static final String sPointsDoNotHaveSides = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSidePlugIn.Points-do-not-have-sides");
    private static final String sSelectOnlyOnePart = I18N.get("org.openjump.core.ui.plugin.mousemenu.EditSelectedSidePlugIn.Select-only-one-part");

    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        featureInstaller.addPopupMenuItem(popupMenu, (PlugIn)this, sEditSelectedSide, false, null, (EnableCheck)this.createEnableCheck(workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        EditSelectedSideDialog dialog = new EditSelectedSideDialog(context, sEditSelectedSide, false);
        dialog.setVisible(true);
        return true;
    }

    public EnableCheck noPointsMayBeSelectedCheck(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            public String check(JComponent component) {
                Collection selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                Geometry selectedGeo = (Geometry)selectedItems.iterator().next();
                return selectedGeo instanceof Point ? sPointsDoNotHaveSides : null;
            }
        };
    }

    public EnableCheck noMultiShapesMayBeSelectedCheck(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            public String check(JComponent component) {
                Collection selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                Geometry selectedGeo = (Geometry)selectedItems.iterator().next();
                return selectedGeo instanceof MultiPoint || selectedGeo instanceof MultiLineString || selectedGeo instanceof MultiPolygon || selectedGeo instanceof GeometryCollection ? sSelectOnlyOnePart : null;
            }
        };
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNItemsMustBeSelectedCheck(1)).add(this.noPointsMayBeSelectedCheck(workbenchContext)).add(this.noMultiShapesMayBeSelectedCheck(workbenchContext)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }
}

