/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.tab;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.List;
import org.openjump.core.geomutils.GeoUtils;

public class ConstraintManager {
    public static final String CONSTRAIN_LENGTH_ENABLED_KEY = "CONSTRAIN_LENGTH - ENABLED";
    public static final String CONSTRAIN_INCREMENTAL_ANGLE_ENABLED_KEY = "CONSTRAIN_INCREMENTAL_ANGLE - ENABLED";
    public static final String CONSTRAIN_ANGLE_ENABLED_KEY = "CONSTRAIN_ANGLE - ENABLED";
    public static final String LENGTH_CONSTRAINT_KEY = "LENGTH_CONSTRAINT";
    public static final String INCREMENTAL_ANGLE_SIZE_KEY = "INCREMENTAL_ANGLE_CONSTRAINT";
    public static final String ANGLE_SIZE_KEY = "ANGLE_CONSTRAINT";
    public static final String RELATIVE_ANGLE_KEY = "RELATIVE_ANGLE_CONSTRAINT";
    public static final String ABSOLUTE_ANGLE_KEY = "ABSOLUTE_ANGLE_CONSTRAINT";
    public static final String CONSTRAIN_RECTANGLE_RATIO_ENABLED_KEY = "CONSTRAIN_RECTANGLE_RATIO - ENABLED";
    public static final String RATIO_WIDTH_KEY = "RATIO_WIDTH_CONSTRAINT";
    public static final String RATIO_HEIGHT_KEY = "RATIO_HEIGHT_CONSTRAINT";
    protected LayerViewPanel panel;
    WorkbenchContext workbenchContext;

    public ConstraintManager(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }

    public Coordinate constrain(LayerViewPanel panel, List coordinates, Coordinate targetPt, MouseEvent e) {
        Coordinate endPt;
        Coordinate startPt;
        double lengthConstraint;
        if (coordinates == null) {
            return targetPt;
        }
        this.panel = panel;
        int numPts = coordinates.size();
        boolean shiftConstrain = e.isShiftDown() && numPts > 1;
        boolean ctrlConstrain = e.isControlDown() && numPts > 1;
        Coordinate retPt = (Coordinate)targetPt.clone();
        if (PersistentBlackboardPlugIn.get(this.workbenchContext).get(CONSTRAIN_LENGTH_ENABLED_KEY, false) && numPts >= 1 && (lengthConstraint = PersistentBlackboardPlugIn.get(this.workbenchContext).getDouble(LENGTH_CONSTRAINT_KEY)) > 0.0) {
            Coordinate anchorPt = (Coordinate)coordinates.get(numPts - 1);
            double run = targetPt.x - anchorPt.x;
            double rise = targetPt.y - anchorPt.y;
            double prevLength = anchorPt.distance(targetPt);
            double t1 = Math.round(prevLength / lengthConstraint);
            double newLength = t1 * lengthConstraint;
            double ratio = 1.0;
            if (prevLength != 0.0) {
                ratio = newLength / prevLength;
            }
            retPt.x = anchorPt.x + ratio * run;
            retPt.y = anchorPt.y + ratio * rise;
        }
        if (PersistentBlackboardPlugIn.get(this.workbenchContext).get(CONSTRAIN_INCREMENTAL_ANGLE_ENABLED_KEY, false) && shiftConstrain) {
            int incrementalAngleConstraint = PersistentBlackboardPlugIn.get(this.workbenchContext).getInt(INCREMENTAL_ANGLE_SIZE_KEY);
            startPt = (Coordinate)coordinates.get(numPts - 2);
            endPt = (Coordinate)coordinates.get(numPts - 1);
            retPt = this.constrainIncrementalAngle(startPt, endPt, retPt, incrementalAngleConstraint);
        }
        if (PersistentBlackboardPlugIn.get(this.workbenchContext).get(CONSTRAIN_ANGLE_ENABLED_KEY, false)) {
            Coordinate startPt2;
            double theta = -PersistentBlackboardPlugIn.get(this.workbenchContext).getDouble(ANGLE_SIZE_KEY);
            if (PersistentBlackboardPlugIn.get(this.workbenchContext).getBoolean(RELATIVE_ANGLE_KEY)) {
                if (shiftConstrain) {
                    startPt2 = (Coordinate)coordinates.get(numPts - 2);
                    Coordinate endPt2 = (Coordinate)coordinates.get(numPts - 1);
                    double length = endPt2.distance(retPt);
                    Coordinate newPt = this.constructVector(startPt2, endPt2, length);
                    retPt = GeoUtils.rotPt(newPt, endPt2, theta);
                }
            } else if (e.isShiftDown() && numPts >= 1) {
                startPt2 = (Coordinate)coordinates.get(numPts - 1);
                Coordinate endPt3 = (Coordinate)startPt2.clone();
                endPt3.x += startPt2.distance(retPt);
                retPt = GeoUtils.rotPt(endPt3, startPt2, theta);
            }
        }
        if (PersistentBlackboardPlugIn.get(this.workbenchContext).get(CONSTRAIN_INCREMENTAL_ANGLE_ENABLED_KEY, false) && ctrlConstrain) {
            int incrementalAngleConstraint = PersistentBlackboardPlugIn.get(this.workbenchContext).getInt(INCREMENTAL_ANGLE_SIZE_KEY);
            startPt = (Coordinate)coordinates.get(1);
            endPt = (Coordinate)coordinates.get(0);
            Coordinate p1 = (Coordinate)coordinates.get(numPts - 1);
            Coordinate p2 = (Coordinate)retPt.clone();
            Coordinate p3 = (Coordinate)coordinates.get(0);
            Coordinate p4 = this.constrainIncrementalAngle(startPt, endPt, retPt, incrementalAngleConstraint);
            Coordinate intxPt = GeoUtils.getIntersection(p1, p2, p3, p4);
            if (intxPt.z == 0.0) {
                retPt = new Coordinate(intxPt.x, intxPt.y);
            }
        }
        return retPt;
    }

    protected Coordinate constrainIncrementalAngle(Coordinate startPt, Coordinate endPt, Coordinate targetPt, int angleConstraint) {
        double targetLength = endPt.distance(targetPt);
        Coordinate newPt = this.constructVector(startPt, endPt, targetLength);
        Coordinate retPt = (Coordinate)newPt.clone();
        double currDist = targetPt.distance(newPt);
        double theta = 360 / angleConstraint;
        for (int i = 0; i < angleConstraint - 1; ++i) {
            double newDist = targetPt.distance(newPt = GeoUtils.rotPt(newPt, endPt, theta));
            if (!(newDist < currDist)) continue;
            currDist = newDist;
            retPt = (Coordinate)newPt.clone();
        }
        return retPt;
    }

    public Coordinate constrainRectangleToRatio(LayerViewPanel panel, List coordinates, Coordinate targetPt, MouseEvent e) throws NoninvertibleTransformException {
        if (coordinates == null) {
            return targetPt;
        }
        this.panel = panel;
        boolean shiftConstrain = PersistentBlackboardPlugIn.get(this.workbenchContext).get(CONSTRAIN_RECTANGLE_RATIO_ENABLED_KEY, false) && e.isShiftDown();
        double ratioWidth = PersistentBlackboardPlugIn.get(this.workbenchContext).get(RATIO_WIDTH_KEY, 1.0);
        double ratioHeight = PersistentBlackboardPlugIn.get(this.workbenchContext).get(RATIO_HEIGHT_KEY, 1.0);
        double ratio = ratioWidth / ratioHeight;
        if (coordinates.size() >= 1 && shiftConstrain) {
            Coordinate firstCoordinate = (Coordinate)coordinates.get(0);
            double yLength = Math.abs(firstCoordinate.x - targetPt.x) / ratio;
            if (targetPt.y > firstCoordinate.y) {
                return new Coordinate(targetPt.x, firstCoordinate.y + yLength);
            }
            return new Coordinate(targetPt.x, firstCoordinate.y - yLength);
        }
        return targetPt;
    }

    private Coordinate constructVector(Coordinate startPt, Coordinate endPt, double dist) {
        double run = endPt.x - startPt.x;
        double rise = endPt.y - startPt.y;
        double sideLength = startPt.distance(endPt);
        double ratio = dist / sideLength;
        return new Coordinate(endPt.x + ratio * run, endPt.y + ratio * rise);
    }

    public double getBearing(Coordinate startPt, Coordinate endPt) {
        Coordinate r = new Coordinate(endPt.x - startPt.x, endPt.y - startPt.y);
        double rMag = Math.sqrt(r.x * r.x + r.y * r.y);
        if (rMag == 0.0) {
            return 0.0;
        }
        double rCos = r.x / rMag;
        double rAng = Math.acos(rCos);
        if (r.y < 0.0) {
            rAng = -rAng;
        }
        return rAng * 360.0 / (Math.PI * 2);
    }
}

