/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectTool;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SelectOneItemTool
extends SelectTool {
    static final String sSelectOneItem = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.SelectOneItemTool.Select-One-Item");
    private LayerViewPanel layerViewPanel;
    private int maxFID = Integer.MAX_VALUE;
    private int highFID = 0;
    Layer botLayer = null;
    Feature botFeature = null;
    boolean featureSelected = false;

    public SelectOneItemTool() {
        super("SELECTED_FEATURES");
    }

    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("SelectOne.gif"));
    }

    public String getName() {
        return sSelectOneItem;
    }

    private void reset() {
        this.maxFID = Integer.MAX_VALUE;
        this.highFID = 0;
        this.botLayer = null;
        this.botFeature = null;
        this.featureSelected = false;
    }

    public void activate(LayerViewPanel layerViewPanel) {
        this.layerViewPanel = layerViewPanel;
        super.activate(layerViewPanel);
        this.selection = layerViewPanel.getSelectionManager().getFeatureSelection();
        this.reset();
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        super.gestureFinished();
        List layerList = this.layerViewPanel.getLayerManager().getVisibleLayers(false);
        Layer topLayer = null;
        Feature topFeature = null;
        this.featureSelected = false;
        for (Layer layer : layerList) {
            Collection selectedFeatures = this.layerViewPanel.getSelectionManager().getFeaturesWithSelectedItems(layer);
            Iterator j = selectedFeatures.iterator();
            while (j.hasNext()) {
                this.featureSelected = true;
                Feature feature = (Feature)j.next();
                int fID = feature.getID();
                this.layerViewPanel.getSelectionManager().getFeatureSelection().unselectItems(layer, feature);
                if (fID <= this.highFID || fID >= this.maxFID) continue;
                topLayer = layer;
                topFeature = feature;
                this.highFID = fID;
            }
        }
        if (!this.featureSelected) {
            this.reset();
        }
        if (topLayer != null && topFeature != null) {
            if (this.highFID > 0) {
                this.maxFID = this.highFID;
            }
            this.highFID = 0;
            this.botLayer = topLayer;
            this.botFeature = topFeature;
            this.layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(topLayer, topFeature);
        } else if (this.botLayer != null && this.botFeature != null) {
            this.layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(this.botLayer, this.botFeature);
        }
    }
}

