/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelectAllModifiedFeaturesPlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix(this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, I18N.get("org.openjump.core.ui.plugin.edit.SelectAllModifiedFeaturesPlugIn.select-all-modified-features"), false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        layerViewPanel.getSelectionManager().clear();
        List layers = context.getWorkbenchContext().getLayerNamePanel().getLayerManager().getLayers();
        for (Layer layer : layers) {
            selectedFeatures.clear();
            if (layer.isVisible()) {
                FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
                Iterator i = featureCollection.iterator();
                while (i.hasNext()) {
                    Feature feature = (Feature)i.next();
                    if (!(feature instanceof BasicFeature) || !((BasicFeature)feature).isModified()) continue;
                    selectedFeatures.add(feature);
                }
            }
            if (selectedFeatures.size() <= 0) continue;
            layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, selectedFeatures);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

