/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.customize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Map;

public class CmdRunner {
    private static String[] envp = null;
    private static String OS = null;

    public void run(String[] runStr, boolean runAndWait) {
        try {
            Process p = Runtime.getRuntime().exec(runStr, envp);
            if (runAndWait) {
                p.waitFor();
                p.destroy();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void addEnviroment(String enviromentVariable, String value) {
        int i;
        if (envp == null) {
            Map<String, String> env = System.getenv();
            i = 0;
            envp = new String[env.size()];
            for (Map.Entry<String, String> entry : env.entrySet()) {
                CmdRunner.envp[i++] = entry.getKey() + "=" + entry.getValue();
            }
        }
        String[] newEnvp = new String[envp.length + 1];
        for (i = 0; i < envp.length; ++i) {
            newEnvp[i] = envp[i];
        }
        newEnvp[newEnvp.length - 1] = enviromentVariable + "=" + value;
        envp = newEnvp;
    }

    public void runLater(String commandLine, char delimiter) {
        String regex = "" + delimiter;
        String[] runStr = commandLine.split(regex, 0);
        this.run(runStr, false);
    }

    public void run(String commandLine, char delimiter) {
        String regex = "" + delimiter;
        String[] runStr = commandLine.split(regex, 0);
        this.run(runStr, true);
    }

    public String[] runAndGetOutput(String command, char delimiter) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            File file = File.createTempFile("Cmd", null);
            String filePath = file.getCanonicalPath();
            String regex = "" + delimiter;
            String commandLine = CmdRunner.isWindows() ? "cmd" + delimiter + "/c" + delimiter : "sh" + delimiter;
            commandLine = commandLine + command + delimiter + ">" + delimiter + filePath;
            commandLine = commandLine + delimiter + "2>&1";
            String[] runStr = commandLine.split(regex, 0);
            this.run(runStr, true);
            file = new File(filePath);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                return new String[0];
            }
            int fileSize = (int)file.length();
            if (fileSize == 0) {
                return new String[0];
            }
            FileReader fin = new FileReader(filePath);
            BufferedReader in = new BufferedReader(fin, fileSize);
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
            file.delete();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String[] returnString = lines.toArray(new String[lines.size()]);
        return returnString;
    }

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static boolean isWindows() {
        return CmdRunner.getOsName().startsWith("Windows");
    }
}

