/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plot;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.math.plot.plots.HistogramPlot2D;
import org.math.plot.render.AbstractDrawer;

public class HistogramPlot2DOJ
extends HistogramPlot2D {
    double[][] XY;
    double width = 0.0;
    String attrName = "";
    PlugInContext context = null;
    Layer layer = null;
    AttributeType type = null;
    private ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();

    public HistogramPlot2DOJ(String n, Color c, double[][] _XY, double w, PlugInContext context, Layer layer, String attrName) {
        super(n, c, _XY, w, 0.5, 1.0);
        this.width = w;
        this.XY = _XY;
        this.context = context;
        this.layer = layer;
        this.attrName = attrName;
        FeatureSchema fs = layer.getFeatureCollectionWrapper().getFeatureSchema();
        this.type = fs.getAttributeType(attrName);
    }

    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        for (int i = 0; i < this.XY.length; ++i) {
            int[] screenCoord = draw.project(this.XY[i]);
            if (screenCoord[0] + this.note_precision <= screenCoordTest[0] || screenCoord[0] - this.note_precision >= screenCoordTest[0] || screenCoord[1] + this.note_precision <= screenCoordTest[1] || screenCoord[1] - this.note_precision >= screenCoordTest[1]) continue;
            double mean = this.XY[i][0];
            double lBound = mean - 0.5 * this.width;
            double hBound = mean + 0.5 * this.width;
            List features = this.layer.getFeatureCollectionWrapper().getFeatures();
            ArrayList<Feature> coveredFeatures = new ArrayList<Feature>();
            for (Feature f : features) {
                double dval = 0.0;
                Object val = f.getAttribute(this.attrName);
                if (this.type == AttributeType.DOUBLE) {
                    dval = (Double)val;
                } else if (this.type == AttributeType.INTEGER) {
                    dval = ((Integer)val).intValue();
                }
                if (!(dval < hBound) || !(dval > lBound)) continue;
                coveredFeatures.add(f);
            }
            try {
                this.zoomToSelectedItemsPlugIn.flash(FeatureUtil.toGeometries(coveredFeatures), this.context.getLayerViewPanel());
            }
            catch (Throwable t) {
                this.context.getWorkbenchContext().getErrorHandler().handleThrowable(t);
            }
            return this.XY[i];
        }
        return null;
    }
}

