/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import javax.swing.JOptionPane;

public class GridFloat {
    private String fltFullFileName = null;
    private String hdrFullFileName = null;
    private int nCols = 0;
    private int nRows = 0;
    private double xllCorner = 0.0;
    private double yllCorner = 0.0;
    private double cellSize = 0.0;
    private double noData = -9999.0;
    private String byteOrder = "LSBFIRST";
    private boolean origCorner = true;
    private float[] dataArray = null;
    private Raster raster = null;
    private long cellCount = 0L;
    private double minVal = Double.MAX_VALUE;
    private double maxVal = -1.7976931348623157E308;
    private double meanVal = 0.0;
    private double stDevVal = 0.0;
    private boolean isInteger = true;
    public static final String LSBFIRST = "LSBFIRST";
    public static final String MSBFIRST = "MSBFIRST";

    public GridFloat(String fltFullFileName) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
        this.readHdr();
    }

    public GridFloat(String fltFullFileName, GridFloat gridFloat2) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
        this.nCols = gridFloat2.getnCols();
        this.nRows = gridFloat2.getnRows();
        this.xllCorner = gridFloat2.getXllCorner();
        this.yllCorner = gridFloat2.getYllCorner();
        this.cellSize = gridFloat2.getCellSize();
        this.noData = gridFloat2.getNoData();
        this.byteOrder = gridFloat2.getByteOrder();
    }

    public GridFloat(String fltFullFileName, int nCols, int nRows, boolean origCorner, double xllOrig, double yllOrig, double cellSize, double noData, String byteOrder) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
        this.nCols = nCols;
        this.nRows = nRows;
        this.origCorner = origCorner;
        if (origCorner) {
            this.xllCorner = xllOrig;
            this.yllCorner = yllOrig;
        } else {
            this.xllCorner = xllOrig - 0.5 * cellSize;
            this.yllCorner = yllOrig - 0.5 * cellSize;
        }
        this.cellSize = cellSize;
        this.noData = noData;
        this.byteOrder = byteOrder.toLowerCase().equals("lsbfirst") && byteOrder.toLowerCase().equals("lsblast") ? LSBFIRST : byteOrder;
    }

    private int readHdr() {
        try {
            String line = null;
            BufferedReader buffRead = new BufferedReader(new FileReader(this.hdrFullFileName));
            while ((line = buffRead.readLine()) != null) {
                String[] lines = line.split(" +");
                if (lines[0].toLowerCase().equals("ncols")) {
                    this.nCols = Integer.parseInt(lines[1].toString());
                    continue;
                }
                if (lines[0].toLowerCase().equals("nrows")) {
                    this.nRows = Integer.parseInt(lines[1].toString());
                    continue;
                }
                if (lines[0].toLowerCase().equals("xllcorner")) {
                    this.xllCorner = Double.parseDouble(lines[1].toString());
                    this.origCorner = true;
                    continue;
                }
                if (lines[0].toLowerCase().equals("yllcorner")) {
                    this.yllCorner = Double.parseDouble(lines[1].toString());
                    continue;
                }
                if (lines[0].toLowerCase().equals("xllcenter")) {
                    this.xllCorner = Double.parseDouble(lines[1].toString());
                    this.origCorner = false;
                    continue;
                }
                if (lines[0].toLowerCase().equals("yllcenter")) {
                    this.yllCorner = Double.parseDouble(lines[1].toString());
                    continue;
                }
                if (lines[0].toLowerCase().equals("cellsize")) {
                    this.cellSize = Double.parseDouble(lines[1].toString());
                    continue;
                }
                if (lines[0].toLowerCase().equals("nodata_value")) {
                    this.noData = Double.parseDouble(lines[1].toString());
                    continue;
                }
                if (!lines[0].toLowerCase().equals("byteorder")) continue;
                this.byteOrder = lines[1].toString();
            }
            buffRead.close();
            buffRead = null;
            if (!this.origCorner) {
                this.xllCorner = -0.5 * this.cellSize;
                this.yllCorner = -0.5 * this.cellSize;
            }
            return 0;
        }
        catch (IOException Ex) {
            JOptionPane.showMessageDialog(null, "Error while reading hdr file: " + Ex, "Error", 0);
            return 1;
        }
    }

    public int writeHdr() {
        try {
            File fileHeader = new File(this.hdrFullFileName);
            BufferedWriter buffWrite = new BufferedWriter(new FileWriter(fileHeader));
            buffWrite.write("ncols " + this.nCols);
            buffWrite.newLine();
            buffWrite.write("nrows " + this.nRows);
            buffWrite.newLine();
            if (this.origCorner) {
                buffWrite.write("xllcorner " + this.xllCorner);
                buffWrite.newLine();
                buffWrite.write("yllcorner " + this.yllCorner);
                buffWrite.newLine();
            } else {
                buffWrite.write("xllcenter " + this.xllCorner + 0.5 * this.cellSize);
                buffWrite.newLine();
                buffWrite.write("yllcenter " + this.yllCorner + 0.5 * this.cellSize);
                buffWrite.newLine();
            }
            buffWrite.write("cellsize " + this.cellSize);
            buffWrite.newLine();
            buffWrite.write("NODATA_value " + this.noData);
            buffWrite.newLine();
            buffWrite.write("byteorder " + this.byteOrder);
            buffWrite.newLine();
            buffWrite.close();
            buffWrite = null;
            return 0;
        }
        catch (IOException IOExc) {
            JOptionPane.showMessageDialog(null, "Error while reading hdr file: " + IOExc, "Error", 0);
            return 1;
        }
    }

    public int readGrid() {
        int ret = this.readHdr();
        if (ret != 0) {
            return 1;
        }
        double valSum = 0.0;
        double valSumSquare = 0.0;
        this.minVal = Double.MAX_VALUE;
        this.maxVal = -this.minVal;
        try {
            File fileFlt = new File(this.fltFullFileName);
            FileInputStream fileInStream = new FileInputStream(fileFlt);
            FileChannel fileChannel = fileInStream.getChannel();
            long length = fileFlt.length();
            MappedByteBuffer mbb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, length);
            mbb.order(ByteOrder.LITTLE_ENDIAN);
            fileChannel.close();
            fileInStream.close();
            int i = 0;
            this.dataArray = new float[this.nCols * this.nRows];
            for (int c = 0; c < this.nCols * this.nRows; ++c) {
                this.dataArray[c] = mbb.getFloat(i);
                if ((double)this.dataArray[c] != this.noData) {
                    valSum += (double)this.dataArray[c];
                    valSumSquare += (double)(this.dataArray[c] * this.dataArray[c]);
                    ++this.cellCount;
                    if ((double)this.dataArray[c] < this.minVal) {
                        this.minVal = this.dataArray[c];
                    }
                    if ((double)this.dataArray[c] > this.maxVal) {
                        this.maxVal = this.dataArray[c];
                    }
                    if ((float)((int)this.dataArray[c]) != this.dataArray[c]) {
                        this.isInteger = false;
                    }
                }
                i += 4;
            }
            this.meanVal = valSum / (double)this.cellCount;
            this.stDevVal = Math.sqrt(valSumSquare / (double)this.cellCount - this.meanVal * this.meanVal);
            mbb = null;
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)this.nCols, (int)this.nRows, (int)1);
            DataBufferFloat db = new DataBufferFloat(this.dataArray, this.nCols * this.nRows);
            Point point = new Point();
            point.setLocation(this.xllCorner, this.yllCorner);
            this.raster = RasterFactory.createRaster((SampleModel)sampleModel, (DataBuffer)db, (Point)point);
            return 0;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error while reading the flt file: " + ex, "Error", 0);
            return 1;
        }
    }

    public int writeGrid() {
        try {
            if (this.raster == null) {
                SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)this.nCols, (int)this.nRows, (int)1);
                this.dataArray = new float[this.nCols * this.nRows];
                DataBufferFloat db = new DataBufferFloat(this.dataArray, this.nCols * this.nRows);
                Point point = new Point();
                point.setLocation(this.xllCorner, this.yllCorner);
                this.raster = RasterFactory.createRaster((SampleModel)sampleModel, (DataBuffer)db, (Point)point);
            }
            if (this.writeHdr() != 0) {
                return -1;
            }
            File fileOut = new File(this.fltFullFileName);
            FileOutputStream fileOutStream = new FileOutputStream(fileOut);
            FileChannel fileChannelOut = fileOutStream.getChannel();
            ByteBuffer bb = ByteBuffer.allocateDirect(this.nCols * 4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int r = 0; r < this.nRows; ++r) {
                for (int c = 0; c < this.nCols; ++c) {
                    if (bb.hasRemaining()) {
                        bb.putFloat(this.raster.getSampleFloat(c, r, 0));
                        continue;
                    }
                    --c;
                    bb.compact();
                    fileChannelOut.write(bb);
                    bb.clear();
                }
            }
            bb.compact();
            fileChannelOut.write(bb);
            bb.clear();
            return 0;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error while reading flt file: " + ex, "Error", 0);
            return 1;
        }
    }

    public void setFltFullFileName(String fltFullFileName) {
        this.fltFullFileName = fltFullFileName;
        this.hdrFullFileName = fltFullFileName.substring(0, fltFullFileName.lastIndexOf(".")) + ".hdr";
    }

    public boolean isSpatiallyEqualTo(GridFloat gridFloat2) {
        boolean isEqual = true;
        if (this.nCols != gridFloat2.getnCols()) {
            isEqual = false;
        }
        if (this.nRows != gridFloat2.getnRows()) {
            isEqual = false;
        }
        if (this.origCorner != gridFloat2.getOrigCorner()) {
            isEqual = false;
        }
        if (this.xllCorner != gridFloat2.getXllCorner()) {
            isEqual = false;
        }
        if (this.yllCorner != gridFloat2.getYllCorner()) {
            isEqual = false;
        }
        if (this.cellSize != gridFloat2.getCellSize()) {
            isEqual = false;
        }
        if (this.noData != gridFloat2.getNoData()) {
            isEqual = false;
        }
        if (!this.byteOrder.equals(gridFloat2.getByteOrder())) {
            isEqual = false;
        }
        return isEqual;
    }

    public PlanarImage getPlanarImage() {
        try {
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)this.nCols, (int)this.nRows, (int)1);
            TiledImage tiledImage = new TiledImage(0, 0, this.nCols, this.nRows, 0, 0, sampleModel, null);
            WritableRaster wraster = tiledImage.getWritableTile(0, 0);
            wraster.setPixels(0, 0, this.nCols, this.nRows, this.dataArray);
            tiledImage.setData((Raster)wraster);
            return tiledImage;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }

    public int getnCols() {
        return this.nCols;
    }

    public void setnCols(int nCols) {
        this.nCols = nCols;
    }

    public int getnRows() {
        return this.nRows;
    }

    public void setnRows(int nRows) {
        this.nRows = nRows;
    }

    public double getXllCorner() {
        return this.xllCorner;
    }

    public void setXllCorner(double xllCorner) {
        this.xllCorner = xllCorner;
    }

    public double getYllCorner() {
        return this.yllCorner;
    }

    public void setYllCorner(double yllCorner) {
        this.yllCorner = yllCorner;
    }

    public boolean getOrigCorner() {
        return this.origCorner;
    }

    public void setOrigCorner(boolean origCorner) {
        this.origCorner = origCorner;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(double cellSize) {
        this.cellSize = cellSize;
    }

    public double getNoData() {
        return this.noData;
    }

    public void setNoData(double noData) {
        this.noData = noData;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public void setRas(Raster raster) {
        this.raster = raster;
        this.cellCount = 0L;
        DataBuffer db = raster.getDataBuffer();
        for (int e = 0; e < db.getSize(); ++e) {
            if ((double)db.getElemFloat(e) == this.noData) continue;
            ++this.cellCount;
        }
    }

    public double getMinVal() {
        return this.minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public double getMeanVal() {
        return this.meanVal;
    }

    public double getStDevVal() {
        return this.stDevVal;
    }

    public long getCellCount() {
        return this.cellCount;
    }

    public boolean isInteger() {
        return this.isInteger;
    }
}

