/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.polygongraph;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import org.openjump.core.geomutils.algorithm.GeometryConverter;
import org.openjump.core.graph.polygongraph.PolygonGraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonGraphNode {
    public Geometry geometry = null;
    public Feature realWorldObject = null;
    private static int nodeIds = 0;
    public int nodeId = -1;
    public ArrayList<PolygonGraphEdge> edges = new ArrayList();
    public static final String edgeTypeAtributeName = "edgeType";

    public PolygonGraphNode(Feature f) {
        this.realWorldObject = f;
        this.geometry = f.getGeometry();
        this.nodeId = ++nodeIds;
    }

    public ArrayList<Feature> retrieveSharedBoundaries() {
        ArrayList<Feature> boundaries = new ArrayList<Feature>();
        for (PolygonGraphEdge tedge : this.edges) {
            ArrayList<Geometry> lines = tedge.getBoundaries();
            int bdcount = 0;
            for (Geometry geom : lines) {
                BasicFeature fnew = new BasicFeature(PolygonGraphNode.getBoundaryFeatureSchema());
                fnew.setGeometry(geom);
                fnew.setAttribute("edgeId", (Object)tedge.edgeId);
                fnew.setAttribute("boundaryId", (Object)(++bdcount));
                fnew.setAttribute("startNode", (Object)tedge.node1.nodeId);
                fnew.setAttribute("endNode", (Object)tedge.node2.nodeId);
                boundaries.add(fnew);
            }
        }
        return boundaries;
    }

    public ArrayList<Feature> getNonSharedBoundariesAsFeature() {
        ArrayList<Feature> nonShared = new ArrayList<Feature>();
        ArrayList<Geometry> boundaries = new ArrayList<Geometry>();
        for (PolygonGraphEdge tedge : this.edges) {
            ArrayList<Geometry> lines = tedge.getBoundaries();
            boundaries.addAll(lines);
        }
        Geometry diff = null;
        if (boundaries.size() > 0) {
            Geometry union = (Geometry)boundaries.get(0);
            for (int i = 1; i < boundaries.size(); ++i) {
                union = union.union((Geometry)boundaries.get(i));
            }
            diff = this.geometry.getBoundary().difference(union);
        } else {
            diff = this.geometry.getBoundary();
        }
        ArrayList<Geometry> explodedGeoms = GeometryConverter.explodeGeomsIfMultiG(diff);
        int count = 0;
        GeometryFactory gf = new GeometryFactory();
        for (Geometry geom : explodedGeoms) {
            ++count;
            BasicFeature fnew = new BasicFeature(PolygonGraphNode.getBoundaryFeatureSchema());
            if (geom instanceof LinearRing) {
                geom = gf.createLineString(((LinearRing)geom).getCoordinateSequence());
            }
            fnew.setGeometry(geom);
            fnew.setAttribute("startNode", (Object)this.nodeId);
            fnew.setAttribute("endNode", (Object)this.nodeId);
            fnew.setAttribute("boundaryId", (Object)count);
            fnew.setAttribute("edgeId", (Object)-1);
            nonShared.add(fnew);
        }
        return nonShared;
    }

    public boolean hasConnection(PolygonGraphNode node) {
        boolean found = false;
        for (PolygonGraphEdge tedge : this.edges) {
            if (!tedge.hasNodes(this.nodeId, node.nodeId)) continue;
            found = true;
            return true;
        }
        return found;
    }

    public static FeatureSchema getBoundaryFeatureSchema() {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("Geometry", AttributeType.GEOMETRY);
        fs.addAttribute("edgeId", AttributeType.INTEGER);
        fs.addAttribute("boundaryId", AttributeType.INTEGER);
        fs.addAttribute("startNode", AttributeType.INTEGER);
        fs.addAttribute("endNode", AttributeType.INTEGER);
        fs.addAttribute(edgeTypeAtributeName, AttributeType.STRING);
        return fs;
    }
}

