/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import java.util.ArrayList;
import java.util.List;
import org.openjump.core.apitools.ToolToMakeYourLifeEasier;

public class FeatureSchemaTools
extends ToolToMakeYourLifeEasier {
    public static AttributeInfo[] getAttributesWithTypes(FeatureSchema fs, AttributeType[] allowedTypes) {
        ArrayList<AttributeInfo> attrInfosList = new ArrayList<AttributeInfo>();
        AttributeInfo[] attrInfoArray = AttributeInfo.schema2AttributeInfoArray(fs);
        int numInfos = attrInfoArray.length;
        for (int i = 0; i < numInfos; ++i) {
            if (!FeatureSchemaTools.isAttributeTypeAllowed(attrInfoArray[i].getAttributeType(), allowedTypes)) continue;
            attrInfosList.add(attrInfoArray[i]);
        }
        numInfos = attrInfosList.size();
        AttributeInfo[] attrInfoRaw = attrInfosList.toArray(new AttributeInfo[0]);
        return attrInfoRaw;
    }

    public static AttributeInfo getAttributesInfoFor(FeatureSchema fs, int attrIndex) {
        AttributeInfo attrInfo = new AttributeInfo(fs.getAttributeName(attrIndex), fs.getAttributeType(attrIndex));
        attrInfo.setIndex(attrIndex);
        return attrInfo;
    }

    public static AttributeInfo getAttributesInfoFor(FeatureSchema fs, String attrName) {
        return FeatureSchemaTools.getAttributesInfoFor(fs, fs.getAttributeIndex(attrName));
    }

    public static boolean isAttributeTypeAllowed(AttributeType at, AttributeType[] allowedTypes) {
        int numTypes = allowedTypes.length;
        for (int i = 0; i < numTypes; ++i) {
            if (!allowedTypes[i].equals(at)) continue;
            return true;
        }
        return false;
    }

    public static FeatureSchema copyFeatureSchema(FeatureSchema oldSchema) {
        FeatureSchema fs = new FeatureSchema();
        for (int i = 0; i < oldSchema.getAttributeCount(); ++i) {
            AttributeType at = oldSchema.getAttributeType(i);
            String aname = oldSchema.getAttributeName(i);
            fs.addAttribute(aname, at);
            fs.setAttributeReadOnly(i, oldSchema.isAttributeReadOnly(i));
            fs.setCoordinateSystem(oldSchema.getCoordinateSystem());
        }
        return fs;
    }

    public static Feature copyFeature(Feature feature, FeatureSchema newSchema) {
        FeatureSchema oldSchema = feature.getSchema();
        BasicFeature newF = new BasicFeature(newSchema);
        int n = 0;
        n = oldSchema.getAttributeCount() > newSchema.getAttributeCount() ? newSchema.getAttributeCount() : oldSchema.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String aname = oldSchema.getAttributeName(i);
            Object value = feature.getAttribute(aname);
            newF.setAttribute(aname, value);
        }
        return newF;
    }

    public static List getFieldsFromLayerWithoutGeometryAndString(Layer lyr) {
        ArrayList<String> fields = new ArrayList<String>();
        FeatureSchema schema = lyr.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) == AttributeType.GEOMETRY || schema.getAttributeType(i) == AttributeType.STRING) continue;
            fields.add(schema.getAttributeName(i));
        }
        return fields;
    }

    public static List getFieldsFromLayerWithoutGeometry(Layer lyr) {
        ArrayList<String> fields = new ArrayList<String>();
        FeatureSchema schema = lyr.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            fields.add(schema.getAttributeName(i));
        }
        return fields;
    }
}

