/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.jumpcore;

import com.vividsolutions.jump.workbench.plugin.PlugIn;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class ExtCorePlugIn
implements PlugIn {
    private final Logger logger = Logger.getLogger(this.getClass());
    protected String i18nPath = "language/plugin";
    protected ResourceBundle rb = null;

    private void initResourceBundle() {
        this.rb = ResourceBundle.getBundle(this.i18nPath, Locale.getDefault(), this.getClass().getClassLoader());
    }

    public String _e(String string) {
        return this.getMessageByMessage(string);
    }

    public String getMessageByMessage(String string) {
        Pattern pattern = Pattern.compile("(\\b)[\\d]+(\\b)");
        Matcher matcher = pattern.matcher(string);
        Vector<String> numbers = new Vector<String>();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (matcher.find()) {
            numbers.add(matcher.group());
            matcher.appendReplacement(result, "{" + i++ + "}");
        }
        matcher.appendTail(result);
        String key = result.toString().toLowerCase().replaceAll("[\\s:=-]+", "-");
        String message = "";
        try {
            if (this.rb == null) {
                this.initResourceBundle();
            }
            MessageFormat mformat = new MessageFormat(this.rb.getString(key));
            message = mformat.format(numbers.toArray());
        }
        catch (NullPointerException e) {
            this.logger.error((Object)"missing resource bundle", (Throwable)e);
            System.out.println(e.getLocalizedMessage());
        }
        catch (MissingResourceException e) {
            this.logger.error((Object)"translation missing", (Throwable)e);
            System.out.println(e.getLocalizedMessage());
        }
        return message.length() == 0 ? string : message;
    }

    public String _(String label) {
        return this.getMessage(label);
    }

    public String _(String label, Object[] objects) {
        return this.getMessage(label, objects);
    }

    public String _(String label, Object object) {
        return this.getMessage(label, new Object[]{object});
    }

    public String _(String label, Object object1, Object object2) {
        return this.getMessage(label, new Object[]{object1, object2});
    }

    public String getMessage(String label) {
        return this.getMessage(label, new Object[0]);
    }

    public String getMessage(String label, Object[] objects) {
        String message = null;
        try {
            if (this.rb == null) {
                this.initResourceBundle();
            }
            MessageFormat mformat = new MessageFormat(this.rb.getString(label));
            message = mformat.format(objects);
        }
        catch (NullPointerException e) {
            this.logger.error((Object)"missing resource bundle", (Throwable)e);
            System.out.println(e.getLocalizedMessage());
        }
        catch (MissingResourceException e) {
            this.logger.error((Object)"translation missing", (Throwable)e);
            System.out.println(e.getLocalizedMessage());
        }
        if (message == null) {
            String[] labelpath = label.split("\\..+");
            MessageFormat mformat = new MessageFormat(labelpath[labelpath.length - 1]);
            message = mformat.format(objects);
        }
        return message;
    }
}

