/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import com.vividsolutions.jump.workbench.ui.style.DecorationStylePanel;
import com.vividsolutions.jump.workbench.ui.style.LabelStylePanel;
import com.vividsolutions.jump.workbench.ui.style.ScaleStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.latlon.deejump.plugin.style.DeeRenderingStylePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeeChangeStylesPlugIn
extends AbstractPlugIn {
    private static final String LAST_TAB_KEY = DeeChangeStylesPlugIn.class.getName() + " - LAST TAB";

    @Override
    public String getName() {
        return I18N.get("ui.style.ChangeStylesPlugIn.change-styles");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        WorkbenchFrame wbframe = context.getWorkbenchFrame();
        WorkbenchContext wbcontext = context.getWorkbenchContext();
        Blackboard blackboard = wbcontext.getWorkbench().getBlackboard();
        Blackboard pb = PersistentBlackboardPlugIn.get(wbcontext);
        final Layer layer = context.getSelectedLayer(0);
        MultiInputDialog dialog = new MultiInputDialog(wbframe, I18N.get("ui.style.ChangeStylesPlugIn.change-styles"), true);
        dialog.setInset(0);
        dialog.setSideBarImage(IconLoader.icon("Symbology.gif"));
        dialog.setSideBarDescription(I18N.get("ui.style.ChangeStylesPlugIn.you-can-use-this-dialog-to-change-the-colour-line-width"));
        final ArrayList<StylePanel> stylePanels = new ArrayList<StylePanel>();
        DeeRenderingStylePanel renderingStylePanel = new DeeRenderingStylePanel(blackboard, layer, pb);
        stylePanels.add(renderingStylePanel);
        stylePanels.add(new ScaleStylePanel(layer, context.getLayerViewPanel()));
        DecorationStylePanel decorationStylePanel = new DecorationStylePanel(layer, wbframe.getChoosableStyleClasses());
        decorationStylePanel.setPreferredSize(new Dimension(400, 300));
        if (layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount() > 1) {
            ColorThemingStylePanel colorThemingStylePanel = new ColorThemingStylePanel(layer, wbcontext);
            colorThemingStylePanel.setPreferredSize(new Dimension(400, 300));
            stylePanels.add(colorThemingStylePanel);
            GUIUtil.sync(renderingStylePanel.getTransparencySlider(), colorThemingStylePanel.getTransparencySlider());
            GUIUtil.sync(renderingStylePanel.getSynchronizeCheckBox(), colorThemingStylePanel.getSynchronizeCheckBox());
        } else {
            stylePanels.add(new DummyColorThemingStylePanel());
        }
        stylePanels.add(new LabelStylePanel(layer, context.getLayerViewPanel(), dialog, context.getErrorHandler()));
        stylePanels.add(decorationStylePanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        for (final StylePanel stylePanel : stylePanels) {
            tabbedPane.add((Component)((Object)stylePanel), stylePanel.getTitle());
            dialog.addEnableChecks(stylePanel.getTitle(), Arrays.asList(new EnableCheck(){

                public String check(JComponent component) {
                    return stylePanel.validateInput();
                }
            }));
        }
        dialog.addRow(tabbedPane);
        String selectedTab = (String)blackboard.get(LAST_TAB_KEY, ((StylePanel)stylePanels.iterator().next()).getTitle());
        tabbedPane.setSelectedComponent(this.find(stylePanels, selectedTab));
        dialog.pack();
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        blackboard.put(LAST_TAB_KEY, ((StylePanel)((Object)tabbedPane.getSelectedComponent())).getTitle());
        if (dialog.wasOKPressed()) {
            final Collection oldStyles = layer.cloneStyles();
            layer.getLayerManager().deferFiringEvents(new Runnable(){

                public void run() {
                    for (StylePanel stylePanel : stylePanels) {
                        stylePanel.updateStyles();
                    }
                }
            });
            layer.getLayerManager().deferFiringEvents(new Runnable(){

                public void run() {
                    if (layer.getVertexStyle().isEnabled()) {
                        layer.getBasicStyle().setRenderingVertices(false);
                    }
                }
            });
            final Collection newStyles = layer.cloneStyles();
            this.execute(new UndoableCommand(this.getName()){

                public void execute() {
                    layer.setStyles(newStyles);
                }

                public void unexecute() {
                    layer.setStyles(oldStyles);
                }
            }, context);
            return true;
        }
        this.reportNothingToUndoYet(context);
        return false;
    }

    private Component find(Collection<StylePanel> stylePanels, String title) {
        for (StylePanel stylePanel : stylePanels) {
            if (!stylePanel.getTitle().equals(title)) continue;
            return (Component)((Object)stylePanel);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Palette.gif");
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    private class DummyColorThemingStylePanel
    extends JPanel
    implements StylePanel {
        private static final long serialVersionUID = 2217457292163045134L;

        public DummyColorThemingStylePanel() {
            super(new GridBagLayout());
            this.add(new JLabel(I18N.get("ui.style.ChangeStylesPlugIn.this-layer-has-no-attributes")));
        }

        public String getTitle() {
            return ColorThemingStylePanel.TITLE;
        }

        public void updateStyles() {
        }

        public String validateInput() {
            return null;
        }
    }
}

