/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ViewportListener;
import java.util.ArrayList;
import java.util.Iterator;

public class VisiblePointsAndLinesCache {
    private static final String PANEL_PROPERTY_KEY = "VISIBLE_POINTS_AND_LINES_CACHE";
    private LayerListener layerListener = new LayerListener(){

        public void layerChanged(LayerEvent e) {
            VisiblePointsAndLinesCache.this.invalidate();
        }

        public void featuresChanged(FeatureEvent e) {
        }

        public void categoryChanged(CategoryEvent e) {
        }
    };
    private ViewportListener viewportListener = new ViewportListener(){

        public void zoomChanged(Envelope modelEnvelope) {
            VisiblePointsAndLinesCache.this.invalidate();
        }
    };
    private LayerViewPanel panel;
    private GeometryFactory factory = new GeometryFactory();
    private STRtree tree = null;

    private VisiblePointsAndLinesCache(LayerViewPanel panel) {
        this.panel = panel;
        panel.getViewport().addListener(this.viewportListener);
        panel.getLayerManager().addLayerListener(this.layerListener);
    }

    private void invalidate() {
        this.tree = null;
    }

    public STRtree getTree() {
        if (this.tree == null) {
            Envelope viewportEnvelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
            this.tree = new STRtree();
            Iterator i = this.panel.getLayerManager().iterator();
            while (i.hasNext()) {
                Layer layer = (Layer)i.next();
                if (!layer.isVisible()) continue;
                for (Feature feature : layer.getFeatureCollectionWrapper().query(viewportEnvelope)) {
                    Geometry geometry = feature.getGeometry();
                    this.tree.insert(geometry.getEnvelopeInternal(), (Object)this.toPointsAndLines(geometry));
                }
            }
        }
        return this.tree;
    }

    private Geometry toPointsAndLines(Geometry g) {
        if (g.getDimension() <= 1) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection oldCollection = (GeometryCollection)g;
            ArrayList<Geometry> newCollection = new ArrayList<Geometry>();
            for (int i = 0; i < oldCollection.getNumGeometries(); ++i) {
                newCollection.add(this.toPointsAndLines(oldCollection.getGeometryN(i)));
            }
            return this.factory.createGeometryCollection(newCollection.toArray(new Geometry[0]));
        }
        Assert.isTrue((boolean)(g instanceof Polygon));
        return ((Polygon)g).getBoundary();
    }

    public static VisiblePointsAndLinesCache instance(LayerViewPanel panel) {
        if (panel.getBlackboard().get(PANEL_PROPERTY_KEY) == null) {
            return (VisiblePointsAndLinesCache)panel.getBlackboard().get(PANEL_PROPERTY_KEY, new VisiblePointsAndLinesCache(panel));
        }
        return (VisiblePointsAndLinesCache)panel.getBlackboard().get(PANEL_PROPERTY_KEY);
    }
}

