/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.GeometryCollectionShape;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.PolygonShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Java2DConverter {
    private static double POINT_MARKER_SIZE = 3.0;
    private PointConverter pointConverter;
    private double decimatorResolution = 0.5;

    public Java2DConverter(PointConverter pointConverter) {
        this.pointConverter = pointConverter;
    }

    public Java2DConverter(PointConverter pointConverter, double resolution) {
        this.pointConverter = pointConverter;
        this.decimatorResolution = resolution;
    }

    private Shape toShape(Polygon p) throws NoninvertibleTransformException {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            holeVertexCollection.add(this.toViewCoordinates(p.getInteriorRingN(j).getCoordinates()));
        }
        return new PolygonShape(this.toViewCoordinates(p.getExteriorRing().getCoordinates()), holeVertexCollection);
    }

    public Coordinate[] toViewCoordinates(Coordinate[] modelCoordinates) throws NoninvertibleTransformException {
        Coordinate[] viewCoordinates = new Coordinate[modelCoordinates.length];
        double ps = this.decimatorResolution / this.pointConverter.getScale();
        Coordinate p0 = modelCoordinates[0];
        int npts = 0;
        int mpts = modelCoordinates.length;
        for (int i = 0; i < mpts; ++i) {
            Coordinate pi = modelCoordinates[i];
            double xd = Math.abs(p0.x - pi.x);
            double yd = Math.abs(p0.y - pi.y);
            if (!(xd >= ps) && !(yd >= ps) && npts >= 4 && i != mpts - 1) continue;
            Point2D point2D = this.pointConverter.toViewPoint(pi);
            viewCoordinates[npts++] = new Coordinate(point2D.getX(), point2D.getY());
            p0 = pi;
        }
        if (npts != mpts) {
            Coordinate[] viewCoordinates2 = new Coordinate[npts];
            for (int i = 0; i < npts; ++i) {
                viewCoordinates2[i] = viewCoordinates[i];
            }
            return viewCoordinates2;
        }
        return viewCoordinates;
    }

    private Shape toShape(GeometryCollection gc) throws NoninvertibleTransformException {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private GeneralPath toShape(MultiLineString mls) throws NoninvertibleTransformException {
        GeneralPath path = new GeneralPath();
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            path.append(this.toShape(lineString), false);
        }
        return path;
    }

    private GeneralPath toShape(LineString lineString) throws NoninvertibleTransformException {
        GeometryFactory gf = lineString.getFactory();
        Coordinate[] cc = lineString.getCoordinates();
        GeneralPath shape = new GeneralPath(1, cc.length);
        CoordinateList list = new CoordinateList();
        Envelope view = this.pointConverter.getEnvelopeInModelCoordinates();
        Coordinate c0 = cc[0];
        boolean start = true;
        int max = cc.length;
        for (int i = 1; i < max; ++i) {
            LineStringPath pi;
            Coordinate c1 = cc[i];
            if (view.intersects(new Envelope(c0, c1))) {
                if (start) {
                    list.add((Object)c0);
                }
                list.add((Object)c1);
                start = false;
            } else if (!list.isEmpty()) {
                pi = new LineStringPath(gf.createLineString(list.toCoordinateArray()), this);
                shape.append(pi, false);
                list.clear();
                start = true;
            }
            if (i == max - 1 && !list.isEmpty()) {
                pi = new LineStringPath(gf.createLineString(list.toCoordinateArray()), this);
                shape.append(pi, false);
            }
            c0 = c1;
        }
        return shape;
    }

    private Shape toShape(Point point) throws NoninvertibleTransformException {
        Rectangle2D.Double pointMarker = new Rectangle2D.Double(0.0, 0.0, POINT_MARKER_SIZE, POINT_MARKER_SIZE);
        Point2D viewPoint = this.toViewPoint(point.getCoordinate());
        pointMarker.x = viewPoint.getX() - POINT_MARKER_SIZE / 2.0;
        pointMarker.y = viewPoint.getY() - POINT_MARKER_SIZE / 2.0;
        return pointMarker;
    }

    private Point2D toViewPoint(Coordinate modelCoordinate) throws NoninvertibleTransformException {
        Point2D viewPoint = this.pointConverter.toViewPoint(modelCoordinate);
        return viewPoint;
    }

    public Shape toShape(Geometry geometry) throws NoninvertibleTransformException {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((GeometryCollection)((MultiPolygon)geometry));
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    public static interface PointConverter {
        public Point2D toViewPoint(Coordinate var1) throws NoninvertibleTransformException;

        public double getScale() throws NoninvertibleTransformException;

        public Envelope getEnvelopeInModelCoordinates();
    }

    class LineStringPath
    implements PathIterator {
        private int iterate;
        private int numPoints;
        private Coordinate[] points;
        private boolean closed;

        public LineStringPath(LineString linestring, Java2DConverter j2D) {
            try {
                this.points = j2D.toViewCoordinates(linestring.getCoordinates());
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
            this.numPoints = this.points.length;
            this.iterate = 0;
            this.closed = this.numPoints > 1 && this.points[0].equals2D(this.points[this.numPoints - 1]);
        }

        private int getSegType() {
            if (this.closed && this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.points[this.iterate].x;
            coords[1] = this.points[this.iterate].y;
            return this.getSegType();
        }

        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[this.iterate].x;
            coords[1] = (float)this.points[this.iterate].y;
            return this.getSegType();
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        public void next() {
            ++this.iterate;
        }
    }
}

