/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerWizardPanel;
import com.vividsolutions.jump.workbench.ui.wizard.CancelNextException;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import com.vividsolutions.wms.MapImageFormatChooser;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.openjump.swing.listener.InvokeMethodItemListener;
import org.openjump.swing.listener.InvokeMethodKeyTypedListener;

public class URLWizardPanel
extends JPanel
implements WizardPanel {
    public static final String SERVICE_KEY = "SERVICE";
    public static final String FORMAT_KEY = "FORMAT";
    public static final String URL_KEY = "URL";
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Map dataMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel urlLabel = new JLabel();
    private JComboBox urls;
    private JPanel fillerPanel = new JPanel();
    public static final String VERSION_KEY = "WMS_VERSION";
    private String wmsVersion = "1.1.1";
    private boolean lossyPreferred = true;

    public URLWizardPanel(String[] initialURLs, String wmsVersion) {
        try {
            this.wmsVersion = wmsVersion;
            this.urls = new JComboBox<String>(initialURLs);
            this.urls.setEditable(true);
            this.urls.getEditor().selectAll();
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    void jbInit() throws Exception {
        this.urlLabel.setText("URL:");
        this.setLayout(this.gridBagLayout1);
        this.urls.setPreferredSize(new Dimension(300, 21));
        this.urlLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 3) {
                    URLWizardPanel.this.urls.setSelectedItem("http://libcwms.gov.bc.ca/wmsconnector/com.esri.wsit.WMSServlet/ogc_layer_service");
                }
                super.mouseClicked(e);
            }
        });
        this.urls.getEditor().getEditorComponent().addKeyListener(new InvokeMethodKeyTypedListener((Object)this.inputChangedFirer, "fire", true));
        this.urls.addItemListener(new InvokeMethodItemListener((Object)this.inputChangedFirer, "fire", true));
        this.add((Component)this.urlLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.add((Component)this.urls, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 4), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(2, 10, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.createVersionButtons(new String[]{"1.0.0", "1.1.0", "1.1.1"}), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getInstructions() {
        return I18N.get("ui.plugin.wms.URLWizardPanel.please-enter-the-url-of-the-wms-server");
    }

    public static String fixUrlForWMService(String url) {
        String fixedURL = url.trim();
        if (fixedURL.indexOf("?") == -1) {
            fixedURL = fixedURL + "?";
        } else if (!fixedURL.endsWith("?") && !fixedURL.endsWith("&")) {
            fixedURL = fixedURL + "&";
        }
        return fixedURL;
    }

    public void exitingToRight() throws IOException, WorkbenchException {
        try {
            LinkedList<String> list = new LinkedList<String>();
            String url = this.urls.getSelectedIndex() == -1 ? this.urls.getEditor().getItem().toString() : this.urls.getItemAt(this.urls.getSelectedIndex()).toString();
            list.add(url);
            for (int i = 0; i < this.urls.getItemCount(); ++i) {
                if (i == this.urls.getSelectedIndex()) continue;
                list.add(this.urls.getItemAt(i).toString());
            }
            this.dataMap.put(URL_KEY, list.toArray(new String[list.size()]));
            url = URLWizardPanel.fixUrlForWMService(url);
            WMService service = new WMService(url, this.wmsVersion);
            service.initialize(true);
            this.dataMap.put(SERVICE_KEY, service);
            MapImageFormatChooser formatChooser = new MapImageFormatChooser(this.wmsVersion);
            formatChooser.setPreferLossyCompression(false);
            formatChooser.setTransparencyRequired(true);
            String format = formatChooser.chooseFormat(service.getCapabilities().getMapFormats());
            if (format == null) {
                throw new WorkbenchException(I18N.get("ui.plugin.wms.URLWizardPanel.the-server-does-not-support-gif-png-or-jpeg-format"));
            }
            this.dataMap.put("FORMAT_LIST", service.getCapabilities().getMapFormats());
            this.dataMap.put(FORMAT_KEY, format);
            this.dataMap.put("INITIAL_LAYER_NAMES", null);
            this.dataMap.put(VERSION_KEY, this.wmsVersion);
        }
        catch (IOException e) {
            throw new CancelNextException();
        }
    }

    public void enteredFromLeft(Map dataMap) {
        this.dataMap = dataMap;
        this.urls.getEditor().selectAll();
    }

    public String getTitle() {
        return I18N.get("ui.plugin.wms.URLWizardPanel.select-uniform-resource-locator-url");
    }

    public String getID() {
        return this.getClass().getName();
    }

    public boolean isInputValid() {
        try {
            String urlString = this.urls.getEditor().getItem().toString();
            String host = new URL(urlString).getHost();
            return host.length() > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public String getNextID() {
        return MapLayerWizardPanel.class.getName();
    }

    private Component createVersionButtons(String[] versions) {
        JPanel p = new JPanel();
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRadioButton jb = (JRadioButton)e.getSource();
                URLWizardPanel.this.wmsVersion = jb.getText();
            }
        };
        ButtonGroup group = new ButtonGroup();
        JRadioButton[] buttons = new JRadioButton[versions.length];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = new JRadioButton(versions[i]);
            buttons[i].addActionListener(al);
            group.add(buttons[i]);
            p.add(buttons[i]);
            if (!versions[i].equals(this.wmsVersion)) continue;
            buttons[i].setSelected(true);
        }
        return p;
    }

    private Component createLossyCheckBox() {
        JPanel p = new JPanel();
        JCheckBox checkBox = new JCheckBox("Preferr Lossy images", true);
        checkBox.setToolTipText("This will try to load JPEG images, if the WMS allows it.");
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URLWizardPanel.this.lossyPreferred = ((JCheckBox)e.getSource()).isSelected();
            }
        });
        p.add(checkBox);
        return p;
    }
}

