/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.AbstractAddDatastoreLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel;

public class RunDatastoreQueryPlugIn
extends AbstractAddDatastoreLayerPlugIn {
    protected ConnectionPanel createPanel(PlugInContext context) {
        return new RunDatastoreQueryPanel(context.getWorkbenchContext());
    }

    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuItem(new String[]{MenuNames.FILE}, this, 3);
    }

    protected Layerable createLayerable(ConnectionPanel panel, TaskMonitor monitor, PlugInContext context) throws Exception {
        return this.createLayer((RunDatastoreQueryPanel)panel, monitor, context);
    }

    public String getName() {
        return I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPlugIn.Run-Datastore-Query");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer createLayer(RunDatastoreQueryPanel panel, TaskMonitor monitor, PlugInContext context) throws Exception {
        panel.saveQuery();
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPlugIn.Creating-layer"));
        String driver = panel.getConnectionDescriptor().getDataStoreDriverClassName();
        String query = panel.getQuery();
        if (driver.contains("Postgis") && query.matches("(?s).*\\$\\{[^\\{\\}]*\\}.*")) {
            query = this.expandQuery(query, context);
        }
        FeatureInputStream featureInputStream = ConnectionManager.instance(context.getWorkbenchContext()).getOpenConnection(panel.getConnectionDescriptor()).execute(new AdhocQuery(query));
        try {
            FeatureDataset featureDataset = new FeatureDataset(featureInputStream.getFeatureSchema());
            int i = 0;
            while (featureInputStream.hasNext() && !monitor.isCancelRequested()) {
                featureDataset.add(featureInputStream.next());
                monitor.report(++i, -1, I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPlugIn.features"));
            }
            String name = panel.getLayerName();
            Layer layer = new Layer(name, context.getLayerManager().generateLayerFillColor(), featureDataset, context.getLayerManager());
            layer.setDataSourceQuery(new DataSourceQuery(new DataStoreQueryDataSource(name, panel.getQuery(), panel.getConnectionDescriptor(), context.getWorkbenchContext()), panel.getQuery(), name));
            Layer layer2 = layer;
            return layer2;
        }
        finally {
            featureInputStream.close();
        }
    }

    private String expandQuery(String query, PlugInContext context) {
        GeometryFactory gf = new GeometryFactory();
        Geometry viewG = gf.toGeometry(context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates());
        Geometry fenceG = context.getLayerViewPanel().getFence();
        if (viewG != null) {
            query = query.replaceAll("\\$\\{view\\}", "\\${view:-1}");
            query = query.replaceAll("\\$\\{view(?::(-?[0-9]+))\\}", "ST_GeomFromText('" + viewG.toText() + "',$1)");
        }
        if (fenceG != null) {
            query = query.replaceAll("\\$\\{fence\\}", "\\${fence:-1}");
            query = query.replaceAll("\\$\\{fence(?::(-?[0-9]+))\\}", "ST_GeomFromText('" + fenceG.toText() + "',$1)");
        }
        return query;
    }
}

