/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.RecordPanel;
import com.vividsolutions.jump.workbench.ui.RecordPanelModel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RunDatastoreQueryPanel
extends ConnectionPanel
implements ActionListener,
RecordPanelModel {
    private JTextField layerNameTextField;
    private Hashtable queryMap = new Hashtable();
    private ArrayList currentConnectionQueries = new ArrayList();
    private int currentIndex = -1;
    private RecordPanel recordPanel = new RecordPanel(this);
    private LayerManager layerManager;
    private JTextArea queryTextArea;

    public RunDatastoreQueryPanel(WorkbenchContext context) {
        super(context);
        this.layerManager = context.getLayerManager();
        this.initialize();
    }

    public int getRecordCount() {
        int num = 0;
        if (this.currentConnectionQueries != null) {
            num = this.currentConnectionQueries.size();
        }
        return num;
    }

    public void setCurrentIndex(int index) {
        this.currentIndex = index;
        String query = null;
        if (index > -1) {
            query = (String)this.currentConnectionQueries.get(index);
        }
        this.getQueryTextArea().setText(query);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    private void initialize() {
        JButton jbView = new JButton(I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.View"));
        jbView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunDatastoreQueryPanel.this.queryTextArea.insert("${view:-1}", RunDatastoreQueryPanel.this.queryTextArea.getCaretPosition());
            }
        });
        JButton jbFence = new JButton(I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Fence"));
        jbFence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunDatastoreQueryPanel.this.queryTextArea.insert("${fence:-1}", RunDatastoreQueryPanel.this.queryTextArea.getCaretPosition());
            }
        });
        JPanel jpButtons = new JPanel(new GridLayout(2, 1));
        jpButtons.add(jbView);
        jpButtons.add(jbFence);
        this.addRow(I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Layer-Name"), this.getLayerNameTextField(), null, false);
        this.addRow(I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Query"), new JScrollPane(this.getQueryTextArea()){
            {
                this.setPreferredSize(new Dimension(400, 100));
            }
        }, jpButtons, true);
        this.add((Component)this.recordPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0));
        this.getConnectionComboBox().addActionListener(this);
    }

    private JTextField getLayerNameTextField() {
        if (this.layerNameTextField == null) {
            this.layerNameTextField = new JTextField(this.layerManager.uniqueLayerName(I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.New-Query-Layer")));
        }
        return this.layerNameTextField;
    }

    private JTextArea getQueryTextArea() {
        if (this.queryTextArea == null) {
            this.queryTextArea = new JTextArea();
        }
        return this.queryTextArea;
    }

    public String validateInput() {
        String errMsg = super.validateInput();
        if (errMsg == null && this.getQuery().length() == 0) {
            errMsg = I18N.get("jump.workbench.ui.plugin.datastore.RunDatastoreQueryPanel.Required-field-missing-Query");
        }
        return errMsg;
    }

    public String getLayerName() {
        return this.layerManager.uniqueLayerName(this.layerNameTextField.getText().trim());
    }

    public void setLayerName(String layerName) {
        this.layerNameTextField.setText(layerName);
    }

    public String getQuery() {
        return this.queryTextArea.getText().trim();
    }

    public void setQuery(String query) {
        this.getQueryTextArea().setText(query);
    }

    public void saveQuery() {
        String query = this.getQuery();
        this.currentConnectionQueries.add(query);
        this.currentIndex = this.currentConnectionQueries.size() - 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ConnectionDescriptor cd = this.getConnectionDescriptor();
        if (cd != null) {
            if (this.queryMap.containsKey(cd)) {
                ArrayList prevQueries;
                this.currentConnectionQueries = prevQueries = (ArrayList)this.queryMap.get(cd);
            } else {
                this.currentConnectionQueries = new ArrayList();
                this.queryMap.put(cd, this.currentConnectionQueries);
            }
            this.setCurrentIndex(this.currentConnectionQueries.size() - 1);
            this.recordPanel.updateAppearance();
        }
    }

    protected Collection connectionDescriptors() {
        return CollectionUtil.select(super.connectionDescriptors(), new Block(){

            public Object yield(Object connectionDescriptor) {
                try {
                    return RunDatastoreQueryPanel.this.connectionManager().getDriver(((ConnectionDescriptor)connectionDescriptor).getDataStoreDriverClassName()).isAdHocQuerySupported();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

