/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreDataSource;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class InstallDatastoreLayerRendererHintsPlugIn
extends AbstractPlugIn {
    private Collection installedLayerManagers = new HashSet();
    private static final String INSTALLED_KEY = InstallDatastoreLayerRendererHintsPlugIn.class.getName() + " - INSTALLED";

    public void initialize(PlugInContext context) throws Exception {
        for (JInternalFrame internalFrame : Arrays.asList(context.getWorkbenchFrame().getDesktopPane().getAllFrames())) {
            this.installDatastoreLayerRendererHintsIfNecessary(internalFrame);
        }
        GUIUtil.addInternalFrameListener(context.getWorkbenchFrame().getDesktopPane(), new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                InstallDatastoreLayerRendererHintsPlugIn.this.installDatastoreLayerRendererHintsIfNecessary(e.getInternalFrame());
            }
        });
    }

    private void installDatastoreLayerRendererHintsIfNecessary(JInternalFrame internalFrame) {
        if (!(internalFrame instanceof LayerManagerProxy)) {
            return;
        }
        this.installDatastoreLayerRendererHintsIfNecessary(((LayerManagerProxy)((Object)internalFrame)).getLayerManager());
    }

    private void installDatastoreLayerRendererHintsIfNecessary(LayerManager layerManager) {
        if (this.installedLayerManagers.contains(layerManager)) {
            return;
        }
        layerManager.addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (!(e.getLayerable() instanceof Layer)) {
                    return;
                }
                if (((Layer)e.getLayerable()).getDataSourceQuery() == null) {
                    return;
                }
                if (!(((Layer)e.getLayerable()).getDataSourceQuery().getDataSource() instanceof DataStoreDataSource)) {
                    return;
                }
                if (((Layer)e.getLayerable()).getBlackboard().get(INSTALLED_KEY, false)) {
                    return;
                }
                ((Layer)e.getLayerable()).getBlackboard().put(LayerRenderer.ALWAYS_USE_IMAGE_CACHING_KEY, true);
                ((Layer)e.getLayerable()).getBlackboard().put(RenderingManager.USE_MULTI_RENDERING_THREAD_QUEUE_KEY, true);
                ((Layer)e.getLayerable()).getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
                ((Layer)e.getLayerable()).getBlackboard().put(INSTALLED_KEY, true);
                ((Layer)e.getLayerable()).fireAppearanceChanged();
            }

            public void categoryChanged(CategoryEvent e) {
            }
        });
        this.installedLayerManagers.add(layerManager);
    }
}

