/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionManagerPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ConnectionPanel
extends JPanel {
    protected static final int MAIN_COLUMN_WIDTH = 400;
    protected static final Insets INSETS = new Insets(2, 2, 2, 2);
    private WorkbenchContext context;
    private JComboBox connectionComboBox = null;
    private int nextRow = 0;
    private JButton chooseConnectionButton = null;

    public ConnectionPanel(WorkbenchContext context) {
        this.context = context;
        this.initialize();
        this.populateConnectionComboBox();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return (ConnectionDescriptor)this.connectionComboBox.getSelectedItem();
    }

    public WorkbenchContext getContext() {
        return this.context;
    }

    public void populateConnectionComboBox() {
        ConnectionDescriptor selectedConnectionDescriptor = this.getConnectionDescriptor();
        this.connectionComboBox.setModel(new DefaultComboBoxModel<Object>(this.sortByString(this.connectionDescriptors().toArray())));
        this.connectionComboBox.setSelectedItem(selectedConnectionDescriptor);
    }

    public String validateInput() {
        if (this.getConnectionDescriptor() == null) {
            return I18N.get("jump.workbench.ui.plugin.datastore.ConnectionPanel.Required-field-missing-Connection");
        }
        return null;
    }

    protected JComboBox getConnectionComboBox() {
        if (this.connectionComboBox == null) {
            this.connectionComboBox = new JComboBox();
            this.connectionComboBox.setPreferredSize(new Dimension(400, (int)this.connectionComboBox.getPreferredSize().getHeight()));
        }
        return this.connectionComboBox;
    }

    protected void addRow(String caption, Component a, Component b, boolean aStretchesVertically) {
        this.add((Component)new JLabel(caption), new GridBagConstraints(0, this.nextRow, 1, 1, 0.0, 0.0, 18, 0, INSETS, 0, 0));
        if (aStretchesVertically) {
            this.add(a, new GridBagConstraints(1, this.nextRow, 1, 1, 1.0, 1.0, 18, 1, INSETS, 0, 0));
        } else {
            this.add(a, new GridBagConstraints(1, this.nextRow, 1, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0));
        }
        if (b != null) {
            this.add(b, new GridBagConstraints(2, this.nextRow, 1, 1, 0.0, 0.0, 18, 0, INSETS, 0, 0));
        }
        ++this.nextRow;
    }

    protected Collection connectionDescriptors() {
        return this.connectionManager().getConnectionDescriptors();
    }

    protected ConnectionManager connectionManager() {
        return ConnectionManager.instance(this.context);
    }

    protected Object[] sortByString(Object[] objects) {
        Arrays.sort(objects, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return objects;
    }

    private JButton getChooseConnectionButton() {
        if (this.chooseConnectionButton == null) {
            this.chooseConnectionButton = new JButton();
            ImageIcon icon = new ImageIcon(ConnectionManagerPanel.class.getResource("databases.gif"));
            this.chooseConnectionButton.setIcon(icon);
            this.chooseConnectionButton.setToolTipText(I18N.get("jump.workbench.ui.plugin.datastore.ConnectionPanel.Connection-Manager"));
            this.chooseConnectionButton.setMargin(new Insets(0, 0, 0, 0));
            this.chooseConnectionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionPanel.this.chooseConnection();
                }
            });
        }
        return this.chooseConnectionButton;
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.addRow(I18N.get("jump.workbench.ui.plugin.datastore.ConnectionPanel.Connection"), this.getConnectionComboBox(), this.getChooseConnectionButton(), false);
    }

    private void chooseConnection() {
        ConnectionManagerPanel panel = new ConnectionManagerPanel(ConnectionManager.instance(this.getContext()), this.getContext().getRegistry(), this.getContext().getErrorHandler(), this.context);
        OKCancelDialog dialog = new OKCancelDialog((Dialog)SwingUtilities.windowForComponent(this), I18N.get("jump.workbench.ui.plugin.datastore.ConnectionPanel.Connection-Manager"), true, (Component)panel, new OKCancelDialog.Validator(){

            public String validateInput(Component component) {
                return null;
            }
        });
        dialog.setVisible(true);
        this.populateConnectionComboBox();
        if (!dialog.wasOKPressed()) {
            return;
        }
        if (panel.getSelectedConnectionDescriptors().isEmpty()) {
            return;
        }
        this.getConnectionComboBox().setSelectedItem(panel.getSelectedConnectionDescriptors().iterator().next());
    }
}

