/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.parameter.ParameterListSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ConnectionDescriptorPanel
extends JPanel {
    private WorkbenchContext context;
    private ParameterListSchema schema = new ParameterListSchema(new String[0], new Class[0]);
    private static int createdConnectionCount = 0;
    private JTextField nameText = new JTextField();
    private JComboBox driverComboBox = null;
    private List editComponentList = new ArrayList();
    private static final ParameterClassHandler PASSWORD_HANDLER = new ParameterClassHandler(){

        public Component createEditComponent(Blackboard bb) {
            return new JPasswordField(20);
        }

        public void setParameter(Component component, Object parameter) {
            ((JPasswordField)component).setText((String)parameter);
        }

        public Object getParameter(Component component) {
            return new String(((JPasswordField)component).getPassword());
        }
    };
    private Map parameterClassToHandlerMap = CollectionUtil.createMap(new Object[]{String.class, new ParameterClassHandler(){

        public Component createEditComponent(Blackboard bb) {
            return new JTextField(20);
        }

        public void setParameter(Component component, Object parameter) {
            ((JTextField)component).setText((String)parameter);
        }

        public Object getParameter(Component component) {
            return ((JTextField)component).getText();
        }
    }, File.class, new ParameterClassHandler(){

        public Component createEditComponent(Blackboard bb) {
            JMPFileChooser fileChooser = new JMPFileChooser(bb);
            if (bb.get(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.f = new File((String)bb.get(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY));
            }
            return fileChooser;
        }

        public void setParameter(Component component, Object parameter) {
            if (parameter != null) {
                File f;
                ((JMPFileChooser)component).f = f = (File)parameter;
                if (f != null && f.getParent() != null) {
                    String suffix;
                    int index;
                    ((JMPFileChooser)component).bb.put(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY, f.getParent());
                    if (f.isFile() && (index = f.getName().lastIndexOf(46) + 1) > -1 && (suffix = f.getName().substring(index)) != null && !"".equals(suffix.trim())) {
                        ((JMPFileChooser)component).chooser.setFileFilter(new FileFilter(){

                            public boolean accept(File f) {
                                return f != null && (f.isDirectory() || f.isFile() && f.getName().endsWith(suffix));
                            }

                            public String getDescription() {
                                return "";
                            }
                        });
                    }
                }
            }
            ((JTextField)component).setText(parameter == null ? "" : ((File)parameter).toString());
        }

        public Object getParameter(Component component) {
            File f = ((JMPFileChooser)component).f;
            if (f != null && f.getParent() != null) {
                ((JMPFileChooser)component).bb.put(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY, f.getParent());
            }
            return f;
        }
    }, Integer.class, new ParameterClassHandler(){

        public Component createEditComponent(Blackboard bb) {
            return new ValidatingTextField("", 5, ValidatingTextField.INTEGER_VALIDATOR);
        }

        public void setParameter(Component component, Object parameter) {
            ((JTextField)component).setText(((Integer)parameter).toString());
        }

        public Object getParameter(Component component) {
            return ((JTextField)component).getText().length() > 0 ? new Integer(((JTextField)component).getText()) : null;
        }
    }});
    private JPanel mainPanel = new JPanel(new GridBagLayout());

    private void updateMainPanel(ParameterList parameterList, Blackboard bb) {
        this.mainPanel.removeAll();
        this.editComponentList.clear();
        this.addEditComponent(0, I18N.get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Name"), this.nameText);
        this.addEditComponent(1, I18N.get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Driver"), this.driverComboBox);
        for (int i = 0; i < this.schema.getNames().length; ++i) {
            String name = this.schema.getNames()[i];
            this.editComponentList.add(this.createEditComponent(name, this.schema.getClasses()[i], parameterList.getParameter(name), bb));
            this.addEditComponent(i + 2, name, (Component)this.editComponentList.get(this.editComponentList.size() - 1));
        }
        this.revalidate();
        this.repaint();
    }

    private void addEditComponent(int i, String name, Component editComponent) {
        this.mainPanel.add((Component)new JLabel(name), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.mainPanel.add(editComponent, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private Component createEditComponent(String name, Class parameterClass, Object parameter, Blackboard bb) {
        Component editComponent = this.parameterClassHandler(name, parameterClass).createEditComponent(bb);
        if (parameter != null) {
            this.parameterClassHandler(name, parameterClass).setParameter(editComponent, parameter);
        }
        return editComponent;
    }

    private ParameterClassHandler parameterClassHandler(String name, Class parameterClass) {
        if (name.equalsIgnoreCase("Password")) {
            return PASSWORD_HANDLER;
        }
        return (ParameterClassHandler)this.parameterClassToHandlerMap.get(parameterClass);
    }

    public ConnectionDescriptorPanel(Registry registry, final WorkbenchContext context) {
        super(new GridBagLayout());
        this.context = context;
        this.nameText = new JTextField("", 20);
        this.driverComboBox = new JComboBox(){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ParameterList oldParameterList = ConnectionDescriptorPanel.this.createParameterList();
                        ConnectionDescriptorPanel.this.schema = ((DataStoreDriver)this.getSelectedItem()).getParameterListSchema();
                        ConnectionDescriptorPanel.this.updateMainPanel(ConnectionDescriptorPanel.this.copyWherePossible(oldParameterList, ConnectionDescriptorPanel.this.schema), PersistentBlackboardPlugIn.get(context));
                    }
                });
                this.setRenderer(new DefaultListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        return super.getListCellRendererComponent((JList<?>)list, ((DataStoreDriver)value).getName(), index, isSelected, cellHasFocus);
                    }
                });
            }
        };
        this.add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)new JPanel(new GridBagLayout()), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.driverComboBox.setModel(new DefaultComboBoxModel(this.sort(new Vector(registry.getEntries(DataStoreDriver.REGISTRY_CLASSIFICATION)), new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.compare((DataStoreDriver)o1, (DataStoreDriver)o2);
            }

            public int compare(DataStoreDriver a, DataStoreDriver b) {
                return a.getName().compareTo(b.getName());
            }
        })));
        this.initializePreferredSize();
        this.driverComboBox.setSelectedIndex(0);
    }

    private void initializePreferredSize() {
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < this.driverComboBox.getItemCount(); ++i) {
            this.driverComboBox.setSelectedIndex(i);
            maxWidth = Math.max(maxWidth, (int)this.getPreferredSize().getWidth());
            maxHeight = Math.max(maxHeight, (int)this.getPreferredSize().getHeight());
        }
        this.setPreferredSize(new Dimension(maxWidth, maxHeight));
    }

    private Vector sort(Vector collection, Comparator comparator) {
        Collections.sort(collection, comparator);
        return collection;
    }

    private String getValidConnectionName() {
        String fieldName = this.nameText.getText();
        if (fieldName == null || fieldName.trim().length() == 0) {
            return ((DataStoreDriver)this.driverComboBox.getSelectedItem()).getName() + " " + ++createdConnectionCount;
        }
        return fieldName.trim();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return new ConnectionDescriptor(this.getValidConnectionName(), this.driverComboBox.getSelectedItem().getClass(), this.createParameterList());
    }

    private ParameterList createParameterList() {
        ParameterList parameterList = new ParameterList(this.schema);
        for (int i = 0; i < this.editComponentList.size(); ++i) {
            parameterList.setParameter(this.schema.getNames()[i], this.parameterClassHandler(this.schema.getNames()[i], this.schema.getClasses()[i]).getParameter((Component)this.editComponentList.get(i)));
        }
        return parameterList;
    }

    public void setParameters(ConnectionDescriptor connDesc) {
        this.nameText.setText(connDesc.getName());
        int driverComboIndex = this.getDriverComboBoxIndex(connDesc.getDataStoreDriverClassName());
        if (driverComboIndex >= 0) {
            this.driverComboBox.setSelectedIndex(driverComboIndex);
            this.schema = ((DataStoreDriver)this.driverComboBox.getSelectedItem()).getParameterListSchema();
        }
        this.updateMainPanel(connDesc.getParameterList(), PersistentBlackboardPlugIn.get(this.context));
    }

    private int getDriverComboBoxIndex(String driverClassName) {
        for (int i = 0; i < this.driverComboBox.getItemCount(); ++i) {
            DataStoreDriver driver = (DataStoreDriver)this.driverComboBox.getItemAt(i);
            if (!driver.getClass().getName().equals(driverClassName)) continue;
            return i;
        }
        return -1;
    }

    public String validateInput() {
        for (int i = 0; i < this.editComponentList.size(); ++i) {
            Object parameter = this.parameterClassHandler(this.schema.getNames()[i], this.schema.getClasses()[i]).getParameter((Component)this.editComponentList.get(i));
            if (parameter != null && !parameter.equals("")) continue;
            return I18N.get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Required-field-missing") + " " + this.schema.getNames()[i];
        }
        return null;
    }

    private ParameterList copyWherePossible(ParameterList oldParameterList, ParameterListSchema newSchema) {
        ParameterList newParameterList = new ParameterList(newSchema);
        for (int i = 0; i < newSchema.getNames().length; ++i) {
            String name = newSchema.getNames()[i];
            newParameterList.setParameter(name, oldParameterList.getSchema().isValidName(name) && newSchema.getClasses()[i] == oldParameterList.getSchema().getClass(name) ? oldParameterList.getParameter(name) : null);
        }
        return newParameterList;
    }

    private static class JMPFileChooser
    extends JPanel {
        Blackboard bb;
        JFileChooser chooser;
        File f = null;

        public JMPFileChooser(Blackboard bb) {
            this.bb = bb;
            this.chooser = new JFileChooser();
            final JMPFileChooser th = this;
            final JTextField strFile = new JTextField(20);
            JButton open = new JButton();
            open.setText("...");
            open.setMargin(new Insets(0, 0, 0, 0));
            strFile.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    String t = strFile.getText();
                    if (t == null) {
                        th.f = null;
                        return;
                    }
                    if ((t = t.trim()) == null || "".equals(t)) {
                        th.f = null;
                        return;
                    }
                    th.f = new File(t);
                }
            });
            open.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selection;
                    if (JMPFileChooser.this.f != null) {
                        JMPFileChooser.this.chooser.setSelectedFile(JMPFileChooser.this.f);
                        th.setToolTipText(JMPFileChooser.this.f.toString());
                    }
                    if ((selection = JMPFileChooser.this.chooser.showOpenDialog(th)) == 0) {
                        th.f = JMPFileChooser.this.chooser.getSelectedFile();
                        if (th.f == null) {
                            strFile.setText("");
                        } else {
                            strFile.setText(th.f.toString());
                        }
                    }
                }
            });
            this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 0));
            GridBagLayout gl = new GridBagLayout();
            this.setLayout(gl);
            this.setAlignmentX(0.0f);
            GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)strFile, c);
            gl.setConstraints(strFile, c);
            c = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
            this.add((Component)open, c);
            gl.setConstraints(open, c);
        }
    }

    private static interface ParameterClassHandler {
        public Component createEditComponent(Blackboard var1);

        public void setParameter(Component var1, Object var2);

        public Object getParameter(Component var1);
    }
}

