/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.plugin.util.LayerNameGenerator;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryFunction;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GeometryFunctionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    public static final String GEOMETRY_FUNCTION_REG_KEY = "Geometry Function Registry Key";
    private String sErrorsFound = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.errors-found-while-executing-function");
    private String sFunction = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.function");
    private String sFeatures = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.features");
    private String SRC_LAYER = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Source");
    private String MASK_LAYER = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Mask");
    private String METHODS = this.sFunction;
    private String PARAM = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Parameter");
    private String SELECTED_ONLY = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Use-selected-features-only");
    private String UPDATE_SRC = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Update-Source-features-with-result");
    private String ADD_TO_SRC = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Add-result-to-Source-layer");
    private String CREATE_LYR = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-new-layer-for-result");
    private Collection functions;
    private MultiInputDialog dialog;
    private Layer srcLayer;
    private Layer maskLayer;
    private GeometryFunction functionToRun = null;
    private boolean exceptionThrown = false;
    private boolean createLayer = false;
    private boolean updateSource = false;
    private boolean addToSource = false;
    private boolean useSelected = false;
    private Geometry[] geoms = new Geometry[2];
    private double[] params = new double[2];
    private String categoryName = StandardCategoryNames.RESULT;
    private boolean addToSourceAllowed = true;
    private JComboBox layer2ComboBox;
    private JTextField paramField;
    private JLabel labelField;
    private JRadioButton updateSourceRB;
    private JRadioButton createNewLayerRB;
    private JRadioButton addToSourceRB;

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    public void setAddToSourceAllowed(boolean value) {
        this.addToSourceAllowed = value;
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, GeometryFunctionPlugIn.createEnableCheck(context.getWorkbenchContext()));
        this.registerFunctions(context);
    }

    private void registerFunctions(PlugInContext context) {
        GeometryFunction[] functions = GeometryFunction.getFunctions();
        context.getWorkbenchContext().getRegistry().createClassification(GEOMETRY_FUNCTION_REG_KEY, GeometryFunction.class);
        for (int i = 0; i < functions.length; ++i) {
            context.getWorkbenchContext().getRegistry().createEntry(GEOMETRY_FUNCTION_REG_KEY, functions[i]);
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.sErrorsFound = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.errors-found-while-executing-function");
        this.sFunction = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.function");
        this.sFeatures = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.features");
        this.SRC_LAYER = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Source");
        this.MASK_LAYER = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Mask");
        this.METHODS = this.sFunction;
        this.PARAM = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Parameter");
        this.SELECTED_ONLY = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Use-selected-features-only");
        this.UPDATE_SRC = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Update-Source-features-with-result");
        this.ADD_TO_SRC = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Add-result-to-Source-layer");
        this.CREATE_LYR = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-new-layer-for-result");
        this.functions = context.getWorkbenchContext().getRegistry().getEntries(GEOMETRY_FUNCTION_REG_KEY);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection fc1;
        monitor.allowCancellationRequests();
        if (this.functionToRun == null) {
            return;
        }
        if (this.srcLayer == null) {
            return;
        }
        if ((this.updateSource || this.addToSource) && !this.srcLayer.isEditable()) {
            context.getWorkbenchFrame().warnUser(this.srcLayer.getName() + " " + I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.is-not-editable"));
            return;
        }
        monitor.report(I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Executing-function") + " " + this.functionToRun.getName() + "...");
        ArrayList modifiedFeatures = new ArrayList();
        Collection resultFeatures = null;
        int nArgs = this.functionToRun.getGeometryArgumentCount();
        if (nArgs == 2) {
            if (this.maskLayer == null) {
                return;
            }
            fc1 = this.getFeaturesToProcess(this.srcLayer, context);
            Collection fc2 = this.getFeaturesToProcess(this.maskLayer, context);
            if (fc2.size() != 1) {
                context.getWorkbenchFrame().warnUser(I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Mask-must-contain-exactly-one-geometry"));
                return;
            }
            Geometry geomMask = ((Feature)fc2.iterator().next()).getGeometry();
            resultFeatures = this.runGeometryMethodWithMask(monitor, fc1, geomMask, this.functionToRun, modifiedFeatures);
        } else {
            fc1 = this.getFeaturesToProcess(this.srcLayer, context);
            resultFeatures = this.runGeometryMethod(monitor, fc1, this.functionToRun, modifiedFeatures);
        }
        if (resultFeatures == null) {
            return;
        }
        if (modifiedFeatures.size() == 0) {
            context.getWorkbenchFrame().warnUser(I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.No-geometries-were-processed"));
            return;
        }
        if (this.createLayer) {
            String outputLayerName = LayerNameGenerator.generateOperationOnLayerName(this.functionToRun.toString(), this.srcLayer.getName());
            FeatureDataset resultFC = new FeatureDataset(this.srcLayer.getFeatureCollectionWrapper().getFeatureSchema());
            resultFC.addAll(resultFeatures);
            context.getLayerManager().addCategory(this.categoryName);
            context.addLayer(this.categoryName, outputLayerName, resultFC);
        } else if (this.updateSource) {
            final Collection undoableNewFeatures = resultFeatures;
            final ArrayList undoableModifiedFeatures = modifiedFeatures;
            UndoableCommand cmd = new UndoableCommand(this.getName()){

                public void execute() {
                    GeometryFunctionPlugIn.this.srcLayer.getFeatureCollectionWrapper().removeAll(undoableModifiedFeatures);
                    GeometryFunctionPlugIn.this.srcLayer.getFeatureCollectionWrapper().addAll(undoableNewFeatures);
                }

                public void unexecute() {
                    GeometryFunctionPlugIn.this.srcLayer.getFeatureCollectionWrapper().removeAll(undoableNewFeatures);
                    GeometryFunctionPlugIn.this.srcLayer.getFeatureCollectionWrapper().addAll(undoableModifiedFeatures);
                }
            };
            this.execute(cmd, context);
        } else if (this.addToSource) {
            final Collection undoableFeatures = resultFeatures;
            UndoableCommand cmd = new UndoableCommand(this.getName()){

                public void execute() {
                    GeometryFunctionPlugIn.this.srcLayer.getFeatureCollectionWrapper().addAll(undoableFeatures);
                }

                public void unexecute() {
                    GeometryFunctionPlugIn.this.srcLayer.getFeatureCollectionWrapper().removeAll(undoableFeatures);
                }
            };
            this.execute(cmd, context);
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(this.sErrorsFound);
        }
    }

    private Feature getSelectedFeature(Layer lyr, PlugInContext context) {
        Collection selected = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        if (selected.size() != 1) {
            return null;
        }
        return (Feature)selected.iterator().next();
    }

    private Collection getSelectedFeatures(Layer lyr, PlugInContext context) {
        Collection selected = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        return selected;
    }

    private Collection getFeaturesToProcess(Layer lyr, PlugInContext context) {
        if (this.useSelected) {
            return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        }
        return lyr.getFeatureCollectionWrapper().getFeatures();
    }

    private Collection runGeometryMethodWithMask(TaskMonitor monitor, Collection fcA, Geometry geomB, GeometryFunction func, Collection modifiedFeatures) {
        this.exceptionThrown = false;
        ArrayList resultColl = new ArrayList();
        int total = fcA.size();
        int count = 0;
        Iterator ia = fcA.iterator();
        while (ia.hasNext()) {
            Geometry ga;
            monitor.report(count++, total, this.sFeatures);
            if (monitor.isCancelRequested()) {
                return null;
            }
            Feature fa = (Feature)ia.next();
            this.geoms[0] = ga = fa.getGeometry();
            this.geoms[1] = geomB;
            Geometry result = this.execute(func, this.geoms, this.params);
            this.saveResult(fa, result, resultColl, modifiedFeatures);
        }
        return resultColl;
    }

    private Collection runGeometryMethod(TaskMonitor monitor, Collection fc, GeometryFunction func, Collection modifiedFeatures) {
        this.exceptionThrown = false;
        ArrayList resultColl = new ArrayList();
        int total = fc.size();
        int count = 0;
        Iterator iSrc = fc.iterator();
        while (iSrc.hasNext()) {
            monitor.report(count++, total, this.sFeatures);
            if (monitor.isCancelRequested()) {
                return null;
            }
            Feature fSrc = (Feature)iSrc.next();
            Geometry gSrc = fSrc.getGeometry();
            if (gSrc == null) continue;
            this.geoms[0] = gSrc;
            Geometry result = this.execute(func, this.geoms, this.params);
            this.saveResult(fSrc, result, resultColl, modifiedFeatures);
        }
        return resultColl;
    }

    private void saveResult(Feature srcFeat, Geometry resultGeom, Collection resultColl, Collection modifiedFeatures) {
        if (resultGeom != null && !resultGeom.isEmpty()) {
            Feature fNew = srcFeat.clone(true);
            fNew.setGeometry(resultGeom);
            resultColl.add(fNew);
            modifiedFeatures.add(srcFeat);
        }
    }

    private Geometry execute(GeometryFunction func, Geometry[] geoms, double[] params) {
        try {
            return func.execute(geoms, params);
        }
        catch (RuntimeException ex) {
            this.exceptionThrown = true;
            return null;
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Computes-a-geometric-function-on-features-in-the-Source-layer") + "  " + I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Geometry-can-be-saved-to-a-new-layer,-updated-in-place,-or-added-to-the-Source-layer") + "  " + I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Binary-geometric-functions-take-a-mask-feature-as-their-second-operand"));
        if (this.srcLayer == null) {
            this.srcLayer = context.getCandidateLayer(0);
        }
        dialog.addLayerComboBox(this.SRC_LAYER, this.srcLayer, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.The-Source-layer-features-provide-the-first-operand-for-the-chosen-function"), context.getLayerManager());
        JComboBox functionComboBox = dialog.addComboBox(this.METHODS, this.functionToRun, this.functions, null);
        functionComboBox.addItemListener(new MethodItemListener());
        this.paramField = dialog.addDoubleField(this.PARAM, this.params[0], 10);
        this.layer2ComboBox = dialog.addLayerComboBox(this.MASK_LAYER, this.maskLayer, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.The-Mask-layer-must-contain-a-single-feature,-which-is-used-as-the-second-operand-for-binary-functions"), context.getLayerManager());
        dialog.addCheckBox(this.SELECTED_ONLY, this.useSelected);
        String OUTPUT_GROUP = I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Match-Type");
        this.createNewLayerRB = dialog.addRadioButton(this.CREATE_LYR, OUTPUT_GROUP, true, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Create-a-new-layer-for-the-results"));
        this.updateSourceRB = dialog.addRadioButton(this.UPDATE_SRC, OUTPUT_GROUP, false, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Replace-the-geometry-of-Source-features-with-the-result-geometry") + "  ");
        if (this.addToSourceAllowed) {
            this.addToSourceRB = dialog.addRadioButton(this.ADD_TO_SRC, OUTPUT_GROUP, false, I18N.get("ui.plugin.analysis.GeometryFunctionPlugIn.Add-the-result-geometry-to-the-Source-layer") + "  ");
        }
        this.updateUIForMethod(this.functionToRun);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.srcLayer = dialog.getLayer(this.SRC_LAYER);
        this.maskLayer = dialog.getLayer(this.MASK_LAYER);
        this.functionToRun = (GeometryFunction)dialog.getComboBox(this.METHODS).getSelectedItem();
        this.params[0] = dialog.getDouble(this.PARAM);
        this.useSelected = dialog.getBoolean(this.SELECTED_ONLY);
        this.createLayer = dialog.getBoolean(this.CREATE_LYR);
        this.updateSource = dialog.getBoolean(this.UPDATE_SRC);
        if (this.addToSourceAllowed) {
            this.addToSource = dialog.getBoolean(this.ADD_TO_SRC);
        }
    }

    private void updateUIForMethod(GeometryFunction func) {
        boolean layer2Used = false;
        boolean paramUsed = false;
        if (func != null) {
            layer2Used = func.getGeometryArgumentCount() > 1;
            paramUsed = func.getParameterCount() > 0;
        }
        this.layer2ComboBox.setEnabled(layer2Used);
        this.paramField.setEnabled(paramUsed);
        this.paramField.setOpaque(paramUsed);
        this.dialog.validate();
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            GeometryFunctionPlugIn.this.updateUIForMethod((GeometryFunction)e.getItem());
        }
    }
}

