/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AbstractSaveProjectPlugIn;
import java.io.File;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn;

public class SaveProjectAsPlugIn
extends AbstractSaveProjectPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("layout_save.png");
    public static final FileFilter JUMP_PROJECT_FILE_FILTER = GUIUtil.createFileFilter(I18N.get("ui.plugin.SaveProjectAsPlugIn.jump-project-files"), new String[]{"jmp", "jcs"});
    private JFileChooser fileChooser;

    public void initialize(PlugInContext context) throws Exception {
        this.fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting("jmp");
        this.fileChooser.setDialogTitle(I18N.get("ui.plugin.SaveProjectAsPlugIn.save-project"));
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(JUMP_PROJECT_FILE_FILTER);
    }

    public String getName() {
        return I18N.get("ui.plugin.SaveProjectAsPlugIn.save-project-as");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (context.getTask().getProjectFile() != null) {
            this.fileChooser.setSelectedFile(context.getTask().getProjectFile());
        }
        if (0 != this.fileChooser.showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        File file = this.fileChooser.getSelectedFile();
        Collection collection = this.ignoredLayers(context.getTask());
        if (collection.size() > 0) {
            new SaveLayersWithoutDataSourcePlugIn().execute(context, collection, FileUtil.removeExtensionIfAny(file));
        }
        file = FileUtil.addExtensionIfNone(file, "jmp");
        this.save(context.getTask(), file, context.getWorkbenchFrame());
        return true;
    }
}

