/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.MenuItemShownListener;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.swing.listener.EnableCheckMenuItemShownListener;
import org.openjump.core.ui.swing.listener.MenuItemShownMenuListener;

public class FeatureInstaller {
    private WorkbenchContext workbenchContext;
    private TaskMonitorManager taskMonitorManager = new TaskMonitorManager();
    private EnableCheckFactory checkFactory;
    private static Map plugin_EnableCheckMap = new HashMap();
    private static Map repeatMenuItemMap = new HashMap();
    private static RepeatableMenuItem[] RepeatableMenuItemArray = new RepeatableMenuItem[]{null, null, null};

    public FeatureInstaller(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.checkFactory = new EnableCheckFactory(workbenchContext);
    }

    public MultiEnableCheck createLayersSelectedCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public MultiEnableCheck createOneLayerSelectedCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public MultiEnableCheck createVectorsExistCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createAtLeastNVectorsMustBeDrawnCheck(1));
    }

    public MultiEnableCheck createFenceExistsCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createFenceMustBeDrawnCheck());
    }

    public void addMenuSeparator(String menu) {
        this.addMenuSeparator(new String[]{menu});
    }

    public void addMenuSeparator(String[] menuPath) {
        JMenu mainMenu = this.menuBarMenu(menuPath[0]);
        this.addMenuSeparator(this.createMenusIfNecessary(mainMenu, this.behead(menuPath)));
    }

    public void addMenuSeparator(JMenu menu) {
        Component separator = null;
        Component exitMenu = null;
        if (menu.getText().equals(MenuNames.FILE)) {
            separator = menu.getMenuComponent(menu.getMenuComponentCount() - 2);
            exitMenu = menu.getMenuComponent(menu.getMenuComponentCount() - 1);
            menu.remove(separator);
            menu.remove(exitMenu);
        }
        menu.addSeparator();
        if (menu.getText().equals(MenuNames.FILE)) {
            menu.add(separator);
            menu.add(exitMenu);
        }
    }

    private void associate(JMenuItem menuItem, PlugIn plugIn) {
        menuItem.addActionListener(AbstractPlugIn.toActionListener(plugIn, this.workbenchContext, this.taskMonitorManager));
    }

    public String[] behead(String[] a1) {
        String[] a2 = new String[a1.length - 1];
        System.arraycopy(a1, 1, a2, 0, a2.length);
        return a2;
    }

    public void addMainMenuItem(PlugIn executable, String menuName, String menuItemName, Icon icon, EnableCheck enableCheck) {
        this.addMainMenuItem(executable, new String[]{menuName}, menuItemName, false, icon, enableCheck);
    }

    public void addLayerViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerNameViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()));
    }

    public void addMainMenuItem(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        Map properties = this.extractProperties(menuItemName);
        menuItemName = FeatureInstaller.removeProperties(menuItemName);
        JMenu menu = this.menuBarMenu(menuPath[0]);
        if (menu == null) {
            menu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), this.menuBar());
            this.addToMenuBar(menu);
        }
        JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), parent);
        menuItem.setIcon(icon);
        this.associate(menuItem, executable);
        this.insert(menuItem, this.createMenu(parent), properties);
        if (enableCheck != null) {
            this.addMenuItemShownListener(menuItem, this.toMenuItemShownListener(enableCheck));
        }
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, int index) {
        String menuItemName = plugin.getName();
        JMenu menu = this.menuBarMenu(menuPath[0]);
        if (menu == null) {
            menu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), this.menuBar());
            this.addToMenuBar(menu);
        }
        JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
        JMenuItem menuItem = new JMenuItem(menuItemName);
        FeatureInstaller.installMnemonic(menuItem, parent);
        menuItem.setIcon(plugin.getIcon());
        menuItem.addActionListener(plugin);
        if (index == Integer.MAX_VALUE) {
            parent.add(menuItem);
        } else if (index < 0) {
            int endIndex = parent.getMenuComponentCount() + index + 1;
            parent.add((Component)menuItem, endIndex);
        } else {
            parent.add((Component)menuItem, index);
        }
        EnableCheck enableCheck = plugin.getEnableCheck();
        if (enableCheck != null) {
            this.addMenuItemShownListener(menuItem, new EnableCheckMenuItemShownListener(this.workbenchContext, enableCheck, plugin.getToolTip()));
        }
        return menuItem;
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, JMenuItem menuItem, int index) {
        String menuItemName = plugin.getName();
        JMenu menu = this.menuBarMenu(menuPath[0]);
        if (menu == null) {
            menu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), this.menuBar());
            this.addToMenuBar(menu);
        }
        JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
        FeatureInstaller.installMnemonic(menuItem, parent);
        menuItem.setIcon(plugin.getIcon());
        menuItem.addActionListener(plugin);
        if (index == Integer.MAX_VALUE) {
            parent.add(menuItem);
        } else if (index < 0) {
            int endIndex = parent.getMenuComponentCount() + index + 1;
            parent.add((Component)menuItem, endIndex);
        } else {
            parent.add((Component)menuItem, index);
        }
        EnableCheck enableCheck = plugin.getEnableCheck();
        if (enableCheck != null) {
            this.addMenuItemShownListener(menuItem, new EnableCheckMenuItemShownListener(this.workbenchContext, enableCheck, plugin.getToolTip()));
        }
        return menuItem;
    }

    private Menu createMenu(final JMenu menu) {
        return new Menu(){

            public void insert(JMenuItem menuItem, int i) {
                menu.insert(menuItem, i);
            }

            public String getText() {
                return menu.getText();
            }

            public int getItemCount() {
                return menu.getItemCount();
            }

            public void add(JMenuItem menuItem) {
                menu.add(menuItem);
            }
        };
    }

    private void insert(JMenuItem menuItem, Menu parent, Map properties) {
        if (properties.get("pos") != null) {
            parent.insert(menuItem, Integer.parseInt((String)properties.get("pos")));
        } else if (parent.getText().equals(MenuNames.FILE)) {
            parent.insert(menuItem, parent.getItemCount() - 2);
        } else {
            parent.add(menuItem);
        }
    }

    private Map extractProperties(String menuItemName) {
        if (menuItemName.indexOf(123) == -1) {
            return new HashMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String s = menuItemName.substring(menuItemName.indexOf(123) + 1, menuItemName.indexOf(125));
        for (String property : StringUtil.fromCommaDelimitedString(s)) {
            properties.put(property.substring(0, property.indexOf(58)).trim(), property.substring(property.indexOf(58) + 1, property.length()).trim());
        }
        return properties;
    }

    public static String removeProperties(String menuItemName) {
        return menuItemName.indexOf(123) > -1 ? menuItemName.substring(0, menuItemName.indexOf(123)) : menuItemName;
    }

    public static JMenuItem installMnemonic(JMenuItem menuItem, MenuElement parent) {
        String text = menuItem.getText();
        StringUtil.replaceAll(text, "&&", "##");
        int ampersandPosition = text.indexOf(38);
        if (-1 < ampersandPosition && ampersandPosition + 1 < text.length()) {
            menuItem.setMnemonic(text.charAt(ampersandPosition + 1));
            text = StringUtil.replace(text, "&", "", false);
        } else {
            FeatureInstaller.installDefaultMnemonic(menuItem, parent);
        }
        StringUtil.replaceAll(text, "##", "&");
        menuItem.setText(text);
        return menuItem;
    }

    private static void installDefaultMnemonic(JMenuItem menuItem, MenuElement parent) {
        block0: for (int i = 0; i < menuItem.getText().length(); ++i) {
            char candidate = Character.toUpperCase(menuItem.getText().charAt(i));
            if (!Character.isLetter(candidate)) continue;
            for (JMenuItem other : FeatureInstaller.menuItems(parent)) {
                if (other.getMnemonic() != candidate) continue;
                continue block0;
            }
            menuItem.setMnemonic(candidate);
            return;
        }
        menuItem.setMnemonic(menuItem.getText().charAt(0));
    }

    private static Collection menuItems(MenuElement element) {
        ArrayList<MenuElement> menuItems = new ArrayList<MenuElement>();
        if (element instanceof JMenuBar) {
            for (int i = 0; i < ((JMenuBar)element).getMenuCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenuBar)element).getMenu(i), menuItems);
            }
        } else if (element instanceof JMenu) {
            for (int i = 0; i < ((JMenu)element).getItemCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenu)element).getItem(i), menuItems);
            }
        } else if (element instanceof JPopupMenu) {
            MenuElement[] children = ((JPopupMenu)element).getSubElements();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof JMenuItem)) continue;
                menuItems.add(children[i]);
            }
        } else {
            Assert.shouldNeverReachHere((String)element.getClass().getName());
        }
        return menuItems;
    }

    private MenuItemShownListener toMenuItemShownListener(EnableCheck enableCheck) {
        return new EnableCheckMenuItemShownListener(this.workbenchContext, enableCheck);
    }

    public JMenu createMenusIfNecessary(JMenu parent, String[] menuPath) {
        if (menuPath.length == 0) {
            return parent;
        }
        JMenu child = (JMenu)FeatureInstaller.childMenuItem(menuPath[0], parent);
        if (child == null) {
            child = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), parent);
            parent.add(child);
        }
        return this.createMenusIfNecessary(child, this.behead(menuPath));
    }

    public void addMenuItemShownListener(JMenuItem menuItem, MenuItemShownListener menuItemShownListener) {
        JMenu menu = (JMenu)((JPopupMenu)menuItem.getParent()).getInvoker();
        menu.addMenuListener(new MenuItemShownMenuListener(menuItem, menuItemShownListener));
    }

    public void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        Map properties = this.extractProperties(menuItemName);
        menuItemName = FeatureInstaller.removeProperties(menuItemName);
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), popupMenu);
        menuItem.setIcon(icon);
        this.addPopupMenuItem(popupMenu, executable, new String[0], menuItem, properties, enableCheck);
    }

    public void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        Map properties = this.extractProperties(menuItemName);
        menuItemName = FeatureInstaller.removeProperties(menuItemName);
        JMenuItem menuItem = FeatureInstaller.installMnemonic(checkBox ? new JCheckBoxMenuItem(menuItemName) : new JMenuItem(menuItemName), popupMenu);
        menuItem.setIcon(icon);
        this.addPopupMenuItem(popupMenu, executable, menuPath, menuItem, properties, enableCheck);
    }

    private void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String[] menuPath, final JMenuItem menuItem, Map properties, final EnableCheck enableCheck) {
        this.associate(menuItem, executable);
        if (menuPath == null || menuPath.length == 0) {
            this.insert(menuItem, this.createMenu(popupMenu), properties);
        } else {
            JMenu menu = FeatureInstaller.popupMenu(popupMenu, menuPath[0]);
            if (menu == null) {
                menu = (JMenu)popupMenu.add(new JMenu(menuPath[0]));
            }
            JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
            this.insert(menuItem, this.createMenu(parent), properties);
        }
        if (enableCheck != null) {
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    FeatureInstaller.this.toMenuItemShownListener(enableCheck).menuItemShown(menuItem);
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    public void addPopupMenuSeparator(JPopupMenu popupMenu, String[] menuPath) {
        if (menuPath == null || menuPath.length == 0) {
            popupMenu.addSeparator();
        } else {
            JMenu menu = FeatureInstaller.popupMenu(popupMenu, menuPath[0]);
            if (menu == null) {
                menu = (JMenu)popupMenu.add(new JMenu(menuPath[0]));
            }
            JMenu parent = this.createMenusIfNecessary(menu, this.behead(menuPath));
            parent.addSeparator();
        }
    }

    public static JMenu popupMenu(JPopupMenu popupMenu, String childName) {
        MenuElement[] subElements = popupMenu.getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            JMenuItem menuItem;
            if (!(subElements[i] instanceof JMenuItem) || !(menuItem = (JMenuItem)subElements[i]).getText().equals(childName)) continue;
            return (JMenu)menuItem;
        }
        return null;
    }

    private Menu createMenu(final JPopupMenu popupMenu) {
        return new Menu(){

            public void insert(JMenuItem menuItem, int i) {
                popupMenu.insert(menuItem, i);
            }

            public String getText() {
                return "";
            }

            public int getItemCount() {
                return popupMenu.getComponentCount();
            }

            public void add(JMenuItem menuItem) {
                popupMenu.add(menuItem);
            }
        };
    }

    public JMenuBar menuBar() {
        return this.workbenchContext.getWorkbench().getFrame().getJMenuBar();
    }

    public JMenu menuBarMenu(String childName) {
        MenuElement[] subElements = this.menuBar().getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            JMenuItem menuItem;
            if (!(subElements[i] instanceof JMenuItem) || !(menuItem = (JMenuItem)subElements[i]).getText().equals(childName)) continue;
            return (JMenu)menuItem;
        }
        return null;
    }

    private void addToMenuBar(JMenu menu) {
        this.menuBar().add(menu);
        JMenu windowMenu = this.menuBarMenu(MenuNames.WINDOW);
        JMenu helpMenu = this.menuBarMenu(MenuNames.HELP);
        if (windowMenu != null) {
            this.menuBar().remove(windowMenu);
        }
        if (helpMenu != null) {
            this.menuBar().remove(helpMenu);
        }
        if (windowMenu != null) {
            this.menuBar().add(windowMenu);
        }
        if (helpMenu != null) {
            this.menuBar().add(helpMenu);
        }
    }

    public static JMenuItem childMenuItem(String childName, MenuElement menu) {
        if (menu instanceof JMenu) {
            return FeatureInstaller.childMenuItem(childName, ((JMenu)menu).getPopupMenu());
        }
        MenuElement[] childMenuItems = menu.getSubElements();
        for (int i = 0; i < childMenuItems.length; ++i) {
            if (!(childMenuItems[i] instanceof JMenuItem) || !((JMenuItem)childMenuItems[i]).getText().equals(childName)) continue;
            return (JMenuItem)childMenuItems[i];
        }
        return null;
    }

    public void addMainMenuItemWithJava14Fix(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        this.addMainMenuItem(executable, menuPath, menuItemName, checkBox, icon, enableCheck);
        JMenuItem menuItem = FeatureInstaller.childMenuItem(FeatureInstaller.removeProperties(menuItemName), this.createMenusIfNecessary(this.menuBarMenu(menuPath[0]), this.behead(menuPath)));
        final ActionListener listener = this.abstractPlugInActionListener(menuItem.getActionListeners());
        menuItem.removeActionListener(listener);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(final ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        listener.actionPerformed(e);
                    }
                });
            }
        });
    }

    private ActionListener abstractPlugInActionListener(ActionListener[] actionListeners) {
        for (int i = 0; i < actionListeners.length; ++i) {
            if (actionListeners[i].getClass().getName().indexOf(AbstractPlugIn.class.getName()) <= -1) continue;
            return actionListeners[i];
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public static JMenu addMainMenu(FeatureInstaller featureInstaller, String[] menuPath, String menuName, int index) {
        JMenu menu = new JMenu(menuName);
        JMenu parent = featureInstaller.createMenusIfNecessary(featureInstaller.menuBarMenu(menuPath[0]), featureInstaller.behead(menuPath));
        parent.insert(menu, index);
        return menu;
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugIn) {
        return this.addMainMenuItem(menuPath, plugIn, -1);
    }

    public void associateWithRepeat(PlugIn executable) {
        int i;
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        if (!plugin_EnableCheckMap.containsKey(executable)) {
            return;
        }
        for (i = 0; i < RepeatableMenuItemArray.length; ++i) {
            if (RepeatableMenuItemArray[i] == null || !RepeatableMenuItemArray[i].isSetTo(executable)) continue;
            return;
        }
        for (i = 0; i < RepeatableMenuItemArray.length && RepeatableMenuItemArray[i] != null; ++i) {
            PopupMenuListener menuListener = RepeatableMenuItemArray[i].getMenuListener();
            if (menuListener == null) continue;
            popupMenu.removePopupMenuListener(menuListener);
        }
        for (i = RepeatableMenuItemArray.length - 1; i > 0; --i) {
            if (RepeatableMenuItemArray[i - 1] == null) continue;
            PlugIn prevExec = RepeatableMenuItemArray[i - 1].getExecutable();
            EnableCheck prevEnableCheck = (EnableCheck)plugin_EnableCheckMap.get(prevExec);
            if (RepeatableMenuItemArray[i] == null) {
                RepeatableMenuItem repeatMenuItem = new RepeatableMenuItem(prevExec, prevEnableCheck);
                popupMenu.insert(repeatMenuItem.getMenuItem(), i + 3);
                FeatureInstaller.RepeatableMenuItemArray[i] = repeatMenuItem;
                continue;
            }
            RepeatableMenuItemArray[i].setExecutable(prevExec, prevEnableCheck);
        }
        EnableCheck enableCheck = (EnableCheck)plugin_EnableCheckMap.get(executable);
        if (RepeatableMenuItemArray[0] == null) {
            RepeatableMenuItem repeatMenuItem = new RepeatableMenuItem(executable, enableCheck);
            popupMenu.insert(repeatMenuItem.getMenuItem(), 2);
            popupMenu.insert(new JPopupMenu.Separator(), 2);
            FeatureInstaller.RepeatableMenuItemArray[0] = repeatMenuItem;
        } else {
            RepeatableMenuItemArray[0].setExecutable(executable, enableCheck);
        }
        for (int i2 = 0; i2 < RepeatableMenuItemArray.length && RepeatableMenuItemArray[i2] != null; ++i2) {
            PopupMenuListener menuListener = RepeatableMenuItemArray[i2].getMenuListener();
            if (menuListener == null) continue;
            popupMenu.addPopupMenuListener(menuListener);
        }
    }

    public class JumpMenuListener
    implements MenuListener {
        MenuItemShownListener menuItemShownListener;
        JMenuItem menuItem;

        public JumpMenuListener(MenuItemShownListener menuItemShownListener, JMenuItem menuItem) {
            this.menuItemShownListener = menuItemShownListener;
            this.menuItem = menuItem;
        }

        public void menuSelected(MenuEvent e) {
            this.menuItemShownListener.menuItemShown(this.menuItem);
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }
    }

    private class RepeatableMenuItem {
        private PlugIn executable = null;
        private JMenuItem menuItem = new JMenuItem("Repeat");
        private PopupMenuListener menuListener = null;

        public RepeatableMenuItem(PlugIn executable, EnableCheck enableCheck) {
            this.setExecutable(executable, enableCheck);
        }

        public void setExecutable(PlugIn executable, final EnableCheck enableCheck) {
            this.executable = executable;
            ActionListener[] al = this.menuItem.getActionListeners();
            for (int i = 0; i < al.length; ++i) {
                this.menuItem.removeActionListener(al[0]);
            }
            this.menuItem.addActionListener(AbstractPlugIn.toActionListener(executable, FeatureInstaller.this.workbenchContext, FeatureInstaller.this.taskMonitorManager));
            this.menuItem.setText("Repeat: " + executable.getName());
            this.menuListener = enableCheck == null ? null : new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    FeatureInstaller.this.toMenuItemShownListener(enableCheck).menuItemShown(RepeatableMenuItem.this.menuItem);
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
        }

        JMenuItem getMenuItem() {
            return this.menuItem;
        }

        PlugIn getExecutable() {
            return this.executable;
        }

        PopupMenuListener getMenuListener() {
            return this.menuListener;
        }

        boolean isSetTo(PlugIn executable) {
            return this.executable == executable;
        }
    }

    private static interface Menu {
        public void insert(JMenuItem var1, int var2);

        public String getText();

        public int getItemCount();

        public void add(JMenuItem var1);
    }
}

