/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesOp;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import javax.swing.JComponent;

public class SnapVerticesToSelectedVertexClickTool
extends NClickTool {
    private EnableCheckFactory checkFactory;
    private GeometryFactory factory = new GeometryFactory();

    public SnapVerticesToSelectedVertexClickTool(EnableCheckFactory checkFactory) {
        super(1);
        this.checkFactory = checkFactory;
    }

    public Icon getIcon() {
        Assert.shouldNeverReachHere();
        return null;
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        final Coordinate clickCoordinate = (Coordinate)this.getCoordinates().get(0);
        if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory.createFenceMustBeDrawnCheck())) {
            return;
        }
        if (!this.check(new EnableCheck(){

            public String check(JComponent component) {
                if (!SnapVerticesToSelectedVertexClickTool.this.getPanel().getFence().contains((Geometry)SnapVerticesToSelectedVertexClickTool.this.factory.createPoint(clickCoordinate))) {
                    return I18N.get("ui.cursortool.editing.SnapVerticesToSelectedVertexClickTool.please-click-inside-the-fence");
                }
                if (SnapVerticesToSelectedVertexClickTool.this.getPanel().getSelectionManager().getSelectedItems().isEmpty()) {
                    return I18N.get("ui.cursortool.editing.SnapVerticesToSelectedVertexClickTool.select-a-feature-part-or-linestring-in-the-fence-containing-the-vertex-to-snap-to");
                }
                if (SnapVerticesToSelectedVertexClickTool.this.getPanel().getSelectionManager().getSelectedItems().size() > 1) {
                    return I18N.get("ui.cursortool.editing.SnapVerticesToSelectedVertexClickTool.select-only-one-feature-part-or-linestring-containing-the-vertex-to-snap-to");
                }
                return null;
            }
        })) {
            return;
        }
        new SnapVerticesOp().execute(this.getPanel().getFence(), this.getPanel().getLayerManager().getEditableLayers(), this.isRollingBackInvalidEdits(), this.getPanel(), this.getTaskFrame().getTask(), clickCoordinate, (Feature)this.getPanel().getSelectionManager().getFeaturesWithSelectedItems((Layer)this.getPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next()).iterator().next(), this.getWorkbench().getBlackboard().get(SnapVerticesOp.INSERT_VERTICES_IF_NECESSARY_KEY, true));
    }

    protected Shape getShape() throws NoninvertibleTransformException {
        return null;
    }
}

