/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractClickSelectedLineStringsTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringsOp;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import javax.swing.Icon;

public class SplitLineStringTool
extends AbstractClickSelectedLineStringsTool {
    Coordinate snapCoord = null;

    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringTool.Split-LinesStrings");
    }

    protected void gestureFinished(Collection nearbyLineStringFeatures) throws NoninvertibleTransformException {
        Feature closestFeature = this.closest(nearbyLineStringFeatures, this.getModelClickPoint());
        LineString lineString = (LineString)closestFeature.getGeometry();
        if (CollectionUtil.list(lineString.getStartPoint().getCoordinate(), lineString.getEndPoint().getCoordinate()).contains(DistanceOp.closestPoints((Geometry)lineString, (Geometry)this.getModelClickPoint())[0])) {
            this.getWorkbench().getFrame().warnUser("No selected LineStrings here");
            return;
        }
        if (!this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()).isEditable()) {
            this.warnLayerNotEditable(this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()));
            return;
        }
        if (this.snapCoord != null) {
            this.split(closestFeature, this.snapCoord, this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()));
        } else {
            this.split(closestFeature, this.getModelDestination(), this.layer(closestFeature, this.layerToSpecifiedFeaturesMap()));
        }
    }

    private void split(Feature feature, Coordinate coordinate, Layer layer) {
        new SplitLineStringsOp(Color.blue).addSplit(feature, coordinate, layer, false).execute(this.getName(), this.isRollingBackInvalidEdits(), this.getPanel());
    }

    private Feature closest(Collection features, Point point) {
        double tol;
        Feature closestFeature = null;
        this.snapCoord = null;
        double closestDistance = tol = (double)SnapManager.getToleranceInPixels(this.getWorkbench().getBlackboard()) / this.getPanel().getViewport().getScale();
        for (Feature feature : features) {
            double distance = feature.getGeometry().distance((Geometry)point);
            if (!(distance < closestDistance)) continue;
            closestFeature = feature;
            closestDistance = distance;
        }
        this.snapCoord = this.getVertexToSnap(closestFeature.getGeometry(), point, tol);
        return closestFeature;
    }

    public Icon getIcon() {
        return IconLoader.icon("SplitLinestring.gif");
    }

    private Coordinate getVertexToSnap(Geometry g, Point p, double tolerance) {
        Coordinate coord = null;
        if (g instanceof LineString) {
            LineString ls = (LineString)g;
            double minDist = tolerance;
            for (int i = 0; i < ls.getNumPoints(); ++i) {
                Point pT = ls.getPointN(i);
                double dist = pT.distance((Geometry)p);
                if (!(dist < minDist)) continue;
                minDist = dist;
                coord = (Coordinate)pT.getCoordinate().clone();
            }
        }
        return coord;
    }
}

