/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class NoteStyle
implements Style {
    public static final int WIDTH = 80;
    public static final int HEIGHT = 30;
    public static final String CREATED = I18N.get("ui.cursortool.NoteStyle.CREATED");
    public static final String MODIFIED = I18N.get("ui.cursortool.NoteStyle.MODIFIED");
    public static final String TEXT = I18N.get("ui.cursortool.NoteStyle.TEXT");
    public static final String GEOMETRY = "GEOMETRY";
    private JTextArea myTextArea = NoteStyle.createTextArea();
    private Layer layer;

    public static FeatureSchema createFeatureSchema() {
        return new FeatureSchema(){
            {
                this.addAttribute(CREATED, AttributeType.DATE);
                this.addAttribute(MODIFIED, AttributeType.DATE);
                this.addAttribute(TEXT, AttributeType.STRING);
                this.addAttribute(NoteStyle.GEOMETRY, AttributeType.GEOMETRY);
            }
        };
    }

    public static JTextArea createTextArea() {
        return new JTextArea(){
            {
                this.setFont(new JLabel().getFont());
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            }
        };
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        this.paint(f, viewport.toViewPoint(f.getGeometry().getCoordinate()), g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(Feature f, Point2D location, Graphics2D g) {
        this.myTextArea.setText(f.getString(TEXT));
        int ht = this.myTextArea.getPreferredSize().height;
        int wt = this.myTextArea.getPreferredSize().width;
        if (ht < 30) {
            ht = 30;
        }
        if (wt < 80) {
            wt = 80;
        }
        this.myTextArea.setBounds(0, 0, wt, ht);
        Composite originalComposite = g.getComposite();
        g.translate(location.getX(), location.getY());
        try {
            g.setComposite(AlphaComposite.getInstance(3, (float)this.layer.getBasicStyle().getAlpha() / 255.0f));
            this.myTextArea.paint(g);
        }
        finally {
            g.setComposite(originalComposite);
            g.translate(-location.getX(), -location.getY());
        }
    }

    public void initialize(Layer layer) {
        this.layer = layer;
        this.myTextArea.setBackground(layer.getBasicStyle().getFillColor());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public boolean isEnabled() {
        return true;
    }
}

