/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractClickSelectedLineStringsTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringsOp;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

public class NodeLineStringsTool
extends AbstractClickSelectedLineStringsTool {
    private static final String sNoIntersectionsHere = I18N.get("com.vividsolutions.jump.workbench.ui.cursortool.NodeLineStringsTool.No-intersections-here");

    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.cursortool.NodeLineStringsTool.Node-LineStrings");
    }

    protected void gestureFinished(Collection nearbyLineStringFeatures) throws NoninvertibleTransformException {
        Intersection intersection = this.closest(this.getModelClickPoint(), CollectionUtil.select(this.properIntersections(nearbyLineStringFeatures, this.layerToSpecifiedFeaturesMap()), new Block(){

            public Object yield(Object intersection) {
                try {
                    return NodeLineStringsTool.this.getBoxInModelCoordinates().contains(((Intersection)intersection).coordinate) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (NoninvertibleTransformException e) {
                    return Boolean.FALSE;
                }
            }
        }));
        if (intersection == null) {
            this.getWorkbench().getFrame().warnUser(sNoIntersectionsHere);
            return;
        }
        if (!intersection.layerA.isEditable()) {
            this.warnLayerNotEditable(intersection.layerA);
            return;
        }
        if (!intersection.layerB.isEditable()) {
            this.warnLayerNotEditable(intersection.layerB);
            return;
        }
        new SplitLineStringsOp(Color.magenta).addSplit(intersection.featureA, intersection.coordinate, intersection.layerA, true).addSplit(intersection.featureB, intersection.coordinate, intersection.layerB, true).execute(this.getName(), this.isRollingBackInvalidEdits(), this.getPanel());
    }

    private Intersection closest(Point p, Collection intersections) {
        Intersection closestIntersection = null;
        double closestDistance = Double.MAX_VALUE;
        for (Intersection intersection : intersections) {
            double distance = intersection.coordinate.distance(p.getCoordinate());
            if (!(distance < closestDistance)) continue;
            closestIntersection = intersection;
            closestDistance = distance;
        }
        return closestIntersection;
    }

    private Set properIntersections(Collection nearbyLineStringFeatures, Map layerToFeaturesMap) {
        TreeSet<Intersection> intersections = new TreeSet<Intersection>();
        for (Feature a : nearbyLineStringFeatures) {
            for (Feature b : nearbyLineStringFeatures) {
                if (a == b) continue;
                for (Coordinate coordinate : Arrays.asList(a.getGeometry().intersection(b.getGeometry()).getCoordinates())) {
                    if (coordinate.equals2D(this.first(a)) || coordinate.equals2D(this.last(a)) || coordinate.equals2D(this.first(b)) || coordinate.equals2D(this.last(b))) continue;
                    intersections.add(new Intersection(coordinate, a, this.layer(a, layerToFeaturesMap), b, this.layer(b, layerToFeaturesMap)));
                }
            }
        }
        return intersections;
    }

    private Coordinate first(Feature lineStringFeature) {
        return this.lineString(lineStringFeature).getCoordinateN(0);
    }

    private LineString lineString(Feature feature) {
        return (LineString)feature.getGeometry();
    }

    private Coordinate last(Feature lineStringFeature) {
        return this.lineString(lineStringFeature).getCoordinateN(this.lineString(lineStringFeature).getNumPoints() - 1);
    }

    public Icon getIcon() {
        return IconLoader.icon("SplitLinestringsAtIntersection.gif");
    }

    private class Intersection
    implements Comparable {
        private Coordinate coordinate;
        private Feature featureA;
        private Feature featureB;
        private Layer layerA;
        private Layer layerB;

        public Intersection(Coordinate coordinate, Feature featureA, Layer layerA, Feature featureB, Layer layerB) {
            this.coordinate = coordinate;
            this.featureA = featureA;
            this.layerA = layerA;
            this.featureB = featureB;
            this.layerB = layerB;
        }

        public int compareTo(Object o) {
            return this.coordinate.compareTo((Object)((Intersection)o).coordinate);
        }
    }
}

