/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MultiInputDialogInfoPanel
extends JPanel {
    static final int DEFAULT_WIDTH = 200;
    static final int DEFAULT_HEIGHT = 120;
    private int fixedWidth = 200;
    private int defaultHeight = 120;
    private final JLabel imageLabel = new JLabel();
    private final JTextArea textArea = new JTextArea();
    private final JScrollPane jsp = new JScrollPane(this.textArea);

    public MultiInputDialogInfoPanel() {
        this("", null, 200, 120);
    }

    public MultiInputDialogInfoPanel(String description, int width) {
        this(description, null, width, 120);
    }

    public MultiInputDialogInfoPanel(String description, int width, int height) {
        this(description, null, width, height);
    }

    public MultiInputDialogInfoPanel(String description) {
        this(description, null, 200, 120);
    }

    public MultiInputDialogInfoPanel(Icon icon) {
        this("", icon, 200, 120);
    }

    public MultiInputDialogInfoPanel(Icon icon, int width) {
        this("", icon, width, 120);
    }

    public MultiInputDialogInfoPanel(String description, Icon icon, int width, int height) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.imageLabel.setIcon(icon);
        this.add((Component)this.imageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.textArea.setEnabled(false);
        this.textArea.setEditable(false);
        this.textArea.setOpaque(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFont(this.imageLabel.getFont());
        this.textArea.setDisabledTextColor(this.imageLabel.getForeground());
        this.textArea.setText(description);
        this.jsp.setBorder(null);
        this.add((Component)this.jsp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.fixedWidth = width;
        this.defaultHeight = height;
        if (icon == null && (description == null || description.trim().length() == 0)) {
            this.setVisible(false);
        } else {
            this.textArea.setCaretPosition(0);
            this.setVisible(true);
        }
    }

    public String getDescription() {
        return this.textArea.getText();
    }

    public void setDescription(String description) {
        this.setIconAndDescription(this.getIcon(), description);
    }

    public Icon getIcon() {
        return this.imageLabel.getIcon();
    }

    public void setIcon(Icon icon) {
        this.setIconAndDescription(icon, this.getDescription());
    }

    private void setIconAndDescription(Icon icon, String description) {
        this.imageLabel.setIcon(icon);
        this.textArea.setText(description);
        if (icon == null && (description == null || description.trim().length() == 0)) {
            this.setVisible(false);
        } else {
            if (this.fixedWidth <= 0) {
                this.fixedWidth = 200;
            }
            this.textArea.setCaretPosition(0);
            this.setVisible(true);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fixedWidth, this.defaultHeight);
    }
}

