/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.util.StringUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    FlowLayout flowLayout1 = new FlowLayout();
    GridLayout gridLayout1 = new GridLayout();
    JPanel innerButtonPanel = new JPanel();
    private ArrayList actionListeners = new ArrayList();
    protected JButton selectedButton;
    private HashMap textToButtonMap = new HashMap();

    public JButton getButton(String text) {
        return (JButton)this.textToButtonMap.get(text);
    }

    public ButtonPanel(String[] buttonText) {
        this.innerButtonPanel.setLayout(this.gridLayout1);
        this.setLayout(this.flowLayout1);
        this.gridLayout1.setVgap(5);
        this.gridLayout1.setHgap(5);
        this.add((Component)this.innerButtonPanel, null);
        for (int i = 0; i < buttonText.length; ++i) {
            this.innerButtonPanel.add((Component)this.createButton(buttonText[i]), null);
        }
    }

    private JButton createButton(String buttonText) {
        final JButton button = new JButton(StringUtil.replaceAll(buttonText, "&", ""));
        button.setMnemonic(buttonText.indexOf("&") > -1 ? buttonText.charAt(buttonText.indexOf("&") + 1) : buttonText.charAt(0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ButtonPanel.this.selectedButton = button;
                ButtonPanel.this.fireActionPerformed();
            }
        });
        this.textToButtonMap.put(button.getText(), button);
        return button;
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    private void fireActionPerformed() {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public JButton getSelectedButton() {
        return this.selectedButton;
    }

    public void setSelectedButton(JButton selectedButton) {
        this.selectedButton = selectedButton;
    }
}

