/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import java.awt.Color;

public abstract class SystemLayerFinder {
    private String layerName;
    private LayerManagerProxy layerManagerProxy;

    public SystemLayerFinder(String layerName, LayerManagerProxy layerManagerProxy) {
        this.layerManagerProxy = layerManagerProxy;
        this.layerName = layerName;
    }

    public String getLayerName() {
        return this.layerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer createLayer() {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset dataset = new FeatureDataset(schema);
        NonSavePromptingLayer layer = new NonSavePromptingLayer(this.layerName, Color.blue, dataset, this.layerManagerProxy.getLayerManager());
        boolean firingEvents = this.layerManagerProxy.getLayerManager().isFiringEvents();
        this.layerManagerProxy.getLayerManager().setFiringEvents(false);
        try {
            this.applyStyles(layer);
        }
        finally {
            this.layerManagerProxy.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layerManagerProxy.getLayerManager().addLayer(StandardCategoryNames.SYSTEM, layer);
        return layer;
    }

    public Layer getLayer() {
        Layer layer = null;
        LayerManager layerManager = this.layerManagerProxy.getLayerManager();
        if (layerManager != null) {
            layer = layerManager.getLayer(this.layerName);
        }
        return layer;
    }

    protected abstract void applyStyles(Layer var1);

    public static class NonSavePromptingLayer
    extends Layer {
        public NonSavePromptingLayer() {
        }

        public NonSavePromptingLayer(String name, Color fillColor, FeatureCollection featureCollection, LayerManager layerManager) {
            super(name, fillColor, featureCollection, layerManager);
        }

        public boolean isFeatureCollectionModified() {
            return false;
        }
    }
}

