/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.AbstractLoadSaveDatasetPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;

public abstract class AbstractSaveDatasetAsPlugIn
extends AbstractLoadSaveDatasetPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Assert.isTrue((this.getDataSourceQueries().size() == 1 ? 1 : 0) != 0);
        DataSourceQuery dataSourceQuery = (DataSourceQuery)this.getDataSourceQueries().iterator().next();
        Assert.isTrue((boolean)dataSourceQuery.getDataSource().isWritable());
        monitor.report(I18N.get("datasource.SaveDatasetAsPlugIn.saving") + " " + dataSourceQuery.toString() + "...");
        Connection connection = dataSourceQuery.getDataSource().getConnection();
        try {
            connection.executeUpdate(dataSourceQuery.getQuery(), context.getSelectedLayer(0).getFeatureCollectionWrapper(), monitor);
        }
        finally {
            connection.close();
        }
        context.getSelectedLayer(0).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }
}

