/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WorkbenchPropertiesFile
implements WorkbenchProperties {
    private ErrorHandler errorHandler;
    private Element root1;
    private Element root2;

    public WorkbenchPropertiesFile(File file, ErrorHandler errorHandler) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        this.root1 = document.getRootElement();
        this.root2 = null;
        this.errorHandler = errorHandler;
    }

    public WorkbenchPropertiesFile(File file1, File file2, ErrorHandler errorHandler) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document1 = builder.build(file1);
        Document document2 = builder.build(file2);
        this.root1 = document1.getRootElement();
        this.root2 = document2.getRootElement();
        this.errorHandler = errorHandler;
    }

    public List getPlugInClasses() {
        return this.getPlugInClasses(null);
    }

    public List getPlugInClasses(ClassLoader classLoader) {
        ArrayList plugInClasses = new ArrayList();
        for (Element plugInElement : this.root1.getChildren("plug-in")) {
            try {
                plugInClasses.add(Class.forName(plugInElement.getTextTrim(), false, classLoader));
            }
            catch (ClassNotFoundException e) {
                this.errorHandler.handleThrowable(e);
            }
        }
        if (this.root2 != null) {
            for (Element plugInElement : this.root2.getChildren("plug-in")) {
                try {
                    plugInClasses.add(Class.forName(plugInElement.getTextTrim(), false, classLoader));
                }
                catch (ClassNotFoundException e) {
                    this.errorHandler.handleThrowable(e);
                }
            }
        }
        return plugInClasses;
    }

    public List getInputDriverClasses() throws ClassNotFoundException {
        ArrayList inputDriverClasses = new ArrayList();
        for (Element inputDriverElement : this.root1.getChildren("input-driver")) {
            inputDriverClasses.add(Class.forName(inputDriverElement.getTextTrim()));
        }
        if (this.root2 != null) {
            for (Element inputDriverElement : this.root2.getChildren("input-driver")) {
                inputDriverClasses.add(Class.forName(inputDriverElement.getTextTrim()));
            }
        }
        return inputDriverClasses;
    }

    public List getOutputDriverClasses() throws ClassNotFoundException {
        ArrayList outputDriverClasses = new ArrayList();
        for (Element outputDriverElement : this.root1.getChildren("output-driver")) {
            outputDriverClasses.add(Class.forName(outputDriverElement.getTextTrim()));
        }
        if (this.root2 != null) {
            for (Element outputDriverElement : this.root2.getChildren("output-driver")) {
                outputDriverClasses.add(Class.forName(outputDriverElement.getTextTrim()));
            }
        }
        return outputDriverClasses;
    }

    public List getConfigurationClasses() throws ClassNotFoundException {
        ArrayList getConfigurationClasses = new ArrayList();
        for (Element configurationElement : this.root1.getChildren("extension")) {
            getConfigurationClasses.add(Class.forName(configurationElement.getTextTrim()));
        }
        if (this.root2 != null) {
            for (Element configurationElement : this.root2.getChildren("extension")) {
                getConfigurationClasses.add(Class.forName(configurationElement.getTextTrim()));
            }
        }
        return getConfigurationClasses;
    }
}

